/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.debugger;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.debugger.SteppingKt;
import org.jetbrains.idea.devkit.debugger.ThreadState;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R.\u0010\b\u001a\"\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tj\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/devkit/debugger/SessionThreadsData;", "", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/Disposable;)V", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "threadStates", "Ljava/util/HashMap;", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "Lorg/jetbrains/idea/devkit/debugger/ThreadState;", "Lkotlin/collections/HashMap;", "isIdeRuntime", "", "setNonCancellableSection", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "resetNonCancellableSection", "getOrCreateThreadState", "isSteppingAdjustmentEnabled", "suspendContextImpl", "intellij.devkit.debugger"})
@SourceDebugExtension(value={"SMAP\nstepping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 stepping.kt\norg/jetbrains/idea/devkit/debugger/SessionThreadsData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1611#2,9:138\n1863#2:147\n1864#2:149\n1620#2:150\n1611#2,9:151\n1863#2:160\n1864#2:162\n1620#2:163\n774#2:165\n865#2,2:166\n1#3:148\n1#3:161\n1#3:164\n*S KotlinDebug\n*F\n+ 1 stepping.kt\norg/jetbrains/idea/devkit/debugger/SessionThreadsData\n*L\n93#1:138,9\n93#1:147\n93#1:149\n93#1:150\n94#1:151,9\n94#1:160\n94#1:162\n94#1:163\n120#1:165\n120#1:166,2\n93#1:148\n94#1:161\n*E\n"})
final class SessionThreadsData {
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final HashMap<ThreadReferenceProxyImpl, ThreadState> threadStates;
    private boolean isIdeRuntime;

    public SessionThreadsData(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.disposable = disposable;
        this.threadStates = new HashMap();
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    public final void setNonCancellableSection(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        try {
            if (!this.isSteppingAdjustmentEnabled(suspendContext)) {
                return;
            }
            ThreadState threadState = this.getOrCreateThreadState(suspendContext);
            if (threadState == null) {
                return;
            }
            ThreadState state = threadState;
            state.setNonCancellable(suspendContext, true);
        }
        catch (Exception e) {
            DebuggerUtilsImpl.logError((Throwable)e);
        }
    }

    public final void resetNonCancellableSection(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        try {
            Object it$iv$iv;
            boolean bl;
            SuspendContextImpl it;
            boolean bl2;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            if (!this.isSteppingAdjustmentEnabled(suspendContext)) {
                return;
            }
            List list = suspendContext.getDebugProcess().getSuspendManager().getPausedContexts();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPausedContexts(...)");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl2 = false;
                it = (SuspendContextImpl)element$iv$iv;
                boolean bl3 = false;
                if (it.getThread() == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl2 = false;
                it = (ThreadReferenceProxyImpl)element$iv$iv;
                boolean bl4 = false;
                if (this.threadStates.get(it) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List pausedThreads = (List)destination$iv$iv;
            for (ThreadState state : pausedThreads) {
                state.setNonCancellable(suspendContext, false);
            }
        }
        catch (Exception e) {
            DebuggerUtilsImpl.logError((Throwable)e);
        }
    }

    private final ThreadState getOrCreateThreadState(SuspendContextImpl suspendContext) {
        ThreadState state;
        ThreadState threadState;
        Object it;
        ObjectReference reference;
        ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContext.getThread();
        if (threadReferenceProxyImpl == null) {
            return null;
        }
        ThreadReferenceProxyImpl thread = threadReferenceProxyImpl;
        if (this.threadStates.containsKey(thread)) {
            return this.threadStates.get(thread);
        }
        ObjectReference objectReference = reference = SteppingKt.access$initializeThreadState(suspendContext);
        if (objectReference != null) {
            it = objectReference;
            boolean bl = false;
            threadState = new ThreadState((ObjectReference)it, false, 2, null);
        } else {
            threadState = null;
        }
        ThreadState threadState2 = state = threadState;
        it = threadState2;
        boolean bl = false;
        ((Map)this.threadStates).put(thread, it);
        return threadState2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSteppingAdjustmentEnabled(SuspendContextImpl suspendContextImpl) {
        boolean bl;
        void $this$filterTo$iv$iv;
        if (!Registry.Companion.is("devkit.debugger.prevent.pce.while.stepping")) {
            return false;
        }
        if (this.isIdeRuntime) {
            return true;
        }
        List list = suspendContextImpl.getVirtualMachineProxy().classesByName("com.intellij.openapi.progress.Cancellation");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classesByName(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ReferenceType p0 = (ReferenceType)element$iv$iv;
            boolean $i$f$isSteppingAdjustmentEnabled$stub_for_inlining = false;
            boolean bl2 = false;
            if (!p0.isPrepared()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cancellationClasses = (List)destination$iv$iv;
        boolean isIde = bl = !((Collection)cancellationClasses).isEmpty();
        boolean bl3 = false;
        if (isIde) {
            this.isIdeRuntime = true;
        }
        return bl;
    }
}

