/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.debugger;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.debugger.SteppingKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/idea/devkit/debugger/ThreadState;", "", "reference", "Lcom/sun/jdi/ObjectReference;", "state", "", "<init>", "(Lcom/sun/jdi/ObjectReference;Z)V", "getReference", "()Lcom/sun/jdi/ObjectReference;", "getState", "()Z", "setState", "(Z)V", "setNonCancellable", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "value", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.devkit.debugger"})
final class ThreadState {
    @NotNull
    private final ObjectReference reference;
    private boolean state;

    public ThreadState(@NotNull ObjectReference reference, boolean state) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        this.reference = reference;
        this.state = state;
    }

    public /* synthetic */ ThreadState(ObjectReference objectReference, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(objectReference, bl);
    }

    @NotNull
    public final ObjectReference getReference() {
        return this.reference;
    }

    public final boolean getState() {
        return this.state;
    }

    public final void setState(boolean bl) {
        this.state = bl;
    }

    public final void setNonCancellable(@NotNull SuspendContextImpl suspendContext, boolean value) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        if (value == this.state) {
            return;
        }
        this.state = value;
        Type type = this.reference.type();
        Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type com.sun.jdi.ClassType");
        Field field = ((ClassType)type).fieldByName("inNonCancelableSection");
        if (field == null) {
            return;
        }
        Field field2 = field;
        this.reference.setValue(field2, SteppingKt.access$booleanValue(suspendContext, value));
    }

    @NotNull
    public final ObjectReference component1() {
        return this.reference;
    }

    public final boolean component2() {
        return this.state;
    }

    @NotNull
    public final ThreadState copy(@NotNull ObjectReference reference, boolean state) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        return new ThreadState(reference, state);
    }

    public static /* synthetic */ ThreadState copy$default(ThreadState threadState, ObjectReference objectReference, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            objectReference = threadState.reference;
        }
        if ((n & 2) != 0) {
            bl = threadState.state;
        }
        return threadState.copy(objectReference, bl);
    }

    @NotNull
    public String toString() {
        return "ThreadState(reference=" + this.reference + ", state=" + this.state + ")";
    }

    public int hashCode() {
        int result = ((Object)this.reference).hashCode();
        result = result * 31 + Boolean.hashCode(this.state);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ThreadState)) {
            return false;
        }
        ThreadState threadState = (ThreadState)other;
        if (!Intrinsics.areEqual((Object)this.reference, (Object)threadState.reference)) {
            return false;
        }
        return this.state == threadState.state;
    }
}

