/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.Stubbed;
import com.intellij.util.xml.SubTagList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.dom.impl.PluginPsiClassConverter;

@Presentation(typeName="Extension Point")
public interface ExtensionPoint
extends DomElement {
    @NotNull
    public XmlTag getXmlTag();

    @Stubbed
    @NameValue
    @NotNull
    public GenericAttributeValue<String> getName();

    @Attribute(value="qualifiedName")
    @Stubbed
    public GenericAttributeValue<String> getQualifiedName();

    @Stubbed
    @Convert(value=PluginPsiClassConverter.class)
    @NotNull
    public GenericAttributeValue<PsiClass> getInterface();

    @Stubbed
    @Attribute(value="beanClass")
    @Convert(value=PluginPsiClassConverter.class)
    @NotNull
    public GenericAttributeValue<PsiClass> getBeanClass();

    @NotNull
    public GenericAttributeValue<Area> getArea();

    @Attribute(value="dynamic")
    @Stubbed
    @NotNull
    public GenericAttributeValue<Boolean> getDynamic();

    @Stubbed
    @SubTagList(value="with")
    @NotNull
    public List<With> getWithElements();

    public With addWith();

    @NotNull
    @NlsSafe
    public String getEffectiveQualifiedName();

    @Nullable
    public PsiClass getEffectiveClass();

    @Nullable
    public PsiClass getExtensionPointClass();

    @Nullable
    public String getExtensionPointClassName();

    @Nullable
    public DomElement getExtensionPointClassNameElement();

    @Nullable
    @NlsSafe
    public String getNamePrefix();

    public List<PsiField> collectMissingWithTags();

    @NotNull
    public Status getExtensionPointStatus();

    @Nullable
    public static ExtensionPoint resolveFromDeclaration(PsiElement declaration) {
        DomElement domElement = null;
        if (declaration instanceof PomTargetPsiElement) {
            PomTarget pomTarget = ((PomTargetPsiElement)declaration).getTarget();
            if (pomTarget instanceof DomTarget) {
                domElement = ((DomTarget)pomTarget).getDomElement();
            }
        } else if (declaration instanceof XmlTag) {
            domElement = DomUtil.getDomElement((PsiElement)declaration);
        }
        return (ExtensionPoint)ObjectUtils.tryCast((Object)domElement, ExtensionPoint.class);
    }

    public static interface Status {
        public Kind getKind();

        @Nullable
        public String getAdditionalData();

        public static enum Kind {
            DEFAULT,
            UNRESOLVED_CLASS,
            DEPRECATED,
            ADDITIONAL_DEPRECATED,
            OBSOLETE,
            INTERNAL_API,
            EXPERIMENTAL_API,
            SCHEDULED_FOR_REMOVAL_API;

        }
    }

    public static enum Area {
        IDEA_PROJECT,
        IDEA_MODULE,
        IDEA_APPLICATION;

    }
}

