/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiPackage;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DefinesXml;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Stubbed;
import com.intellij.util.xml.SubTag;
import com.intellij.util.xml.SubTagList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Actions;
import org.jetbrains.idea.devkit.dom.ApplicationComponents;
import org.jetbrains.idea.devkit.dom.ContentDescriptor;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.DependencyDescriptor;
import org.jetbrains.idea.devkit.dom.ExtensionPoints;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.Helpset;
import org.jetbrains.idea.devkit.dom.IdeaVersion;
import org.jetbrains.idea.devkit.dom.Listeners;
import org.jetbrains.idea.devkit.dom.ModuleComponents;
import org.jetbrains.idea.devkit.dom.PluginModule;
import org.jetbrains.idea.devkit.dom.ProductDescriptor;
import org.jetbrains.idea.devkit.dom.ProjectComponents;
import org.jetbrains.idea.devkit.dom.Vendor;
import org.jetbrains.idea.devkit.dom.impl.IdeaPluginPackageConverter;

@DefinesXml
@Presentation(icon="AllIcons.Nodes.Plugin", typeName="Plugin")
@Stubbed
public interface IdeaPlugin
extends DomElement {
    @NonNls
    public static final String TAG_NAME = "idea-plugin";

    @Nullable
    @NlsSafe
    public String getPluginId();

    default public boolean hasRealPluginId() {
        String pluginId = this.getPluginId();
        return pluginId != null && !pluginId.equals("com.intellij");
    }

    default public boolean isV2Descriptor() {
        return DomUtil.hasXml(this.getPackage()) || DomUtil.hasXml((DomElement)this.getContent()) || DomUtil.hasXml((DomElement)this.getDependencies());
    }

    @SubTag(value="product-descriptor")
    @NotNull
    public ProductDescriptor getProductDescriptor();

    @SubTag(value="content")
    @Stubbed
    @NotNull
    public ContentDescriptor getContent();

    @SubTag(value="dependencies")
    @Stubbed
    @NotNull
    public DependencyDescriptor getDependencies();

    @NameValue
    @Stubbed
    @NotNull
    public GenericDomValue<String> getId();

    @Attribute(value="version")
    @Deprecated
    @NotNull
    public GenericAttributeValue<Integer> getIdeaPluginVersion();

    @NotNull
    public GenericAttributeValue<String> getUrl();

    @Deprecated
    @NotNull
    public GenericAttributeValue<Boolean> getUseIdeaClassloader();

    @NotNull
    public GenericAttributeValue<Boolean> getAllowBundledUpdate();

    @Stubbed
    @NotNull
    public GenericAttributeValue<Boolean> getImplementationDetail();

    @NotNull
    public GenericAttributeValue<Boolean> getRequireRestart();

    @Stubbed
    @Convert(value=IdeaPluginPackageConverter.class)
    @NotNull
    public GenericAttributeValue<PsiPackage> getPackage();

    @Stubbed
    @Required(value=false)
    @NotNull
    public GenericDomValue<String> getName();

    @NotNull
    public GenericDomValue<String> getDescription();

    @Required(value=false)
    @NotNull
    public GenericDomValue<String> getVersion();

    @NotNull
    public Vendor getVendor();

    @NotNull
    public GenericDomValue<String> getChangeNotes();

    @Stubbed
    @NotNull
    public IdeaVersion getIdeaVersion();

    @NotNull
    public GenericDomValue<String> getCategory();

    @Stubbed
    @NotNull
    public GenericDomValue<String> getResourceBundle();

    @Stubbed
    @SubTagList(value="depends")
    @NotNull
    public List<? extends Dependency> getDepends();

    @SubTagList(value="depends")
    public Dependency addDependency();

    @SubTagList(value="incompatible-with")
    @NotNull
    public List<GenericDomValue<String>> getIncompatibilities();

    @Stubbed
    @SubTagList(value="module")
    @NotNull
    public List<? extends PluginModule> getModules();

    @SubTagList(value="extensions")
    @Stubbed
    @NotNull
    public List<? extends Extensions> getExtensions();

    public Extensions addExtensions();

    @Stubbed
    @SubTagList(value="extensionPoints")
    @NotNull
    public List<? extends ExtensionPoints> getExtensionPoints();

    public ExtensionPoints addExtensionPoints();

    @SubTagList(value="application-components")
    @NotNull
    public List<? extends ApplicationComponents> getApplicationComponents();

    public ApplicationComponents addApplicationComponents();

    @SubTagList(value="project-components")
    @NotNull
    public List<? extends ProjectComponents> getProjectComponents();

    public ProjectComponents addProjectComponents();

    @SubTagList(value="module-components")
    @NotNull
    public List<? extends ModuleComponents> getModuleComponents();

    public ModuleComponents addModuleComponents();

    @SubTagList(value="actions")
    @Stubbed
    @NotNull
    public List<? extends Actions> getActions();

    public Actions addActions();

    @SubTagList(value="applicationListeners")
    @NotNull
    public List<? extends Listeners> getApplicationListeners();

    @SubTagList(value="projectListeners")
    @NotNull
    public List<? extends Listeners> getProjectListeners();

    @Deprecated
    @NotNull
    public List<? extends Helpset> getHelpsets();
}

