/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Stubbed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;

@Presentation(icon="AllIcons.Vcs.Branch")
public interface IdeaVersion
extends DomElement {
    @Required
    @Stubbed
    @Convert(value=BuildNumberConverter.class)
    @NotNull
    public GenericAttributeValue<BuildNumber> getSinceBuild();

    @Stubbed
    @Convert(value=BuildNumberConverter.class)
    @NotNull
    public GenericAttributeValue<BuildNumber> getUntilBuild();

    @Deprecated
    @NotNull
    public GenericAttributeValue<String> getMin();

    @Deprecated
    @NotNull
    public GenericAttributeValue<String> getMax();

    public static class BuildNumberConverter
    extends Converter<BuildNumber> {
        @Nullable
        public BuildNumber fromString(@Nullable String s, @NotNull ConvertContext context) {
            if (context == null) {
                BuildNumberConverter.$$$reportNull$$$0(0);
            }
            return s == null ? null : BuildNumber.fromStringOrNull((String)s);
        }

        @Nullable
        public String toString(@Nullable BuildNumber number, @NotNull ConvertContext context) {
            if (context == null) {
                BuildNumberConverter.$$$reportNull$$$0(1);
            }
            return number == null ? null : number.asString();
        }

        @Nullable
        public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
            if (context == null) {
                BuildNumberConverter.$$$reportNull$$$0(2);
            }
            return DevKitBundle.message("inspections.plugin.xml.invalid.build.number", s);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "context";
            objectArray2[1] = "org/jetbrains/idea/devkit/dom/IdeaVersion$BuildNumberConverter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getErrorMessage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

