/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OverrideText
extends DomElement {
    @Required
    @Convert(value=PlaceConverter.class, soft=true)
    @NotNull
    public GenericAttributeValue<PsiField> getPlace();

    @Required(value=false)
    @Convert(value=PlaceConverter.class, soft=true)
    @NotNull
    public GenericAttributeValue<PsiField> getUseTextOfPlace();

    @Required(value=false)
    @NotNull
    public GenericAttributeValue<String> getText();

    public static class PlaceConverter
    extends ResolvingConverter<PsiField> {
        @NonNls
        private static final String PLACES_CLASSNAME_SUFFIX = "Places";

        @Nullable
        public PsiField fromString(final @Nullable String s, @NotNull ConvertContext context) {
            if (context == null) {
                PlaceConverter.$$$reportNull$$$0(0);
            }
            if (s == null) {
                return null;
            }
            CommonProcessors.FindProcessor<PsiField> resolve = new CommonProcessors.FindProcessor<PsiField>(){

                protected boolean accept(PsiField field) {
                    return s.equals(PlaceConverter.getPlaceName(field));
                }
            };
            PlaceConverter.processAllActionPlaces(context, (Processor<PsiField>)resolve);
            return (PsiField)resolve.getFoundValue();
        }

        @Nullable
        public String toString(@Nullable PsiField field, @NotNull ConvertContext context) {
            if (context == null) {
                PlaceConverter.$$$reportNull$$$0(1);
            }
            return field != null ? field.getName() : null;
        }

        @Nullable
        public LookupElement createLookupElement(PsiField field) {
            return LookupElementBuilder.create((Object)field, (String)Objects.requireNonNull(PlaceConverter.getPlaceName(field))).withStrikeoutness(field.isDeprecated()).withTailText(" (" + field.getName() + ")").withTypeText(Objects.requireNonNull(field.getContainingClass()).getName());
        }

        @NotNull
        public Collection<PsiField> getVariants(@NotNull ConvertContext context) {
            if (context == null) {
                PlaceConverter.$$$reportNull$$$0(2);
            }
            CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
            PlaceConverter.processAllActionPlaces(context, (Processor<PsiField>)collectProcessor);
            Collection collection = collectProcessor.getResults();
            if (collection == null) {
                PlaceConverter.$$$reportNull$$$0(3);
            }
            return collection;
        }

        private static void processAllActionPlaces(ConvertContext context, Processor<PsiField> fieldProcessor) {
            GlobalSearchScope scope = context.getSearchScope();
            if (scope == null) {
                return;
            }
            AllClassesSearch.search((SearchScope)context.getSearchScope(), (Project)context.getProject(), s -> s.endsWith(PLACES_CLASSNAME_SUFFIX)).forEach(psiClass -> ContainerUtil.process((Object[])psiClass.getFields(), psiField -> {
                if (!psiField.hasModifierProperty("public")) {
                    return true;
                }
                if (PlaceConverter.getPlaceName(psiField) == null) {
                    return true;
                }
                return fieldProcessor.process(psiField);
            }));
        }

        @Nullable
        private static String getPlaceName(PsiField field) {
            PsiExpression initializer = field.getInitializer();
            return initializer != null ? (String)Pair.getSecond((Pair)StringExpressionHelper.evaluateExpression((PsiElement)initializer)) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/dom/OverrideText$PlaceConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/dom/OverrideText$PlaceConverter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariants";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

