/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.dom.impl.ExtensionDomExtender;

public abstract class ExtensionPointImpl
implements ExtensionPoint {
    @NonNls
    private static final Set<String> EXTENSION_POINT_CLASS_ATTRIBUTE_NAMES = Set.of("implementationClass", "implementation", "instance", "factoryClass", "extenderClass", "className");
    private static final Map<String, String> ADDITIONAL_DEPRECATED_EP = Map.of("com.intellij.definitionsSearch", "com.intellij.definitionsScopedSearch", "com.intellij.dom.fileDescription", "com.intellij.dom.fileMetaData", "com.intellij.exportable", "");

    @Override
    @Nullable
    public PsiClass getEffectiveClass() {
        return DomUtil.hasXml(this.getInterface()) ? (PsiClass)this.getInterface().getValue() : (PsiClass)this.getBeanClass().getValue();
    }

    @Override
    @Nullable
    public PsiClass getExtensionPointClass() {
        GenericAttributeValue<PsiClass> attribute = this.findExtensionPointClassAttribute();
        if (attribute == null) {
            return null;
        }
        return (PsiClass)attribute.getValue();
    }

    @Override
    @Nullable
    public String getExtensionPointClassName() {
        GenericAttributeValue<PsiClass> attribute = this.findExtensionPointClassAttribute();
        if (attribute == null) {
            return null;
        }
        return attribute.getStringValue();
    }

    @Nullable
    private GenericAttributeValue<PsiClass> findExtensionPointClassAttribute() {
        DomElement domElement = this.getExtensionPointClassNameElement();
        if (domElement == null) {
            return null;
        }
        if (domElement instanceof With) {
            With with = (With)domElement;
            return with.getImplements();
        }
        GenericAttributeValue genericAttributeValue = (GenericAttributeValue)domElement;
        return genericAttributeValue;
    }

    @Override
    @Nullable
    public DomElement getExtensionPointClassNameElement() {
        if (DomUtil.hasXml(this.getInterface())) {
            return this.getInterface();
        }
        List<With> elements = this.getWithElements();
        if (elements.size() == 1) {
            return elements.get(0);
        }
        for (With element : elements) {
            String attributeName = element.getAttribute().getStringValue();
            if (attributeName == null || !EXTENSION_POINT_CLASS_ATTRIBUTE_NAMES.contains(attributeName)) continue;
            return element;
        }
        return null;
    }

    @Override
    @Nullable
    public String getNamePrefix() {
        if (DomUtil.hasXml(this.getQualifiedName())) {
            return null;
        }
        IdeaPlugin plugin = (IdeaPlugin)this.getParentOfType(IdeaPlugin.class, false);
        if (plugin == null) {
            return null;
        }
        return StringUtil.notNullize((String)plugin.getPluginId(), (String)"com.intellij");
    }

    @Override
    @NotNull
    public String getEffectiveQualifiedName() {
        if (DomUtil.hasXml(this.getQualifiedName())) {
            String string = StringUtil.notNullize((String)this.getQualifiedName().getRawText());
            if (string == null) {
                ExtensionPointImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = this.getNamePrefix() + "." + StringUtil.notNullize((String)this.getName().getRawText());
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public List<PsiField> collectMissingWithTags() {
        PsiClass beanClass = (PsiClass)this.getBeanClass().getValue();
        if (beanClass == null) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        for (PsiField field : beanClass.getAllFields()) {
            String fieldName = field.getName();
            if (!Extension.isClassField(fieldName) || ExtensionDomExtender.findWithElement(this.getWithElements(), field) != null) continue;
            result.add(field);
        }
        return result;
    }

    @Override
    @NotNull
    public ExtensionPoint.Status getExtensionPointStatus() {
        return new ExtensionPoint.Status(){

            @Override
            public ExtensionPoint.Status.Kind getKind() {
                PsiClass effectiveClass = ExtensionPointImpl.this.getEffectiveClass();
                if (effectiveClass == null) {
                    return ExtensionPoint.Status.Kind.UNRESOLVED_CLASS;
                }
                if (ADDITIONAL_DEPRECATED_EP.containsKey(ExtensionPointImpl.this.getEffectiveQualifiedName())) {
                    return ExtensionPoint.Status.Kind.ADDITIONAL_DEPRECATED;
                }
                if (effectiveClass.hasAnnotation(ApiStatus.Internal.class.getCanonicalName())) {
                    return ExtensionPoint.Status.Kind.INTERNAL_API;
                }
                if (effectiveClass.hasAnnotation(ApiStatus.ScheduledForRemoval.class.getCanonicalName())) {
                    return ExtensionPoint.Status.Kind.SCHEDULED_FOR_REMOVAL_API;
                }
                if (effectiveClass.hasAnnotation(ApiStatus.Experimental.class.getCanonicalName())) {
                    return ExtensionPoint.Status.Kind.EXPERIMENTAL_API;
                }
                if (effectiveClass.hasAnnotation(ApiStatus.Obsolete.class.getCanonicalName())) {
                    return ExtensionPoint.Status.Kind.OBSOLETE;
                }
                if (effectiveClass.isDeprecated()) {
                    PsiAnnotation deprecatedAnno = effectiveClass.getAnnotation("java.lang.Deprecated");
                    if (deprecatedAnno != null && AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)deprecatedAnno, (String)"forRemoval") == Boolean.TRUE) {
                        return ExtensionPoint.Status.Kind.SCHEDULED_FOR_REMOVAL_API;
                    }
                    return ExtensionPoint.Status.Kind.DEPRECATED;
                }
                return ExtensionPoint.Status.Kind.DEFAULT;
            }

            @Override
            @Nullable
            public String getAdditionalData() {
                ExtensionPoint.Status.Kind kind = this.getKind();
                if (kind == ExtensionPoint.Status.Kind.ADDITIONAL_DEPRECATED) {
                    return StringUtil.nullize((String)ADDITIONAL_DEPRECATED_EP.get(ExtensionPointImpl.this.getEffectiveQualifiedName()));
                }
                if (kind == ExtensionPoint.Status.Kind.SCHEDULED_FOR_REMOVAL_API) {
                    PsiClass effectiveClass = ExtensionPointImpl.this.getEffectiveClass();
                    assert (effectiveClass != null);
                    PsiAnnotation scheduledAnno = effectiveClass.getAnnotation(ApiStatus.ScheduledForRemoval.class.getCanonicalName());
                    if (scheduledAnno == null) {
                        return null;
                    }
                    return AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)scheduledAnno, (String)"inVersion");
                }
                return null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/ExtensionPointImpl", "getEffectiveQualifiedName"));
    }
}

