/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class ExtensionPointPropertyNameConverter
extends ResolvingConverter<PsiField> {
    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            ExtensionPointPropertyNameConverter.$$$reportNull$$$0(0);
        }
        return DevKitBundle.message("plugin.xml.convert.extension.property.cannot.resolve", s);
    }

    @NotNull
    public Collection<? extends PsiField> getVariants(@NotNull ConvertContext context) {
        PsiClass aClass;
        if (context == null) {
            ExtensionPointPropertyNameConverter.$$$reportNull$$$0(1);
        }
        if ((aClass = ExtensionPointPropertyNameConverter.getEPBeanClass(context)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                ExtensionPointPropertyNameConverter.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        for (PsiField field : aClass.getAllFields()) {
            PsiClass resolved;
            PsiType type;
            if (field.hasModifierProperty("static") || !((type = field.getType()) instanceof PsiClassType) || (resolved = ((PsiClassType)type).resolve()) == null || !"java.lang.String".equals(resolved.getQualifiedName())) continue;
            result.add(field);
        }
        ArrayList<PsiField> arrayList = result;
        if (arrayList == null) {
            ExtensionPointPropertyNameConverter.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public LookupElement createLookupElement(PsiField field) {
        String fieldName = (String)ObjectUtils.chooseNotNull((Object)this.getAnnotationValue(field), (Object)field.getName());
        return JavaLookupElementBuilder.forField((PsiField)field, (String)fieldName, null);
    }

    @Nullable
    public PsiField fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        if (context == null) {
            ExtensionPointPropertyNameConverter.$$$reportNull$$$0(4);
        }
        if (s == null) {
            return null;
        }
        PsiClass value = ExtensionPointPropertyNameConverter.getEPBeanClass(context);
        if (value == null) {
            return null;
        }
        PsiField field = value.findFieldByName(s, true);
        if (field != null && this.getAnnotationValue(field) == null) {
            return field;
        }
        return this.findFieldByAnnotationValue(value, s);
    }

    @Nullable
    private PsiField findFieldByAnnotationValue(PsiClass psiClass, @NotNull String attrNameToFind) {
        if (attrNameToFind == null) {
            ExtensionPointPropertyNameConverter.$$$reportNull$$$0(5);
        }
        for (PsiField psiField : psiClass.getAllFields()) {
            if (psiField.hasModifierProperty("static") || !attrNameToFind.equals(this.getAnnotationValue(psiField))) continue;
            return psiField;
        }
        return null;
    }

    protected Class<? extends Annotation> getAnnotationClass() {
        return Attribute.class;
    }

    @Nullable
    private String getAnnotationValue(PsiField field) {
        return ExtensionPointPropertyNameConverter.getAnnotationValue(field, this.getAnnotationClass());
    }

    @Nullable
    public static String getAnnotationValue(PsiField psiField, Class<? extends Annotation> annotationClass) {
        PsiMethod getter = PropertyUtilBase.findGetterForField((PsiField)psiField);
        PsiMethod setter = PropertyUtilBase.findSetterForField((PsiField)psiField);
        PsiAnnotation attrAnno = PsiUtil.findAnnotation(annotationClass, new PsiMember[]{psiField, getter, setter});
        if (attrAnno != null) {
            return AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)attrAnno, (String)"value");
        }
        return null;
    }

    @Nullable
    public String toString(@Nullable PsiField field, @NotNull ConvertContext context) {
        if (context == null) {
            ExtensionPointPropertyNameConverter.$$$reportNull$$$0(6);
        }
        return field == null ? null : field.getName();
    }

    @Nullable
    private static PsiClass getEPBeanClass(ConvertContext context) {
        ExtensionPoint ep = (ExtensionPoint)context.getInvocationElement().getParentOfType(ExtensionPoint.class, true);
        if (ep == null) {
            return null;
        }
        return (PsiClass)ep.getBeanClass().getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/impl/ExtensionPointPropertyNameConverter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrNameToFind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/ExtensionPointPropertyNameConverter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFieldByAnnotationValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class ForTag
    extends ExtensionPointPropertyNameConverter {
        @Override
        protected Class<? extends Annotation> getAnnotationClass() {
            return Tag.class;
        }
    }
}

