/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;

public abstract class ExtensionsImpl
implements Extensions {
    @Override
    public List<Extension> collectExtensions() {
        SmartList extensions = new SmartList();
        List descriptions = this.getGenericInfo().getCollectionChildrenDescriptions();
        for (AbstractDomChildrenDescription description : descriptions) {
            extensions.addAll(description.getValues((DomElement)this));
        }
        return extensions;
    }

    @Override
    public Extension addExtension(String qualifiedEPName) {
        Extension extension = this.addExtension();
        XmlTag tag = extension.getXmlTag();
        tag.setName(StringUtil.trimStart((String)qualifiedEPName, (String)this.getEpPrefix()));
        return extension;
    }

    @Override
    @NotNull
    public String getEpPrefix() {
        String prefix = this.getDefaultExtensionNs().getStringValue();
        if (prefix == null) {
            IdeaPlugin ideaPlugin = (IdeaPlugin)this.getParentOfType(IdeaPlugin.class, true);
            String string = prefix = ideaPlugin == null ? null : StringUtil.notNullize((String)ideaPlugin.getPluginId(), (String)"com.intellij");
        }
        if (prefix == null) {
            prefix = this.getXmlns().getStringValue();
        }
        return prefix != null ? prefix + "." : "";
    }
}

