/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.PluginModule;
import org.jetbrains.idea.devkit.dom.impl.IdeaPluginConverterBase;
import org.jetbrains.idea.devkit.dom.index.PluginIdModuleIndex;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public final class IdeaPluginConverter
extends IdeaPluginConverterBase {
    private static final Condition<IdeaPlugin> NON_CORE_PLUGINS = plugin -> plugin.hasRealPluginId();

    @NotNull
    public Collection<? extends IdeaPlugin> getVariants(@NotNull ConvertContext context) {
        if (context == null) {
            IdeaPluginConverter.$$$reportNull$$$0(0);
        }
        Collection<IdeaPlugin> plugins = IdeaPluginConverter.getAllPluginsWithoutSelf(context);
        List list = ContainerUtil.filter(plugins, NON_CORE_PLUGINS);
        if (list == null) {
            IdeaPluginConverter.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public Set<String> getAdditionalVariants(@NotNull ConvertContext context) {
        if (context == null) {
            IdeaPluginConverter.$$$reportNull$$$0(2);
        }
        HashSet<String> result = new HashSet<String>();
        for (IdeaPlugin ideaPlugin : IdeaPluginConverter.getAllPluginsWithoutSelf(context)) {
            for (PluginModule pluginModule : ideaPlugin.getModules()) {
                ContainerUtil.addIfNotNull(result, (Object)((String)pluginModule.getValue().getValue()));
            }
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            IdeaPluginConverter.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    public IdeaPlugin fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        if (context == null) {
            IdeaPluginConverter.$$$reportNull$$$0(4);
        }
        return s == null ? null : (IdeaPlugin)ContainerUtil.getFirstItem(PluginIdModuleIndex.findPlugins(context.getInvocationElement(), s));
    }

    private static Collection<IdeaPlugin> getAllPluginsWithoutSelf(ConvertContext context) {
        IdeaPlugin self = (IdeaPlugin)context.getInvocationElement().getParentOfType(IdeaPlugin.class, true);
        if (self == null) {
            return Collections.emptyList();
        }
        Collection<IdeaPlugin> plugins = IdeaPluginConverter.getAllPlugins(context.getProject());
        return ContainerUtil.filter(plugins, plugin -> !Comparing.strEqual((String)self.getPluginId(), (String)plugin.getPluginId()));
    }

    private static Collection<IdeaPlugin> getAllPlugins(Project project) {
        if (DumbService.isDumb((Project)project)) {
            return Collections.emptyList();
        }
        return (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            GlobalSearchScope scope = GlobalSearchScopesCore.projectProductionScope((Project)project).union((SearchScope)ProjectScope.getLibrariesScope((Project)project));
            return CachedValueProvider.Result.create(DescriptorUtil.getPlugins(project, scope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/impl/IdeaPluginConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/IdeaPluginConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalVariants";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

