/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;

public class KeymapConverter
extends ResolvingConverter<XmlFile> {
    @Nullable
    public XmlFile fromString(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            KeymapConverter.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        return (XmlFile)ContainerUtil.find(KeymapConverter.getKeymapFiles(context), file -> s.equals(KeymapConverter.getKeymapName(file)));
    }

    @Nullable
    public String toString(@Nullable XmlFile file, @NotNull ConvertContext context) {
        if (context == null) {
            KeymapConverter.$$$reportNull$$$0(1);
        }
        return file != null ? KeymapConverter.getKeymapName(file) : null;
    }

    @NotNull
    public Collection<? extends XmlFile> getVariants(@NotNull ConvertContext context) {
        if (context == null) {
            KeymapConverter.$$$reportNull$$$0(2);
        }
        return KeymapConverter.getKeymapFiles(context);
    }

    @Nullable
    public LookupElement createLookupElement(XmlFile file) {
        return LookupElementBuilder.create((String)KeymapConverter.getKeymapName(file));
    }

    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            KeymapConverter.$$$reportNull$$$0(3);
        }
        return DevKitBundle.message("plugin.xml.convert.keymap.cannot.resolve", s);
    }

    private static String getKeymapName(XmlFile file) {
        return FileUtilRt.getNameWithoutExtension((String)file.getName());
    }

    @NotNull
    private static List<XmlFile> getKeymapFiles(ConvertContext context) {
        PsiPackage keymapsPackage = JavaPsiFacade.getInstance((Project)context.getProject()).findPackage("keymaps");
        if (keymapsPackage == null) {
            List<XmlFile> list = Collections.emptyList();
            if (list == null) {
                KeymapConverter.$$$reportNull$$$0(4);
            }
            return list;
        }
        Object[] files = keymapsPackage.getFiles(context.getFile().getResolveScope());
        List list = ContainerUtil.findAll((Object[])files, XmlFile.class);
        if (list == null) {
            KeymapConverter.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/impl/KeymapConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/KeymapConverter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeymapFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

