/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl.productModules;

import com.intellij.java.workspace.files.JavaSourceFiles;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H$J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/devkit/dom/impl/productModules/ResourceFileInModuleConverter;", "Lcom/intellij/util/xml/ResolvingConverter;", "Lcom/intellij/psi/PsiFile;", "<init>", "()V", "fromString", "s", "", "context", "Lcom/intellij/util/xml/ConvertContext;", "resolveModule", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "getErrorMessage", "findResourceFile", "module", "project", "Lcom/intellij/openapi/project/Project;", "getResourceFilePath", "moduleName", "toString", "t", "getVariants", "", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nResourceFileInModuleConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceFileInModuleConverter.kt\norg/jetbrains/idea/devkit/dom/impl/productModules/ResourceFileInModuleConverter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1148#2:62\n1317#2:63\n1318#2:65\n1149#2:66\n1#3:64\n*S KotlinDebug\n*F\n+ 1 ResourceFileInModuleConverter.kt\norg/jetbrains/idea/devkit/dom/impl/productModules/ResourceFileInModuleConverter\n*L\n49#1:62\n49#1:63\n49#1:65\n49#1:66\n49#1:64\n*E\n"})
public abstract class ResourceFileInModuleConverter
extends ResolvingConverter<PsiFile> {
    @Nullable
    public PsiFile fromString(@Nullable String s, @NotNull ConvertContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ModuleEntity moduleEntity = this.resolveModule(s, context);
        if (moduleEntity == null) {
            return null;
        }
        ModuleEntity module = moduleEntity;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.findResourceFile(module, project);
    }

    private final ModuleEntity resolveModule(String s, ConvertContext context) {
        String string = s;
        if (string == null) {
            return null;
        }
        String moduleName = string;
        ModuleId moduleId = new ModuleId(moduleName);
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (ModuleEntity)WorkspaceModelKt.getWorkspaceModel((Project)project).getCurrentSnapshot().resolve((SymbolicEntityId)moduleId);
    }

    @Nullable
    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ModuleEntity module = this.resolveModule(s, context);
        if (module == null) {
            Object[] objectArray = new Object[]{s};
            return DevKitBundle.message("error.message.cannot.find.module", objectArray);
        }
        Object[] objectArray = new Object[]{this.getResourceFilePath(module.getName()), module.getName()};
        return DevKitBundle.message("error.message.cannot.find.resource.file", objectArray);
    }

    private final PsiFile findResourceFile(ModuleEntity module, Project project) {
        VirtualFile file;
        VirtualFile virtualFile = file = JavaSourceFiles.findResourceFileByRelativePath((ModuleEntity)module, (String)this.getResourceFilePath(module.getName()));
        return virtualFile != null ? VirtualFileUtil.findPsiFile((VirtualFile)virtualFile, (Project)project) : null;
    }

    @NotNull
    protected abstract String getResourceFilePath(@NotNull String var1);

    @Nullable
    public String toString(@Nullable PsiFile t, @NotNull ConvertContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiFile psiFile = t;
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
        return module != null ? module.getName() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<PsiFile> getVariants(@NotNull ConvertContext context) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Sequence sequence = WorkspaceModelKt.getWorkspaceModel((Project)project).getCurrentSnapshot().entities(ModuleEntity.class);
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            ModuleEntity it = (ModuleEntity)element$iv;
            boolean bl2 = false;
            Project project2 = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (this.findResourceFile(it, project2) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return var3_3;
    }
}

