/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.dom.index.ExtensionPointIndex;
import org.jetbrains.idea.devkit.dom.index.PluginXmlIndexBase;

public final class ExtensionPointClassIndex
extends PluginXmlIndexBase<String, IntList> {
    private static final ID<String, IntList> NAME = ID.create((String)"devkit.ExtensionPointClassIndex");
    private final DataExternalizer<IntList> myValueExternalizer = new DataExternalizer<IntList>(){

        public void save(@NotNull DataOutput out, IntList values) throws IOException {
            int size;
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((size = values.size()) == 1) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(-values.getInt(0)));
                return;
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)size);
            for (int i = 0; i < size; ++i) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)values.getInt(i));
            }
        }

        public IntList read(@NotNull DataInput in) throws IOException {
            int count;
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((count = DataInputOutputUtil.readINT((DataInput)in)) < 0) {
                return new IntArrayList(new int[]{-count});
            }
            IntArrayList result = new IntArrayList(count);
            for (int i = 0; i < count; ++i) {
                result.add(DataInputOutputUtil.readINT((DataInput)in));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/devkit/dom/index/ExtensionPointClassIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public DataExternalizer<IntList> getValueExternalizer() {
        DataExternalizer<IntList> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            ExtensionPointClassIndex.$$$reportNull$$$0(0);
        }
        return dataExternalizer;
    }

    @Override
    protected Map<String, IntList> performIndexing(IdeaPlugin plugin) {
        Map result = FactoryMap.create(key -> new IntArrayList());
        ExtensionPointIndex.indexExtensionPoints(plugin, (Consumer<? super ExtensionPoint>)((Consumer)point -> {
            int offset = point.getXmlTag().getTextOffset();
            if (ExtensionPointClassIndex.addToIndex(result, point.getInterface(), offset)) {
                return;
            }
            ExtensionPointClassIndex.addToIndex(result, point.getBeanClass(), offset);
            for (With element : point.getWithElements()) {
                ExtensionPointClassIndex.addToIndex(result, element.getImplements(), offset);
            }
        }));
        return result;
    }

    private static boolean addToIndex(Map<String, IntList> map, GenericAttributeValue<PsiClass> value, int offset) {
        if (!DomUtil.hasXml(value)) {
            return false;
        }
        map.get(value.getStringValue()).add(offset);
        return true;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            ExtensionPointClassIndex.$$$reportNull$$$0(1);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public ID<String, IntList> getName() {
        ID<String, IntList> iD = NAME;
        if (iD == null) {
            ExtensionPointClassIndex.$$$reportNull$$$0(2);
        }
        return iD;
    }

    public int getVersion() {
        return 11;
    }

    public static List<ExtensionPoint> getExtensionPointsByClass(Project project, PsiClass psiClass, GlobalSearchScope scope) {
        String key = ClassUtil.getJVMClassName((PsiClass)psiClass);
        if (key == null) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        DomManager domManager = DomManager.getDomManager((Project)project);
        FileBasedIndex.getInstance().processValues(NAME, (Object)key, null, (arg_0, arg_1) -> ExtensionPointClassIndex.lambda$getExtensionPointsByClass$2((List)result, psiManager, domManager, arg_0, arg_1), scope);
        return result;
    }

    private static /* synthetic */ boolean lambda$getExtensionPointsByClass$2(List result, PsiManager psiManager, DomManager domManager, VirtualFile file, IntList value) {
        for (Integer integer : value) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)ExtensionPointIndex.getExtensionPointDom(psiManager, domManager, file, integer));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/devkit/dom/index/ExtensionPointClassIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

