/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.Listeners;
import org.jetbrains.idea.devkit.dom.index.PluginXmlIndexBase;
import org.jetbrains.idea.devkit.dom.index.RegistrationEntry;
import org.jetbrains.idea.devkit.dom.index.RegistrationIndexer;

public final class IdeaPluginRegistrationIndex
extends PluginXmlIndexBase<String, List<RegistrationEntry>> {
    private static final int INDEX_VERSION = 8;
    private static final ID<String, List<RegistrationEntry>> NAME = ID.create((String)"IdeaPluginRegistrationIndex");
    private final DataExternalizer<List<RegistrationEntry>> myValueExternalizer = new DataExternalizer<List<RegistrationEntry>>(){

        public void save(@NotNull DataOutput out, List<RegistrationEntry> values) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            DataInputOutputUtilRt.writeSeq((DataOutput)out, values, entry -> {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)entry.getRegistrationType().ordinal());
                DataInputOutputUtil.writeINT((DataOutput)out, (int)entry.getOffset());
            });
        }

        public List<RegistrationEntry> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return DataInputOutputUtilRt.readSeq((DataInput)in, () -> {
                RegistrationEntry.RegistrationType type = RegistrationEntry.RegistrationType.values()[DataInputOutputUtil.readINT((DataInput)in)];
                int offset = DataInputOutputUtil.readINT((DataInput)in);
                return new RegistrationEntry(type, offset);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/devkit/dom/index/IdeaPluginRegistrationIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public ID<String, List<RegistrationEntry>> getName() {
        ID<String, List<RegistrationEntry>> iD = NAME;
        if (iD == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    protected Map<String, List<RegistrationEntry>> performIndexing(IdeaPlugin plugin) {
        return new RegistrationIndexer(plugin).indexFile();
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(1);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<List<RegistrationEntry>> getValueExternalizer() {
        DataExternalizer<List<RegistrationEntry>> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(2);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 18;
    }

    public static boolean isRegisteredClass(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, null);
    }

    public static boolean isRegisteredComponentInterface(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.COMPONENT_INTERFACE);
    }

    public static boolean isRegisteredApplicationComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.APPLICATION_COMPONENT);
    }

    public static boolean isRegisteredProjectComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.PROJECT_COMPONENT);
    }

    public static boolean isRegisteredModuleComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.MODULE_COMPONENT);
    }

    public static boolean isRegisteredActionOrGroup(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.ACTION);
    }

    public static boolean isRegisteredListenerTopic(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.LISTENER_TOPIC);
    }

    public static boolean processComponent(Project project, PsiClass componentInterfaceOrImplementationClass, GlobalSearchScope scope, Processor<? extends Component> processor) {
        return IdeaPluginRegistrationIndex.processAll(project, componentInterfaceOrImplementationClass, scope, EnumSet.of(RegistrationEntry.RegistrationType.APPLICATION_COMPONENT, RegistrationEntry.RegistrationType.PROJECT_COMPONENT, RegistrationEntry.RegistrationType.MODULE_COMPONENT, RegistrationEntry.RegistrationType.COMPONENT_INTERFACE), processor);
    }

    public static boolean processListener(@NotNull Project project, PsiClass listenerClass, GlobalSearchScope scope, Processor<? extends Listeners.Listener> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(3);
        }
        return IdeaPluginRegistrationIndex.processAll(project, listenerClass, scope, EnumSet.of(RegistrationEntry.RegistrationType.APPLICATION_LISTENER, RegistrationEntry.RegistrationType.PROJECT_LISTENER), processor);
    }

    public static boolean processListenerTopic(@NotNull Project project, PsiClass topicClass, GlobalSearchScope scope, Processor<? extends Listeners.Listener> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(4);
        }
        return IdeaPluginRegistrationIndex.processAll(project, topicClass, scope, EnumSet.of(RegistrationEntry.RegistrationType.LISTENER_TOPIC), processor);
    }

    private static boolean isRegisteredClass(PsiClass psiClass, GlobalSearchScope scope, @Nullable RegistrationEntry.RegistrationType type) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        return !FileBasedIndex.getInstance().processValues(NAME, (Object)qualifiedName, null, (file, value) -> ContainerUtil.process((List)value, entry -> {
            RegistrationEntry.RegistrationType registrationType = entry.getRegistrationType();
            if (type == null) {
                return !registrationType.isClass();
            }
            return registrationType != type;
        }), scope);
    }

    public static boolean processAllActionOrGroup(@NotNull Project project, GlobalSearchScope scope, Processor<? extends ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(5);
        }
        HashSet keys = new HashSet();
        FileBasedIndex.getInstance().processAllKeys(NAME, s -> keys.add(s), scope, null);
        return ContainerUtil.process(keys, s -> IdeaPluginRegistrationIndex.processActionOrGroup(project, s, scope, processor));
    }

    public static boolean processActionOrGroupClass(@NotNull Project project, PsiClass actionOrGroupClass, GlobalSearchScope scope, Processor<? extends ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(6);
        }
        return IdeaPluginRegistrationIndex.processAll(project, actionOrGroupClass, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION), processor);
    }

    public static boolean processActionOrGroup(@NotNull Project project, @NotNull String actionOrGroupId, GlobalSearchScope scope, Processor<? extends ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(7);
        }
        if (actionOrGroupId == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(8);
        }
        return IdeaPluginRegistrationIndex.processAll(project, actionOrGroupId, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION_ID, RegistrationEntry.RegistrationType.ACTION_GROUP_ID), processor);
    }

    public static boolean processAction(@NotNull Project project, @NotNull String actionId, GlobalSearchScope scope, Processor<? extends ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(9);
        }
        if (actionId == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(10);
        }
        return IdeaPluginRegistrationIndex.processAll(project, actionId, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION_ID), processor);
    }

    public static boolean processGroup(@NotNull Project project, @NotNull String actionGroupId, GlobalSearchScope scope, Processor<? extends ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(11);
        }
        if (actionGroupId == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(12);
        }
        return IdeaPluginRegistrationIndex.processAll(project, actionGroupId, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION_GROUP_ID), processor);
    }

    private static <T extends DomElement> boolean processAll(@NotNull Project project, @NotNull PsiClass psiClass, GlobalSearchScope scope, EnumSet<RegistrationEntry.RegistrationType> types, Processor<T> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(13);
        }
        if (psiClass == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(14);
        }
        String qualifiedName = psiClass.getQualifiedName();
        assert (qualifiedName != null);
        return IdeaPluginRegistrationIndex.processAll(project, qualifiedName, scope, types, processor);
    }

    private static <T extends DomElement> boolean processAll(@NotNull Project project, @NotNull String key, GlobalSearchScope scope, EnumSet<RegistrationEntry.RegistrationType> types, Processor<T> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(15);
        }
        if (key == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(16);
        }
        RegistrationEntry.RegistrationDomType registrationDomType = ((RegistrationEntry.RegistrationType)((Object)ContainerUtil.getFirstItem(types))).getRegistrationDomType();
        return IdeaPluginRegistrationIndex.processIndexEntries(project, key, scope, types, (Processor<XmlTag>)((Processor)tag -> {
            DomElement domElement = DomManager.getDomManager((Project)project).getDomElement(tag);
            DomElement t = registrationDomType.isUseParentDom() ? (DomElement)DomUtil.getParentOfType((DomElement)domElement, registrationDomType.getDomClass(), (boolean)false) : (DomElement)ObjectUtils.tryCast((Object)domElement, registrationDomType.getDomClass());
            if (t == null) {
                return true;
            }
            return processor.process((Object)t);
        }));
    }

    private static boolean processIndexEntries(@NotNull Project project, @NotNull String key, GlobalSearchScope scope, EnumSet<RegistrationEntry.RegistrationType> types, Processor<XmlTag> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(17);
        }
        if (key == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(18);
        }
        return FileBasedIndex.getInstance().processValues(NAME, (Object)key, null, (file, value) -> {
            for (RegistrationEntry entry : value) {
                XmlTag xmlTag;
                PsiFile psiFile;
                if (!types.contains((Object)entry.getRegistrationType()) || !((psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof XmlFile) || processor.process((Object)(xmlTag = (XmlTag)AstLoadingFilter.forceAllowTreeLoading((PsiFile)psiFile, () -> {
                    PsiElement psiElement = psiFile.findElementAt(entry.getOffset());
                    return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class, (boolean)false);
                })))) continue;
                return false;
            }
            return true;
        }, scope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/index/IdeaPluginRegistrationIndex";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionOrGroupId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroupId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/index/IdeaPluginRegistrationIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processListenerTopic";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processAllActionOrGroup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processActionOrGroupClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processActionOrGroup";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processGroup";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processIndexEntries";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18 -> new IllegalArgumentException(string);
        };
    }
}

