/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.PluginModule;
import org.jetbrains.idea.devkit.dom.index.PluginXmlIndexBase;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public final class PluginIdModuleIndex
extends PluginXmlIndexBase<String, Void> {
    private static final ID<String, Void> NAME = ID.create((String)"PluginIdModuleIndex");

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            PluginIdModuleIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataExternalizer<Void> getValueExternalizer() {
        VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
        if (voidDataExternalizer == null) {
            PluginIdModuleIndex.$$$reportNull$$$0(1);
        }
        return voidDataExternalizer;
    }

    @Override
    protected Map<String, Void> performIndexing(IdeaPlugin plugin) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(StringUtil.notNullize((String)plugin.getPluginId()));
        for (DomElement module : PluginIdModuleIndex.getChildrenWithoutIncludes(plugin, "module")) {
            ContainerUtil.addIfNotNull(ids, (Object)((PluginModule)module).getValue().getStringValue());
        }
        return ContainerUtil.newHashMap(ids, Collections.nCopies(ids.size(), null));
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PluginIdModuleIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    public int getVersion() {
        return 12;
    }

    public static Collection<VirtualFile> getFiles(@NotNull Project project, @NotNull String idOrModule) {
        if (project == null) {
            PluginIdModuleIndex.$$$reportNull$$$0(3);
        }
        if (idOrModule == null) {
            PluginIdModuleIndex.$$$reportNull$$$0(4);
        }
        GlobalSearchScope scope = GlobalSearchScopesCore.projectProductionScope((Project)project).union((SearchScope)LibraryScopeCache.getInstance((Project)project).getLibrariesOnlyScope());
        return FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)idOrModule, scope);
    }

    public static List<IdeaPlugin> findPlugins(@NotNull DomElement place, @NotNull String idOrModule) {
        if (place == null) {
            PluginIdModuleIndex.$$$reportNull$$$0(5);
        }
        if (idOrModule == null) {
            PluginIdModuleIndex.$$$reportNull$$$0(6);
        }
        Project project = place.getManager().getProject();
        Collection<VirtualFile> vFiles = PluginIdModuleIndex.getFiles(project, idOrModule);
        return JBIterable.from(vFiles).map(arg_0 -> ((PsiManager)PsiManager.getInstance((Project)project)).findFile(arg_0)).filter(XmlFile.class).map(DescriptorUtil::getIdeaPlugin).filter(Conditions.notNull()).toList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/index/PluginIdModuleIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idOrModule";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/index/PluginIdModuleIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPlugins";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

