/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

abstract class PluginXmlIndexBase<K, V>
extends FileBasedIndexExtension<K, V> {
    protected static final int BASE_INDEX_VERSION = 10;

    PluginXmlIndexBase() {
    }

    protected abstract Map<K, V> performIndexing(IdeaPlugin var1);

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{XmlFileType.INSTANCE});
    }

    @NotNull
    public DataIndexer<K, V, FileContent> getIndexer() {
        return new DataIndexer<K, V, FileContent>(){

            @NotNull
            public Map<K, V> map(@NotNull FileContent inputData) {
                IdeaPlugin plugin;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((plugin = PluginXmlIndexBase.obtainIdeaPlugin(inputData)) == null) {
                    Map map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                Map map = PluginXmlIndexBase.this.performIndexing(plugin);
                if (map == null) {
                    1.$$$reportNull$$$0(2);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/dom/index/PluginXmlIndexBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/dom/index/PluginXmlIndexBase$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    protected static List<? extends DomElement> getChildrenWithoutIncludes(DomElement parent, @NonNls String tagName) {
        AbstractCollectionChildDescription collectionChildDescription = (AbstractCollectionChildDescription)parent.getGenericInfo().getCollectionChildDescription(tagName);
        DomInvocationHandler handler = DomManagerImpl.getDomInvocationHandler((DomElement)parent);
        assert (handler != null) : parent;
        return handler.getCollectionChildren(collectionChildDescription, false);
    }

    @Nullable
    private static IdeaPlugin obtainIdeaPlugin(@NotNull FileContent content) {
        if (content == null) {
            PluginXmlIndexBase.$$$reportNull$$$0(0);
        }
        if (!PluginXmlIndexBase.looksLikeIdeaPluginXml(content)) {
            return null;
        }
        PsiFile file = content.getPsiFile();
        if (!(file instanceof XmlFile)) {
            return null;
        }
        return DescriptorUtil.getIdeaPlugin((XmlFile)file);
    }

    private static boolean looksLikeIdeaPluginXml(@NotNull FileContent content) {
        if (content == null) {
            PluginXmlIndexBase.$$$reportNull$$$0(1);
        }
        CharSequence text = content.getContentAsText();
        int idx = 0;
        while (true) {
            if (idx == -1) {
                return false;
            }
            if ((idx = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"<", (int)idx)) == -1) {
                return false;
            }
            if (CharArrayUtil.regionMatches((CharSequence)text, (int)idx, (CharSequence)"<!--")) {
                idx = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"-->", (int)idx);
                continue;
            }
            if (!CharArrayUtil.regionMatches((CharSequence)text, (int)idx, (CharSequence)"<?")) break;
            idx = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"?>", (int)idx);
        }
        return CharArrayUtil.regionMatches((CharSequence)text, (int)idx, (CharSequence)"<idea-plugin");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "content";
        objectArray2[1] = "org/jetbrains/idea/devkit/dom/index/PluginXmlIndexBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "obtainIdeaPlugin";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "looksLikeIdeaPluginXml";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

