/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.util.xml.DomElement;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.Listeners;

class RegistrationEntry {
    private final RegistrationType myRegistrationType;
    private final int myOffset;

    RegistrationEntry(RegistrationType registrationType, int offset) {
        this.myRegistrationType = registrationType;
        this.myOffset = offset;
    }

    RegistrationType getRegistrationType() {
        return this.myRegistrationType;
    }

    int getOffset() {
        return this.myOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrationEntry entry = (RegistrationEntry)o;
        if (this.myOffset != entry.myOffset) {
            return false;
        }
        return this.myRegistrationType == entry.myRegistrationType;
    }

    public int hashCode() {
        int result = this.myRegistrationType.hashCode();
        result = 31 * result + this.myOffset;
        return result;
    }

    static enum RegistrationType {
        ACTION(true, RegistrationDomType.ACTION_OR_GROUP),
        APPLICATION_COMPONENT(true, RegistrationDomType.COMPONENT),
        PROJECT_COMPONENT(true, RegistrationDomType.COMPONENT),
        MODULE_COMPONENT(true, RegistrationDomType.COMPONENT),
        COMPONENT_INTERFACE(true, RegistrationDomType.COMPONENT),
        ACTION_ID(false, RegistrationDomType.ACTION_OR_GROUP),
        ACTION_GROUP_ID(false, RegistrationDomType.ACTION_OR_GROUP),
        APPLICATION_LISTENER(true, RegistrationDomType.LISTENER),
        PROJECT_LISTENER(true, RegistrationDomType.LISTENER),
        LISTENER_TOPIC(true, RegistrationDomType.LISTENER);

        private final boolean myIsClass;
        private final RegistrationDomType myRegistrationDomType;

        private RegistrationType(boolean isClass, RegistrationDomType registrationDomType) {
            this.myIsClass = isClass;
            this.myRegistrationDomType = registrationDomType;
        }

        boolean isClass() {
            return this.myIsClass;
        }

        RegistrationDomType getRegistrationDomType() {
            return this.myRegistrationDomType;
        }
    }

    static enum RegistrationDomType {
        ACTION_OR_GROUP(ActionOrGroup.class, false),
        COMPONENT(Component.class, true),
        LISTENER(Listeners.Listener.class, true);

        private final Class<? extends DomElement> myDomClass;
        private final boolean myUseParentDom;

        private RegistrationDomType(Class<? extends DomElement> domClazz, boolean useParentDom) {
            this.myDomClass = domClazz;
            this.myUseParentDom = useParentDom;
        }

        Class<? extends DomElement> getDomClass() {
            return this.myDomClass;
        }

        boolean isUseParentDom() {
            return this.myUseParentDom;
        }
    }
}

