/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.driver;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.driver.RemoteMethodReferenceSearcherKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070\tH\u0002\u00a8\u0006\n"}, d2={"findRemoteMethods", "", "Lcom/intellij/psi/PsiMethod;", "psiMethod", "processRemoteTargetClass", "", "classToProcess", "Lcom/intellij/psi/PsiClass;", "consumer", "Lcom/intellij/util/Processor;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nRemoteImplementationSearchers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteImplementationSearchers.kt\norg/jetbrains/idea/devkit/driver/RemoteImplementationSearchersKt\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n171#2:101\n171#2:111\n3829#3:102\n4344#3,2:103\n827#4:105\n855#4,2:106\n774#4:108\n865#4,2:109\n*S KotlinDebug\n*F\n+ 1 RemoteImplementationSearchers.kt\norg/jetbrains/idea/devkit/driver/RemoteImplementationSearchersKt\n*L\n61#1:101\n90#1:111\n65#1:102\n65#1:103,2\n66#1:105\n66#1:106,2\n71#1:108\n71#1:109,2\n*E\n"})
public final class RemoteImplementationSearchersKt {
    @NotNull
    public static final Collection<PsiMethod> findRemoteMethods(@NotNull PsiMethod psiMethod) {
        PsiMethod it;
        Object $this$filterNotTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        if (!psiMethod.isValid()) {
            return CollectionsKt.emptyList();
        }
        PsiElement $this$toUElementOfType$iv = (PsiElement)psiMethod;
        boolean $i$f$toUElementOfType = false;
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
        if (uMethod == null || (uMethod = UastUtils.getContainingUClass((UElement)((UElement)uMethod))) == null) {
            return CollectionsKt.emptyList();
        }
        UMethod uClass = uMethod;
        Project project = psiMethod.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiClass psiClass = RemoteMethodReferenceSearcherKt.getTargetRemoteClass(project, (UClass)uClass);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass remoteClass = psiClass;
        PsiMethod[] psiMethodArray = remoteClass.getAllMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getAllMethods(...)");
        Object $this$filter$iv = psiMethodArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            PsiMethod it2 = (PsiMethod)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it2.getName(), (Object)psiMethod.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object t : $this$filterNotTo$iv$iv) {
            it = (PsiMethod)t;
            boolean bl = false;
            if (it.hasModifier(JvmModifier.PRIVATE) || it.hasModifier(JvmModifier.PROTECTED) || it.hasModifier(JvmModifier.PACKAGE_LOCAL)) continue;
            destination$iv$iv.add(t);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (PsiMethod)t;
            boolean bl = false;
            if (!(it.getParameters().length == psiMethod.getParameters().length)) continue;
            destination$iv$iv.add(t);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean processRemoteTargetClass(PsiClass classToProcess, Processor<? super PsiClass> consumer) {
        Object object = ReadAction.compute(() -> RemoteImplementationSearchersKt.processRemoteTargetClass$lambda$3(classToProcess, consumer));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (Boolean)object;
    }

    private static final Boolean processRemoteTargetClass$lambda$3(PsiClass $classToProcess, Processor $consumer) {
        if (RemoteMethodReferenceSearcherKt.isRemoteInterface($classToProcess)) {
            PsiElement $this$toUElementOfType$iv = (PsiElement)$classToProcess;
            boolean $i$f$toUElementOfType = false;
            UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UClass.class);
            if (uClass == null) {
                return true;
            }
            UClass uClass2 = uClass;
            Project project = $classToProcess.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PsiClass targetClass = RemoteMethodReferenceSearcherKt.getTargetRemoteClass(project, uClass2);
            if (targetClass != null && !$consumer.process((Object)targetClass)) {
                return false;
            }
        }
        return true;
    }

    public static final /* synthetic */ boolean access$processRemoteTargetClass(PsiClass classToProcess, Processor consumer) {
        return RemoteImplementationSearchersKt.processRemoteTargetClass(classToProcess, (Processor<? super PsiClass>)consumer);
    }
}

