/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.driver;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.driver.RemoteImplementationSearchersKt;
import org.jetbrains.idea.devkit.driver.RemoteMethodReferenceSearcherKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/devkit/driver/RemoteMethodImplementationSearcher;", "Lcom/intellij/util/QueryExecutor;", "Lcom/intellij/psi/PsiMethod;", "Lcom/intellij/psi/search/searches/OverridingMethodsSearch$SearchParameters;", "<init>", "()V", "execute", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "intellij.devkit.core"})
public final class RemoteMethodImplementationSearcher
implements QueryExecutor<PsiMethod, OverridingMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull OverridingMethodsSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiMethod> consumer) {
        Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Object object = ReadAction.compute(() -> RemoteMethodImplementationSearcher.execute$lambda$0(queryParameters, consumer));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (Boolean)object;
    }

    private static final Boolean execute$lambda$0(OverridingMethodsSearch.SearchParameters $queryParameters, Processor $consumer) {
        if ($queryParameters.getMethod().hasModifier(JvmModifier.ABSTRACT) && RemoteMethodReferenceSearcherKt.isRemoteInterface($queryParameters.getMethod().getContainingClass())) {
            PsiMethod psiMethod = $queryParameters.getMethod();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"getMethod(...)");
            Collection<PsiMethod> remoteMethods = RemoteImplementationSearchersKt.findRemoteMethods(psiMethod);
            for (PsiMethod m : remoteMethods) {
                if ($consumer.process((Object)m)) continue;
                return false;
            }
        }
        return true;
    }
}

