/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.driver;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.driver.RemoteMethodReferenceSearcherKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/devkit/driver/RemoteMethodReferenceSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "intellij.devkit.core"})
public final class RemoteMethodReferenceSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        PsiMethod psiMethod = queryParameters.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"getMethod(...)");
        PsiMethod targetMethod = psiMethod;
        String methodName = (String)ReadAction.compute(() -> RemoteMethodReferenceSearcher.processQuery$lambda$0(targetMethod));
        Object[] objectArray = new Object[]{};
        queryParameters.getOptimizer().searchWord(methodName, (SearchScope)ReadAction.compute(() -> RemoteMethodReferenceSearcher.processQuery$lambda$1(targetMethod, queryParameters)), (short)1, true, (PsiElement)targetMethod, new RequestResultProcessor(targetMethod, methodName, objectArray){
            final /* synthetic */ PsiMethod $targetMethod;
            final /* synthetic */ String $methodName;
            {
                this.$targetMethod = $targetMethod;
                this.$methodName = $methodName;
                super($super_call_param$1);
            }

            public boolean processTextOccurrence(PsiElement element, int offsetInElement, Processor<? super PsiReference> consumer) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
                UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)element, UMethod.class);
                if (uMethod == null) {
                    return true;
                }
                UMethod method = uMethod;
                UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)method));
                if (uClass == null) {
                    return true;
                }
                UClass uClass2 = uClass;
                PsiMethod psiMethodFound = method.getJavaPsi();
                if (psiMethodFound.getParameters().length != this.$targetMethod.getParameters().length) {
                    return true;
                }
                PsiClass psiClass = psiMethodFound.getContainingClass();
                if (psiClass == null) {
                    return true;
                }
                PsiClass psiClass2 = psiClass;
                if (!RemoteMethodReferenceSearcherKt.isRemoteInterface(psiClass2)) {
                    return true;
                }
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                PsiClass psiClass3 = RemoteMethodReferenceSearcherKt.getTargetRemoteClass(project, uClass2);
                if (psiClass3 == null) {
                    return true;
                }
                PsiClass baseClass = psiClass3;
                PsiClass searchableClass = this.$targetMethod.getContainingClass();
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)searchableClass, (PsiClass)baseClass, (boolean)true) && !InheritanceUtil.isInheritorOrSelf((PsiClass)baseClass, (PsiClass)searchableClass, (boolean)true)) {
                    return true;
                }
                PsiReferenceBase psiReferenceBase = PsiReferenceBase.createSelfReference((PsiElement)element, (TextRange)new TextRange(offsetInElement, offsetInElement + this.$methodName.length()), (PsiElement)((PsiElement)this.$targetMethod));
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceBase, (String)"createSelfReference(...)");
                PsiReferenceBase reference = psiReferenceBase;
                return consumer.process((Object)reference);
            }
        });
    }

    private static final String processQuery$lambda$0(PsiMethod $targetMethod) {
        return $targetMethod.getName();
    }

    private static final SearchScope processQuery$lambda$1(PsiMethod $targetMethod, MethodReferencesSearch.SearchParameters $queryParameters) {
        if ($targetMethod.hasModifier(JvmModifier.PRIVATE) || $targetMethod.hasModifier(JvmModifier.PACKAGE_LOCAL) || $targetMethod.hasModifier(JvmModifier.PROTECTED)) {
            return (SearchScope)GlobalSearchScope.EMPTY_SCOPE;
        }
        PsiClass psiClass = $targetMethod.getContainingClass();
        if (psiClass == null) {
            return (SearchScope)GlobalSearchScope.EMPTY_SCOPE;
        }
        PsiClass searchableClass = psiClass;
        if (RemoteMethodReferenceSearcherKt.isRemoteInterface(searchableClass)) {
            return (SearchScope)GlobalSearchScope.EMPTY_SCOPE;
        }
        Project project = $targetMethod.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile psiFile = searchableClass.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return (SearchScope)GlobalSearchScope.EMPTY_SCOPE;
        }
        PsiFile file = psiFile;
        if (TestSourcesFilter.isTestSources((VirtualFile)file, (Project)project2) || FileIndexFacade.getInstance((Project)project2).isInLibrary((VirtualFile)file)) {
            return (SearchScope)GlobalSearchScope.EMPTY_SCOPE;
        }
        PsiClass psiClass2 = JavaPsiFacade.getInstance((Project)project2).findClass("com.intellij.driver.client.Remote", GlobalSearchScope.allScope((Project)project2));
        if (psiClass2 == null) {
            return (SearchScope)GlobalSearchScope.EMPTY_SCOPE;
        }
        PsiClass remoteClass = psiClass2;
        return remoteClass.getUseScope().intersectWith($queryParameters.getScopeDeterminedByUser());
    }
}

