/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.gradle;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.browsers.OpenUrlHyperlinkInfo;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.ui.JBColor;
import com.intellij.util.PsiNavigateUtil;
import java.awt.Color;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J0\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0012\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u0015\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/idea/devkit/gradle/PluginVerifierFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "VERIFICATION_REPORTS_DIRECTORY", "", "READING_PLUGIN_FROM", "READING_IDE_FROM", "DYNAMIC_PLUGIN_PASS", "DYNAMIC_PLUGIN_FAIL", "DYNAMIC_PLUGIN_URL", "VERIFICATION_REPORTS", "VERIFICATION_SAVED_TO", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "entireLength", "", "fileOrDirectoryLink", "text", "coloredWebLink", "color", "Lcom/intellij/ui/JBColor;", "linkUrl", "codeLocationLink", "prefixText", "showErrorHint", "", "CodeLocationHyperlinkInfo", "intellij.devkit.gradle"})
public final class PluginVerifierFilter
implements Filter {
    @NotNull
    private final Project project;
    @NotNull
    private final String VERIFICATION_REPORTS_DIRECTORY;
    @NotNull
    private final String READING_PLUGIN_FROM;
    @NotNull
    private final String READING_IDE_FROM;
    @NotNull
    private final String DYNAMIC_PLUGIN_PASS;
    @NotNull
    private final String DYNAMIC_PLUGIN_FAIL;
    @NotNull
    private final String DYNAMIC_PLUGIN_URL;
    @NotNull
    private final String VERIFICATION_REPORTS;
    @NotNull
    private final String VERIFICATION_SAVED_TO;

    public PluginVerifierFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.VERIFICATION_REPORTS_DIRECTORY = "Verification reports directory: ";
        this.READING_PLUGIN_FROM = "Reading plugin to check from ";
        this.READING_IDE_FROM = "Reading IDE from ";
        this.DYNAMIC_PLUGIN_PASS = "Plugin can probably be enabled or disabled without IDE restart";
        this.DYNAMIC_PLUGIN_FAIL = "Plugin probably cannot be enabled or disabled without IDE restart:";
        this.DYNAMIC_PLUGIN_URL = "https://plugins.jetbrains.com/docs/intellij/dynamic-plugins.html";
        this.VERIFICATION_REPORTS = "Verification reports for ";
        this.VERIFICATION_SAVED_TO = " saved to ";
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (StringsKt.startsWith$default((String)line, (String)"Plugin ", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)line, (CharSequence)" against ", (boolean)false, (int)2, null)) {
            int initialOffset = entireLength - line.length();
            int idx = StringsKt.indexOf$default((CharSequence)line, (String)": ", (int)0, (boolean)false, (int)6, null);
            if (idx == -1) {
                return null;
            }
            return new Filter.Result(initialOffset, initialOffset + idx + 1, null, new TextAttributes(JBColor.CYAN, null, JBColor.CYAN, EffectType.BOLD_DOTTED_LINE, 1));
        }
        if (StringsKt.startsWith$default((String)line, (String)this.VERIFICATION_REPORTS_DIRECTORY, (boolean)false, (int)2, null)) {
            return this.fileOrDirectoryLink(line, entireLength, this.VERIFICATION_REPORTS_DIRECTORY);
        }
        if (StringsKt.contains$default((CharSequence)line, (CharSequence)this.READING_PLUGIN_FROM, (boolean)false, (int)2, null)) {
            return this.fileOrDirectoryLink(line, entireLength, this.READING_PLUGIN_FROM);
        }
        if (StringsKt.contains$default((CharSequence)line, (CharSequence)this.READING_IDE_FROM, (boolean)false, (int)2, null)) {
            return this.fileOrDirectoryLink(line, entireLength, this.READING_IDE_FROM);
        }
        if (StringsKt.contains$default((CharSequence)line, (CharSequence)this.VERIFICATION_REPORTS, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)line, (CharSequence)this.VERIFICATION_SAVED_TO, (boolean)false, (int)2, null)) {
            return this.fileOrDirectoryLink(line, entireLength, this.VERIFICATION_SAVED_TO);
        }
        if (StringUtil.contains((CharSequence)line, (CharSequence)this.DYNAMIC_PLUGIN_PASS)) {
            JBColor jBColor = JBColor.GREEN;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"GREEN");
            return this.coloredWebLink(line, entireLength, this.DYNAMIC_PLUGIN_PASS, jBColor, this.DYNAMIC_PLUGIN_URL);
        }
        if (StringUtil.contains((CharSequence)line, (CharSequence)this.DYNAMIC_PLUGIN_FAIL)) {
            JBColor jBColor = JBColor.RED;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"RED");
            return this.coloredWebLink(line, entireLength, this.DYNAMIC_PLUGIN_FAIL, jBColor, this.DYNAMIC_PLUGIN_URL);
        }
        if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"in ", (boolean)false, (int)2, null)) {
            return null;
        }
        Filter.Result result = this.codeLocationLink(line, entireLength, "is invoked in ");
        if (result == null && (result = this.codeLocationLink(line, entireLength, "is accessed in ")) == null && (result = this.codeLocationLink(line, entireLength, "is overridden in class ")) == null) {
            result = this.codeLocationLink(line, entireLength, "is referenced in ");
        }
        return result;
    }

    private final Filter.Result fileOrDirectoryLink(String line, int entireLength, String text) {
        int initialOffset = entireLength - line.length();
        int idx = StringsKt.indexOf$default((CharSequence)line, (String)text, (int)0, (boolean)false, (int)6, null) + text.length();
        String string = line.substring(idx, line.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String path = string;
        return new Filter.Result(initialOffset + idx, initialOffset + line.length(), arg_0 -> PluginVerifierFilter.fileOrDirectoryLink$lambda$0(path, this, arg_0));
    }

    private final Filter.Result coloredWebLink(String line, int entireLength, String text, JBColor color, String linkUrl) {
        int idx = StringsKt.indexOf$default((CharSequence)line, (String)text, (int)0, (boolean)false, (int)6, null);
        int initialOffset = entireLength - line.length();
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES).clone();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"clone(...)");
        TextAttributes textAttributes2 = textAttributes;
        textAttributes2.setForegroundColor((Color)color);
        return new Filter.Result(initialOffset + idx, initialOffset + idx + text.length(), (HyperlinkInfo)new OpenUrlHyperlinkInfo(linkUrl), textAttributes2, textAttributes2);
    }

    private final Filter.Result codeLocationLink(String line, int entireLength, String prefixText) {
        String string;
        String string2;
        int n;
        if (!StringUtil.contains((CharSequence)line, (CharSequence)prefixText)) {
            return null;
        }
        int idx = StringsKt.indexOf$default((CharSequence)line, (String)prefixText, (int)0, (boolean)false, (int)6, null) + prefixText.length();
        int initialOffset = entireLength - line.length();
        String string3 = line.substring(idx, line.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String substring = string3;
        boolean hasColon = StringsKt.contains$default((CharSequence)substring, (char)':', (boolean)false, (int)2, null);
        String codeSignature = hasColon ? StringsKt.substringBefore$default((String)substring, (String)" : ", null, (int)2, null) : substring;
        boolean hasParen = StringsKt.contains$default((CharSequence)codeSignature, (char)'(', (boolean)false, (int)2, null);
        if (hasParen) {
            String string4 = codeSignature.substring(0, StringUtil.indexOf((CharSequence)codeSignature, (char)'('));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            n = StringsKt.lastIndexOf$default((CharSequence)string4, (char)'.', (int)0, (boolean)false, (int)6, null);
        } else {
            n = StringsKt.lastIndexOf$default((CharSequence)codeSignature, (char)'.', (int)0, (boolean)false, (int)6, null);
        }
        int lastDotIdx = n;
        if (hasColon || hasParen) {
            String string5 = codeSignature.substring(0, lastDotIdx);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        } else {
            string2 = codeSignature;
        }
        String classname = string2;
        if (hasParen) {
            String string6 = codeSignature.substring(lastDotIdx + 1, StringsKt.lastIndexOf$default((CharSequence)codeSignature, (char)'(', (int)0, (boolean)false, (int)6, null));
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
        } else {
            string = null;
        }
        String methodName = string;
        return new Filter.Result(initialOffset + idx, initialOffset + idx + codeSignature.length(), (HyperlinkInfo)new CodeLocationHyperlinkInfo(classname, methodName));
    }

    private final void showErrorHint(@NlsContexts.HintText String text) {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(arg_0 -> PluginVerifierFilter.showErrorHint$lambda$1(text, arg_0));
    }

    private static final void fileOrDirectoryLink$lambda$0(String $path, PluginVerifierFilter this$0, Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        File file = new File($path);
        if (!file.exists()) {
            String string = CodeInsightBundle.message((String)"declaration.navigation.nowhere.to.go", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this$0.showErrorHint(string);
            return;
        }
        if (file.isDirectory()) {
            RevealFileAction.openDirectory((File)file);
        } else {
            RevealFileAction.openFile((File)file);
        }
    }

    private static final void showErrorHint$lambda$1(String $text, DataContext it) {
        Intrinsics.checkNotNull((Object)it);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(it);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        HintManager.getInstance().showErrorHint(editor2, $text);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/devkit/gradle/PluginVerifierFilter$CodeLocationHyperlinkInfo;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "classname", "", "methodName", "<init>", "(Lorg/jetbrains/idea/devkit/gradle/PluginVerifierFilter;Ljava/lang/String;Ljava/lang/String;)V", "navigate", "", "it", "Lcom/intellij/openapi/project/Project;", "getNavigationTarget", "Lcom/intellij/psi/PsiElement;", "intellij.devkit.gradle"})
    public final class CodeLocationHyperlinkInfo
    implements HyperlinkInfo {
        @NotNull
        private final String classname;
        @Nullable
        private final String methodName;

        public CodeLocationHyperlinkInfo(@Nullable String classname, String methodName) {
            Intrinsics.checkNotNullParameter((Object)classname, (String)"classname");
            this.classname = classname;
            this.methodName = methodName;
        }

        public void navigate(@NotNull Project it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (DumbService.Companion.isDumb(PluginVerifierFilter.this.project)) {
                DumbService dumbService = DumbService.Companion.getInstance(PluginVerifierFilter.this.project);
                String string = CodeInsightBundle.message((String)"message.navigation.is.not.available.here.during.index.update", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                dumbService.showDumbModeNotificationForFunctionality(string, DumbModeBlockedFunctionality.GotoDeclarationOnly);
                return;
            }
            PsiElement navigationTarget = this.getNavigationTarget();
            if (navigationTarget == null) {
                String string = CodeInsightBundle.message((String)"declaration.navigation.nowhere.to.go", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                PluginVerifierFilter.this.showErrorHint(string);
                return;
            }
            PsiNavigateUtil.navigate((PsiElement)navigationTarget);
        }

        @Nullable
        public final PsiElement getNavigationTarget() {
            String outerClassName = StringsKt.substringBefore$default((String)this.classname, (String)"$", null, (int)2, null);
            PsiClass psiClass = CodeLocationHyperlinkInfo.getNavigationTarget$findClassInProjectScope(PluginVerifierFilter.this, outerClassName);
            if (psiClass == null) {
                psiClass = CodeLocationHyperlinkInfo.getNavigationTarget$findClassInProjectScope(PluginVerifierFilter.this, StringsKt.substringBeforeLast$default((String)outerClassName, (char)'.', null, (int)2, null));
            }
            if (psiClass == null) {
                return null;
            }
            if (this.methodName != null) {
                PsiMethod[] psiMethodArray = psiClass.findMethodsByName(this.methodName, false);
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
                PsiMethod psiMethod = (PsiMethod)ArraysKt.firstOrNull((Object[])psiMethodArray);
                if (psiMethod != null) {
                    return (PsiElement)psiMethod;
                }
            }
            return (PsiElement)psiClass;
        }

        private static final PsiClass getNavigationTarget$findClassInProjectScope(PluginVerifierFilter this$0, String fqn) {
            return JavaPsiFacade.getInstance((Project)this$0.project).findClass(fqn, GlobalSearchScopes.projectProductionScope((Project)this$0.project));
        }
    }
}

