/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.i18n;

import com.intellij.lang.properties.psi.I18nizedTextGenerator;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.ResourceBundleManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.actions.NewMessageBundleActionKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/idea/devkit/i18n/IntelliJProjectResourceBundleManager;", "Lcom/intellij/lang/properties/psi/ResourceBundleManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isActive", "", "context", "Lcom/intellij/psi/PsiFile;", "escapeValue", "", "value", "suggestPropertiesFiles", "", "contextModules", "", "Lcom/intellij/openapi/module/Module;", "getI18nizedTextGenerator", "Lcom/intellij/lang/properties/psi/I18nizedTextGenerator;", "getResourceBundle", "Lcom/intellij/psi/PsiClass;", "getTemplateName", "getConcatenationTemplateName", "canShowJavaCodeInfo", "intellij.devkit.i18n"})
@SourceDebugExtension(value={"SMAP\nIntelliJProjectResourceBundleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJProjectResourceBundleManager.kt\norg/jetbrains/idea/devkit/i18n/IntelliJProjectResourceBundleManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1628#2,3:67\n3193#2,10:70\n*S KotlinDebug\n*F\n+ 1 IntelliJProjectResourceBundleManager.kt\norg/jetbrains/idea/devkit/i18n/IntelliJProjectResourceBundleManager\n*L\n29#1:67,3\n31#1:70,10\n*E\n"})
public final class IntelliJProjectResourceBundleManager
extends ResourceBundleManager {
    public IntelliJProjectResourceBundleManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    public boolean isActive(@NotNull PsiFile context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return IntelliJProjectUtil.isIntelliJPlatformProject((Project)this.myProject);
    }

    @NotNull
    public String escapeValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return StringsKt.replace$default((String)value, (String)"&", (String)"\\&", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> suggestPropertiesFiles(@NotNull Set<Module> contextModules) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(contextModules, (String)"contextModules");
        Iterable iterable = contextModules;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Module module = (Module)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(NewMessageBundleActionKt.generateDefaultBundleName((Module)it));
        }
        HashSet preferredBundleNames = (HashSet)destination$iv;
        List files = super.suggestPropertiesFiles(contextModules);
        Intrinsics.checkNotNull((Object)files);
        Iterable $this$partition$iv = files;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (preferredBundleNames.contains(FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)it)))) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List preferredFiles = (List)pair.component1();
        List otherFiles = (List)pair.component2();
        return CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)preferredFiles, (Iterable)otherFiles));
    }

    @NotNull
    public I18nizedTextGenerator getI18nizedTextGenerator() {
        return new I18nizedTextGenerator(this){
            final /* synthetic */ IntelliJProjectResourceBundleManager this$0;
            {
                this.this$0 = $receiver;
            }

            public String getI18nizedText(String propertyKey, PropertiesFile propertiesFile, PsiElement context) {
                Intrinsics.checkNotNullParameter((Object)propertyKey, (String)"propertyKey");
                return this.getI18nizedConcatenationText(propertyKey, "", propertiesFile, context);
            }

            public String getI18nizedConcatenationText(String propertyKey, String parametersString, PropertiesFile propertiesFile, PsiElement context) {
                Intrinsics.checkNotNullParameter((Object)propertyKey, (String)"propertyKey");
                Intrinsics.checkNotNullParameter((Object)parametersString, (String)"parametersString");
                String bundleClassName = this.suggestBundleClassName(propertiesFile, context);
                Object args = ((CharSequence)parametersString).length() > 0 ? ", " + parametersString : "";
                return bundleClassName + ".message(\"" + propertyKey + "\"" + (String)args + ")";
            }

            private final String suggestBundleClassName(PropertiesFile propertiesFile, PsiElement context) {
                if (propertiesFile == null) {
                    return "UnknownBundle";
                }
                String string = propertiesFile.getVirtualFile().getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
                String bundleName = string;
                PsiElement psiElement = context;
                if (psiElement == null || (psiElement = psiElement.getResolveScope()) == null) {
                    GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)IntelliJProjectResourceBundleManager.access$getMyProject$p$s1332332379(this.this$0));
                    psiElement = globalSearchScope;
                    Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
                }
                PsiElement scope = psiElement;
                Object[] objectArray = PsiShortNamesCache.getInstance((Project)IntelliJProjectResourceBundleManager.access$getMyProject$p$s1332332379(this.this$0)).getClassesByName(bundleName, (GlobalSearchScope)scope);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getClassesByName(...)");
                Object[] classesByName = objectArray;
                Object object = (PsiClass)ArraysKt.firstOrNull((Object[])classesByName);
                if (object == null || (object = object.getQualifiedName()) == null) {
                    object = bundleName;
                }
                return object;
            }
        };
    }

    @Nullable
    public PsiClass getResourceBundle() {
        return null;
    }

    @Nullable
    public String getTemplateName() {
        return null;
    }

    @Nullable
    public String getConcatenationTemplateName() {
        return null;
    }

    public boolean canShowJavaCodeInfo() {
        return false;
    }

    public static final /* synthetic */ Project access$getMyProject$p$s1332332379(IntelliJProjectResourceBundleManager $this) {
        return $this.myProject;
    }
}

