/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.CancellationCheckInLoopsInspectionKt;
import org.jetbrains.idea.devkit.inspections.CancellationCheckProvider;
import org.jetbrains.idea.devkit.inspections.CancellationCheckProviders;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.CancellationCheckInLoopsFixProvider;
import org.jetbrains.idea.devkit.inspections.quickfix.CancellationCheckInLoopsFixProviders;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UForExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULoopExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\t*\u00020\rH\u0002J\f\u0010\u0014\u001a\u00020\t*\u00020\u0015H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0017*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/idea/devkit/inspections/CancellationCheckInLoopsInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "<init>", "()V", "buildInternalVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspectLoopExpression", "", "loopOrLambdaExpression", "Lorg/jetbrains/uast/UExpression;", "checkProvider", "Lorg/jetbrains/idea/devkit/inspections/CancellationCheckProvider;", "shouldBeRunOn", "uElement", "Lorg/jetbrains/uast/UElement;", "isLoopExpressionOrLoopMethodCall", "isLoopMethodCall", "Lorg/jetbrains/uast/UCallExpression;", "bodyExpressions", "", "getBodyExpressions", "(Lorg/jetbrains/uast/UExpression;)Ljava/util/List;", "getAnchor", "Lcom/intellij/psi/PsiElement;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nCancellationCheckInLoopsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CancellationCheckInLoopsInspection.kt\norg/jetbrains/idea/devkit/inspections/CancellationCheckInLoopsInspection\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,156:1\n18#2:157\n18#2:160\n18#2:161\n37#3,2:158\n*S KotlinDebug\n*F\n+ 1 CancellationCheckInLoopsInspection.kt\norg/jetbrains/idea/devkit/inspections/CancellationCheckInLoopsInspection\n*L\n86#1:157\n116#1:160\n150#1:161\n108#1:158,2\n*E\n"})
public final class CancellationCheckInLoopsInspection
extends DevKitUastInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        CancellationCheckProvider cancellationCheckProvider = (CancellationCheckProvider)CancellationCheckProviders.INSTANCE.forLanguage(holder.getFile().getLanguage());
        if (cancellationCheckProvider == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        CancellationCheckProvider checkProvider = cancellationCheckProvider;
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{ULoopExpression.class, UCallExpression.class};
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this, checkProvider, holder){
            final /* synthetic */ CancellationCheckInLoopsInspection this$0;
            final /* synthetic */ CancellationCheckProvider $checkProvider;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$checkProvider = $checkProvider;
                this.$holder = $holder;
            }

            public boolean visitForExpression(UForExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                CancellationCheckInLoopsInspection.access$inspectLoopExpression(this.this$0, (UExpression)node, this.$checkProvider, this.$holder);
                return true;
            }

            public boolean visitForEachExpression(UForEachExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                CancellationCheckInLoopsInspection.access$inspectLoopExpression(this.this$0, (UExpression)node, this.$checkProvider, this.$holder);
                return true;
            }

            public boolean visitWhileExpression(UWhileExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                CancellationCheckInLoopsInspection.access$inspectLoopExpression(this.this$0, (UExpression)node, this.$checkProvider, this.$holder);
                return true;
            }

            public boolean visitDoWhileExpression(UDoWhileExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                CancellationCheckInLoopsInspection.access$inspectLoopExpression(this.this$0, (UExpression)node, this.$checkProvider, this.$holder);
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public boolean visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (CancellationCheckInLoopsInspection.access$isLoopMethodCall(this.this$0, node)) {
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv = node.getValueArguments();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof ULambdaExpression)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    ULambdaExpression uLambdaExpression = (ULambdaExpression)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                    if (uLambdaExpression == null) {
                        return true;
                    }
                    ULambdaExpression lambdaExpression = uLambdaExpression;
                    CancellationCheckInLoopsInspection.access$inspectLoopExpression(this.this$0, (UExpression)lambdaExpression, this.$checkProvider, this.$holder);
                }
                return true;
            }
        }, (Class[])classArray, (boolean)false, (int)8, null);
    }

    private final void inspectLoopExpression(UExpression loopOrLambdaExpression, CancellationCheckProvider checkProvider, ProblemsHolder holder) {
        PsiElement firstExpressionInLoopSourcePsi;
        UExpression firstExpressionInLoop;
        UExpression uExpression;
        Object object;
        if (!(loopOrLambdaExpression instanceof ULoopExpression) && !(loopOrLambdaExpression instanceof ULambdaExpression)) {
            return;
        }
        if (!this.shouldBeRunOn((UElement)loopOrLambdaExpression)) {
            return;
        }
        UExpression uExpression2 = loopOrLambdaExpression;
        if (uExpression2 instanceof ULoopExpression) {
            object = loopOrLambdaExpression.getSourcePsi();
        } else if (uExpression2 instanceof ULambdaExpression) {
            UElement $this$getParentOfType_u24default$iv = (UElement)loopOrLambdaExpression;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            UCallExpression uCallExpression = (UCallExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UCallExpression.class, (boolean)strict$iv);
            object = uCallExpression != null ? uCallExpression.getSourcePsi() : null;
        } else {
            object = null;
        }
        if (object == null) {
            return;
        }
        PsiElement callContext = object;
        UExpression uExpression3 = (UExpression)CollectionsKt.firstOrNull(this.getBodyExpressions(loopOrLambdaExpression));
        if (uExpression3 != null) {
            UExpression it = uExpression3;
            boolean bl = false;
            uExpression = it instanceof UReturnExpression ? ((UReturnExpression)it).getReturnExpression() : it;
        } else {
            uExpression = null;
        }
        UExpression uExpression4 = firstExpressionInLoop = uExpression;
        boolean bl = uExpression4 != null ? this.isLoopExpressionOrLoopMethodCall(uExpression4) : false;
        if (bl) {
            return;
        }
        String cancellationCheckFqn = checkProvider.findCancellationCheckCall(callContext);
        UExpression uExpression5 = firstExpressionInLoop;
        Object object2 = firstExpressionInLoopSourcePsi = uExpression5 != null ? uExpression5.getSourcePsi() : null;
        if (firstExpressionInLoopSourcePsi != null && checkProvider.isCancellationCheckCall(firstExpressionInLoopSourcePsi, cancellationCheckFqn)) {
            return;
        }
        PsiElement psiElement = this.getAnchor(loopOrLambdaExpression);
        if (psiElement == null) {
            return;
        }
        PsiElement anchor = psiElement;
        CancellationCheckInLoopsFixProvider cancellationCheckInLoopsFixProvider = (CancellationCheckInLoopsFixProvider)CancellationCheckInLoopsFixProviders.INSTANCE.forLanguage(holder.getFile().getLanguage());
        if (cancellationCheckInLoopsFixProvider == null) {
            return;
        }
        CancellationCheckInLoopsFixProvider fixProvider = cancellationCheckInLoopsFixProvider;
        List<LocalQuickFix> fixes = fixProvider.getFixes(anchor, cancellationCheckFqn);
        Object[] objectArray = new Object[]{cancellationCheckFqn};
        String string = DevKitBundle.message("inspection.cancellation.check.in.loops.message", objectArray);
        Collection $this$toTypedArray$iv = fixes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
        holder.registerProblem(anchor, string, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
    }

    private final boolean shouldBeRunOn(UElement uElement) {
        UElement $this$getParentOfType_u24default$iv = uElement;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UMethod.class, (boolean)strict$iv);
        if (uMethod == null) {
            return false;
        }
        UMethod containingMethod = uMethod;
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)containingMethod.getJavaPsi()), (String)RequiresReadLock.class.getCanonicalName(), (int)1);
    }

    private final boolean isLoopExpressionOrLoopMethodCall(UExpression $this$isLoopExpressionOrLoopMethodCall) {
        UExpression uExpression;
        if ($this$isLoopExpressionOrLoopMethodCall instanceof ULoopExpression) {
            return true;
        }
        UExpression uExpression2 = $this$isLoopExpressionOrLoopMethodCall;
        if (uExpression2 instanceof UCallExpression) {
            uExpression = $this$isLoopExpressionOrLoopMethodCall;
        } else if (uExpression2 instanceof UQualifiedReferenceExpression) {
            uExpression = ((UQualifiedReferenceExpression)$this$isLoopExpressionOrLoopMethodCall).getSelector();
        } else {
            return false;
        }
        UExpression uExpression3 = uExpression;
        Intrinsics.checkNotNull((Object)uExpression3, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
        UCallExpression call = (UCallExpression)uExpression3;
        return this.isLoopMethodCall(call);
    }

    private final boolean isLoopMethodCall(UCallExpression $this$isLoopMethodCall) {
        return CancellationCheckInLoopsInspectionKt.access$getJavaLoopMethods$p().uCallMatches($this$isLoopMethodCall) || CancellationCheckInLoopsInspectionKt.access$getKotlinLoopMethods$p().uCallMatches($this$isLoopMethodCall);
    }

    private final List<UExpression> getBodyExpressions(UExpression $this$bodyExpressions) {
        UExpression uExpression;
        UExpression uExpression2 = $this$bodyExpressions;
        if (uExpression2 instanceof ULoopExpression) {
            uExpression = ((ULoopExpression)$this$bodyExpressions).getBody();
        } else if (uExpression2 instanceof ULambdaExpression) {
            uExpression = ((ULambdaExpression)$this$bodyExpressions).getBody();
        } else {
            return CollectionsKt.emptyList();
        }
        UExpression loopBody = uExpression;
        return loopBody instanceof UBlockExpression ? ((UBlockExpression)loopBody).getExpressions() : CollectionsKt.listOf((Object)loopBody);
    }

    private final PsiElement getAnchor(UExpression loopOrLambdaExpression) {
        Object object;
        UExpression uExpression = loopOrLambdaExpression;
        if (uExpression instanceof ULoopExpression) {
            PsiElement psiElement = loopOrLambdaExpression.getSourcePsi();
            object = psiElement != null ? psiElement.getFirstChild() : null;
        } else if (uExpression instanceof ULambdaExpression) {
            UElement $this$getParentOfType_u24default$iv = (UElement)loopOrLambdaExpression;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            UCallExpression uCallExpression = (UCallExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UCallExpression.class, (boolean)strict$iv);
            object = uCallExpression != null && (uCallExpression = uCallExpression.getMethodIdentifier()) != null ? uCallExpression.getSourcePsi() : null;
        } else {
            object = null;
        }
        return object;
    }

    public static final /* synthetic */ void access$inspectLoopExpression(CancellationCheckInLoopsInspection $this, UExpression loopOrLambdaExpression, CancellationCheckProvider checkProvider, ProblemsHolder holder) {
        $this.inspectLoopExpression(loopOrLambdaExpression, checkProvider, holder);
    }

    public static final /* synthetic */ boolean access$isLoopMethodCall(CancellationCheckInLoopsInspection $this, UCallExpression $receiver) {
        return $this.isLoopMethodCall($receiver);
    }
}

