/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;
import org.jetbrains.idea.devkit.inspections.RegistrationCheckerUtil;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterActionFix;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterComponentFix;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ComponentType;
import org.jetbrains.idea.devkit.util.PsiUtil;

final class ComponentNotRegisteredInspection
extends DevKitJvmInspection.ForClass {
    private static final Logger LOG = Logger.getInstance(ComponentNotRegisteredInspection.class);
    public boolean CHECK_ACTIONS = true;
    public boolean IGNORE_NON_PUBLIC = true;
    private static final Map<ComponentType, RegistrationCheckerUtil.RegistrationType> COMPONENT_TYPE_TO_REGISTRATION_TYPE = Map.of(ComponentType.APPLICATION, RegistrationCheckerUtil.RegistrationType.APPLICATION_COMPONENT, ComponentType.PROJECT, RegistrationCheckerUtil.RegistrationType.PROJECT_COMPONENT, ComponentType.MODULE, RegistrationCheckerUtil.RegistrationType.MODULE_COMPONENT);

    ComponentNotRegisteredInspection() {
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"IGNORE_NON_PUBLIC", (String)DevKitBundle.message("inspections.component.not.registered.option.ignore.non.public", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"CHECK_ACTIONS", (String)DevKitBundle.message("inspections.component.not.registered.option.check.actions", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    protected void checkClass(@NotNull Project project, @NotNull PsiClass checkedClass, @NotNull JvmLocalInspection.HighlightSink sink) {
        if (project == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(1);
        }
        if (checkedClass == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(2);
        }
        if (sink == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(3);
        }
        if (checkedClass.getQualifiedName() == null || checkedClass.getContainingFile().getVirtualFile() == null || checkedClass.hasModifierProperty("abstract") || checkedClass.isEnum() || checkedClass.isDeprecated() || com.intellij.psi.util.PsiUtil.isInnerClass((PsiClass)checkedClass) || !this.shouldCheckActionClass(checkedClass)) {
            return;
        }
        GlobalSearchScope scope = checkedClass.getResolveScope();
        PsiClass actionClass = JavaPsiFacade.getInstance((Project)project).findClass(AnAction.class.getName(), scope);
        if (actionClass == null) {
            return;
        }
        if (checkedClass.isInheritor(actionClass, true)) {
            if (!ComponentNotRegisteredInspection.isActionRegistered(checkedClass) && ComponentNotRegisteredInspection.canFix(checkedClass)) {
                RegisterActionFix fix = new RegisterActionFix(checkedClass);
                sink.highlight(DevKitBundle.message("inspections.component.not.registered.message", DevKitBundle.message("new.menu.action.text", new Object[0])), new LocalQuickFix[]{fix});
            }
            return;
        }
        PsiClass baseComponentClass = JavaPsiFacade.getInstance((Project)project).findClass(BaseComponent.class.getName(), scope);
        if (baseComponentClass == null) {
            return;
        }
        if (checkedClass.isInheritor(baseComponentClass, false)) {
            if (ComponentNotRegisteredInspection.findRegistrationType(checkedClass, RegistrationCheckerUtil.RegistrationType.ALL_COMPONENTS) == null && ComponentNotRegisteredInspection.canFix(checkedClass)) {
                sink.highlight(DevKitBundle.message("inspections.component.not.registered.message", "Component"), new LocalQuickFix[0]);
            }
            return;
        }
        if (!checkedClass.isInheritor(baseComponentClass, true)) {
            return;
        }
        for (ComponentType componentType : ComponentType.values()) {
            if (!InheritanceUtil.isInheritor((PsiClass)checkedClass, (String)componentType.myClassName) || !ComponentNotRegisteredInspection.checkComponentRegistration(checkedClass, sink, componentType)) continue;
            return;
        }
    }

    private static boolean checkComponentRegistration(@NotNull PsiClass checkedClass, @NotNull JvmLocalInspection.HighlightSink sink, @NotNull ComponentType componentType) {
        if (checkedClass == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(4);
        }
        if (sink == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(5);
        }
        if (componentType == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(6);
        }
        if (ComponentNotRegisteredInspection.findRegistrationType(checkedClass, COMPONENT_TYPE_TO_REGISTRATION_TYPE.get((Object)componentType)) != null) {
            return true;
        }
        if (!ComponentNotRegisteredInspection.canFix(checkedClass)) {
            return true;
        }
        RegisterComponentFix fix = new RegisterComponentFix(componentType, checkedClass);
        sink.highlight(DevKitBundle.message("inspections.component.not.registered.message", DevKitBundle.message(componentType.myPropertyKey, new Object[0])), new LocalQuickFix[]{fix});
        return false;
    }

    private static PsiClass findRegistrationType(@NotNull PsiClass checkedClass, @NotNull RegistrationCheckerUtil.RegistrationType type) {
        if (checkedClass == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(7);
        }
        if (type == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(8);
        }
        Set<PsiClass> types = RegistrationCheckerUtil.getRegistrationTypes(checkedClass, type);
        return (PsiClass)ContainerUtil.getFirstItem(types);
    }

    private boolean shouldCheckActionClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(9);
        }
        if (!this.CHECK_ACTIONS) {
            return false;
        }
        return !this.IGNORE_NON_PUBLIC || psiClass.hasModifierProperty("public");
    }

    private static boolean isActionRegistered(@NotNull PsiClass actionClass) {
        PsiClass registrationType;
        if (actionClass == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(10);
        }
        if ((registrationType = ComponentNotRegisteredInspection.findRegistrationType(actionClass, RegistrationCheckerUtil.RegistrationType.ACTION)) != null) {
            return true;
        }
        for (PsiMethod method : actionClass.getConstructors()) {
            Query search = MethodReferencesSearch.search((PsiMethod)method, (SearchScope)method.getUseScope(), (boolean)true);
            if (search.findFirst() == null) continue;
            return true;
        }
        Query search = ReferencesSearch.search((PsiElement)actionClass, (SearchScope)actionClass.getUseScope());
        for (PsiReference reference : search) {
            PsiJavaCodeReferenceElement classReference;
            PsiNewExpression newExpression;
            if (!(reference instanceof PsiJavaCodeReferenceElement) || (newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiNewExpression.class)) == null || (classReference = newExpression.getClassReference()) == null || !classReference.getQualifiedName().equals(actionClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean canFix(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(11);
        }
        Project project = psiClass.getProject();
        PsiFile psiFile = psiClass.getContainingFile();
        LOG.assertTrue(psiFile != null);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)psiFile.getVirtualFile(), (Project)project);
        return PluginModuleType.isPluginModuleOrDependency(module) || module != null && PsiUtil.isPluginModule(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/ComponentNotRegisteredInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedClass";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/ComponentNotRegisteredInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkComponentRegistration";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findRegistrationType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldCheckActionClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isActionRegistered";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

