/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;
import org.jetbrains.idea.devkit.inspections.ExtensionUtil;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateHtmlDescriptionFix;

abstract class DescriptionNotFoundInspectionBase
extends DevKitJvmInspection.ForClass {
    private final DescriptionType myDescriptionType;

    protected DescriptionNotFoundInspectionBase(DescriptionType descriptionType) {
        this.myDescriptionType = descriptionType;
    }

    @Override
    protected void checkClass(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull JvmLocalInspection.HighlightSink sink) {
        if (project == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(1);
        }
        if (sink == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(2);
        }
        if (!ExtensionUtil.isExtensionPointImplementationCandidate(psiClass)) {
            return;
        }
        if (!this.myDescriptionType.matches(psiClass)) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return;
        }
        if (this.skipIfNotRegistered(psiClass)) {
            return;
        }
        boolean registered = this.myDescriptionType.isFixedDescriptionFilename() ? this.checkFixedDescription(sink, module, psiClass) : this.checkDynamicDescription(sink, module, psiClass);
        if (registered) {
            return;
        }
        sink.highlight(this.getHasNotDescriptionError(module, psiClass), new LocalQuickFix[]{new CreateHtmlDescriptionFix(this.getDescriptionDir(module, psiClass), module, this.myDescriptionType)});
    }

    protected abstract boolean skipIfNotRegistered(PsiClass var1);

    protected boolean skipOptionalBeforeAfter(PsiClass epClass) {
        return false;
    }

    protected boolean checkDynamicDescription(JvmLocalInspection.HighlightSink sink, Module module, PsiClass psiClass) {
        throw new IllegalStateException("must be implemented for " + ((Object)((Object)this)).getClass());
    }

    protected boolean checkFixedDescription(JvmLocalInspection.HighlightSink sink, Module module, PsiClass psiClass) {
        String descriptionDir = this.getDescriptionDir(module, psiClass);
        if (StringUtil.isEmptyOrSpaces((String)descriptionDir)) {
            return false;
        }
        for (PsiDirectory description : this.getDescriptionsDirs(module)) {
            PsiFile descr;
            PsiDirectory dir = description.findSubdirectory(descriptionDir);
            if (dir == null || (descr = dir.findFile("description.html")) == null) continue;
            if (!DescriptionNotFoundInspectionBase.hasBeforeAndAfterTemplate(dir.getVirtualFile()) && !this.skipOptionalBeforeAfter(psiClass)) {
                sink.highlight(this.getHasNotBeforeAfterError(), new LocalQuickFix[0]);
            }
            return true;
        }
        return false;
    }

    private static boolean hasBeforeAndAfterTemplate(@NotNull VirtualFile dir) {
        if (dir == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(3);
        }
        boolean hasBefore = false;
        boolean hasAfter = false;
        for (VirtualFile file : dir.getChildren()) {
            String name = file.getName();
            if (!name.endsWith(".template")) continue;
            if (name.startsWith("before.")) {
                hasBefore = true;
                continue;
            }
            if (!name.startsWith("after.")) continue;
            hasAfter = true;
        }
        return hasBefore && hasAfter;
    }

    @Nullable
    protected String getDescriptionDir(Module module, PsiClass psiClass) {
        return DescriptionCheckerUtil.getDescriptionDirName(psiClass);
    }

    protected PsiDirectory @NotNull [] getDescriptionsDirs(Module module) {
        PsiDirectory[] psiDirectoryArray = DescriptionCheckerUtil.getDescriptionsDirs(module, this.myDescriptionType);
        if (psiDirectoryArray == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(4);
        }
        return psiDirectoryArray;
    }

    @InspectionMessage
    @NotNull
    protected abstract String getHasNotDescriptionError(Module var1, PsiClass var2);

    @InspectionMessage
    @NotNull
    protected abstract String getHasNotBeforeAfterError();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspectionBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionsDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasBeforeAndAfterTemplate";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

