/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.Nullable;

public enum DescriptionType {
    INTENTION(CommonIntentionAction.class.getName(), IntentionAction.class.getName(), "intentionDescriptions", true),
    INSPECTION(InspectionProfileEntry.class.getName(), null, "inspectionDescriptions", false),
    POSTFIX_TEMPLATES(PostfixTemplate.class.getName(), null, "postfixTemplates", true);

    private final String myClassName;
    @Nullable
    private final String myFallbackClassName;
    private final String myDescriptionFolder;
    private final boolean myFixedDescriptionFilename;

    private DescriptionType(String className, String fallbackClassName, String descriptionFolder, boolean fixedDescriptionFilename) {
        this.myFallbackClassName = fallbackClassName;
        this.myFixedDescriptionFilename = fixedDescriptionFilename;
        this.myClassName = className;
        this.myDescriptionFolder = descriptionFolder;
    }

    public boolean matches(PsiClass psiClass) {
        PsiClass baseClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(this.myClassName, psiClass.getResolveScope());
        if (baseClass != null) {
            return psiClass.isInheritor(baseClass, true);
        }
        return this.myFallbackClassName != null && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)this.myFallbackClassName);
    }

    public String getDescriptionFolder() {
        return this.myDescriptionFolder;
    }

    public boolean isFixedDescriptionFilename() {
        return this.myFixedDescriptionFilename;
    }
}

