/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.RemoveDomElementQuickFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.util.DevKitDomUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public abstract class DevKitPluginXmlInspectionBase
extends BasicDomElementsInspection<IdeaPlugin> {
    protected DevKitPluginXmlInspectionBase() {
        super(IdeaPlugin.class, new Class[0]);
    }

    protected boolean isAllowed(@NotNull DomElementAnnotationHolder holder) {
        if (holder == null) {
            DevKitPluginXmlInspectionBase.$$$reportNull$$$0(0);
        }
        return DevKitInspectionUtil.isAllowed((PsiFile)holder.getFileElement().getFile());
    }

    protected static boolean hasMissingAttribute(DomElement element, @NonNls String attributeName) {
        GenericAttributeValue<?> attribute = DevKitDomUtil.getAttribute(element, attributeName);
        return attribute != null && !DomUtil.hasXml(attribute);
    }

    protected static void highlightRedundant(DomElement element, @InspectionMessage String message, ProblemHighlightType highlightType, DomElementAnnotationHolder holder) {
        holder.createProblem(element, highlightType, message, null, new LocalQuickFix[]{new RemoveDomElementQuickFix(element)}).highlightWholeElement();
    }

    protected static boolean isUnderProductionSources(DomElement domElement, @NotNull Module module) {
        VirtualFile virtualFile;
        if (module == null) {
            DevKitPluginXmlInspectionBase.$$$reportNull$$$0(1);
        }
        return (virtualFile = DomUtil.getFile((DomElement)domElement).getVirtualFile()) != null && ModuleRootManager.getInstance((Module)module).getFileIndex().isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.PRODUCTION);
    }

    public final boolean isDumbAware() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/DevKitPluginXmlInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnderProductionSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

