/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;
import org.jetbrains.idea.devkit.inspections.ErrorMessageProvider;
import org.jetbrains.idea.devkit.inspections.ExtensionClassShouldBeFinalAndNonPublicInspectionKt;
import org.jetbrains.idea.devkit.inspections.ExtensionClassShouldBeFinalErrorMessageProviders;
import org.jetbrains.idea.devkit.inspections.ExtensionClassShouldNotBePublicProvider;
import org.jetbrains.idea.devkit.inspections.ExtensionClassShouldNotBePublicProviders;
import org.jetbrains.idea.devkit.inspections.ExtensionUtil;
import org.jetbrains.idea.devkit.inspections.JvmProviderKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/ExtensionClassShouldBeFinalAndNonPublicInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitJvmInspection$ForClass;", "<init>", "()V", "checkClass", "", "project", "Lcom/intellij/openapi/project/Project;", "psiClass", "Lcom/intellij/psi/PsiClass;", "sink", "Lcom/intellij/lang/jvm/inspection/JvmLocalInspection$HighlightSink;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nExtensionClassShouldBeFinalAndNonPublicInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionClassShouldBeFinalAndNonPublicInspection.kt\norg/jetbrains/idea/devkit/inspections/ExtensionClassShouldBeFinalAndNonPublicInspection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,83:1\n37#2,2:84\n*S KotlinDebug\n*F\n+ 1 ExtensionClassShouldBeFinalAndNonPublicInspection.kt\norg/jetbrains/idea/devkit/inspections/ExtensionClassShouldBeFinalAndNonPublicInspection\n*L\n47#1:84,2\n*E\n"})
public final class ExtensionClassShouldBeFinalAndNonPublicInspection
extends DevKitJvmInspection.ForClass {
    @Override
    protected void checkClass(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull JvmLocalInspection.HighlightSink sink) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!ExtensionUtil.isExtensionPointImplementationCandidate(psiClass)) {
            return;
        }
        PsiElement sourceElement = psiClass.getSourceElement();
        PsiElement psiElement = sourceElement;
        if (psiElement == null || (psiElement = psiElement.getLanguage()) == null) {
            return;
        }
        PsiElement language = psiElement;
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        boolean isFinal = psiClass.hasModifier(JvmModifier.FINAL);
        ExtensionClassShouldNotBePublicProvider extensionClassShouldNotBePublicProvider = (ExtensionClassShouldNotBePublicProvider)JvmProviderKt.getProvider(ExtensionClassShouldNotBePublicProviders.INSTANCE, (Language)language);
        if (extensionClassShouldNotBePublicProvider == null) {
            return;
        }
        ExtensionClassShouldNotBePublicProvider extensionClassShouldNotBePublicProvider2 = extensionClassShouldNotBePublicProvider;
        boolean isPublic = extensionClassShouldNotBePublicProvider2.isPublic(psiClass);
        if (isFinal && !isPublic) {
            return;
        }
        if (!ExtensionUtil.INSTANCE.isInstantiatedExtension(psiClass, (Function1<? super Extension, Boolean>)((Function1)ExtensionClassShouldBeFinalAndNonPublicInspection::checkClass$lambda$0))) {
            return;
        }
        if (!isFinal && !ExtensionClassShouldBeFinalAndNonPublicInspectionKt.access$hasInheritors(psiClass)) {
            List actions = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((JvmModifiersOwner)psiClass), (ChangeModifierRequest)MemberRequestsKt.modifierRequest$default((JvmModifier)JvmModifier.FINAL, (boolean)true, (boolean)false, (int)4, null));
            ErrorMessageProvider errorMessageProvider = (ErrorMessageProvider)JvmProviderKt.getProvider(ExtensionClassShouldBeFinalErrorMessageProviders.INSTANCE, (Language)language);
            if (errorMessageProvider == null) {
                return;
            }
            ErrorMessageProvider errorMessageProvider2 = errorMessageProvider;
            String message = errorMessageProvider2.provideErrorMessage();
            Collection $this$toTypedArray$iv = actions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LocalQuickFix[] localQuickFixArray = IntentionWrapper.wrapToQuickFixes((IntentionAction[])thisCollection$iv.toArray(new IntentionAction[0]), (PsiFile)file);
            Intrinsics.checkNotNullExpressionValue((Object)localQuickFixArray, (String)"wrapToQuickFixes(...)");
            LocalQuickFix[] fixes = localQuickFixArray;
            sink.highlight(message, Arrays.copyOf(fixes, fixes.length));
        }
        if (isPublic && !ExtensionClassShouldBeFinalAndNonPublicInspectionKt.access$isAnnotatedAsVisibleForTesting((JvmClass)psiClass)) {
            String message = ExtensionClassShouldBeFinalAndNonPublicInspectionKt.access$isServiceImplementationRegisteredInPluginXml(psiClass) ? DevKitBundle.message("inspection.extension.class.should.not.be.public.service", new Object[0]) : DevKitBundle.message("inspection.extension.class.should.not.be.public.text", new Object[0]);
            LocalQuickFix[] fixes = extensionClassShouldNotBePublicProvider2.provideQuickFix((JvmClass)psiClass, file);
            sink.highlight(message, Arrays.copyOf(fixes, fixes.length));
        }
    }

    private static final boolean checkClass$lambda$0(Extension it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }
}

