/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.lang.jvm.JvmAnnotation;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.ExtensionUtil;
import org.jetbrains.idea.devkit.util.DevKitDomUtil;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\r"}, d2={"visibleForTestingAnnotations", "", "", "getVisibleForTestingAnnotations", "()Ljava/util/List;", "isServiceImplementationRegisteredInPluginXml", "", "aClass", "Lcom/intellij/psi/PsiClass;", "hasInheritors", "isAnnotatedAsVisibleForTesting", "psiClass", "Lcom/intellij/lang/jvm/JvmClass;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nExtensionClassShouldBeFinalAndNonPublicInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionClassShouldBeFinalAndNonPublicInspection.kt\norg/jetbrains/idea/devkit/inspections/ExtensionClassShouldBeFinalAndNonPublicInspectionKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,83:1\n21#1,3:85\n20#1,5:88\n12574#2:84\n12575#2:93\n*S KotlinDebug\n*F\n+ 1 ExtensionClassShouldBeFinalAndNonPublicInspection.kt\norg/jetbrains/idea/devkit/inspections/ExtensionClassShouldBeFinalAndNonPublicInspectionKt\n*L\n81#1:85,3\n81#1:88,5\n81#1:84\n81#1:93\n*E\n"})
public final class ExtensionClassShouldBeFinalAndNonPublicInspectionKt {
    private static final List<String> getVisibleForTestingAnnotations() {
        boolean $i$f$getVisibleForTestingAnnotations = false;
        Object[] objectArray = new String[]{"com.google.common.annotations.VisibleForTesting", "com.android.annotations.VisibleForTesting", "org.jetbrains.annotations.VisibleForTesting"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final boolean isServiceImplementationRegisteredInPluginXml(PsiClass aClass) {
        DomManager domManager = DomManager.getDomManager((Project)aClass.getProject());
        for (ExtensionCandidate candidate : ExtensionLocatorKt.locateExtensionsByPsiClass(aClass)) {
            Extension extension;
            XmlTag tag;
            if ((XmlTag)candidate.pointer.getElement() == null) continue;
            DomElement domElement = domManager.getDomElement(tag);
            Extension extension2 = domElement instanceof Extension ? (Extension)domElement : null;
            if (extension2 == null || !ExtensionUtil.INSTANCE.hasServiceBeanFqn(extension = extension2)) continue;
            GenericAttributeValue<?> genericAttributeValue = DevKitDomUtil.getAttribute(extension, "serviceImplementation");
            if (genericAttributeValue == null) continue;
            GenericAttributeValue<?> attribute = genericAttributeValue;
            return Intrinsics.areEqual((Object)ExtensionUtil.INSTANCE.getNormalizedClassName(attribute.getStringValue()), (Object)aClass.getQualifiedName());
        }
        return false;
    }

    private static final boolean hasInheritors(PsiClass aClass) {
        return DirectClassInheritorsSearch.search((PsiClass)aClass).findFirst() != null;
    }

    private static final boolean isAnnotatedAsVisibleForTesting(JvmClass psiClass) {
        boolean bl;
        block1: {
            JvmAnnotation[] jvmAnnotationArray = psiClass.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)jvmAnnotationArray, (String)"getAnnotations(...)");
            Object[] $this$any$iv = jvmAnnotationArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                JvmAnnotation it = (JvmAnnotation)element$iv;
                boolean bl2 = false;
                boolean $i$f$getVisibleForTestingAnnotations = false;
                Object[] objectArray = new String[]{"com.google.common.annotations.VisibleForTesting", "com.android.annotations.VisibleForTesting", "org.jetbrains.annotations.VisibleForTesting"};
                if (!CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)it.getQualifiedName())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$hasInheritors(PsiClass aClass) {
        return ExtensionClassShouldBeFinalAndNonPublicInspectionKt.hasInheritors(aClass);
    }

    public static final /* synthetic */ boolean access$isAnnotatedAsVisibleForTesting(JvmClass psiClass) {
        return ExtensionClassShouldBeFinalAndNonPublicInspectionKt.isAnnotatedAsVisibleForTesting(psiClass);
    }

    public static final /* synthetic */ boolean access$isServiceImplementationRegisteredInPluginXml(PsiClass aClass) {
        return ExtensionClassShouldBeFinalAndNonPublicInspectionKt.isServiceImplementationRegisteredInPluginXml(aClass);
    }
}

