/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;
import org.jetbrains.idea.devkit.inspections.ExtensionUtil;
import org.jetbrains.idea.devkit.inspections.RegistrationCheckerUtil;
import org.jetbrains.idea.devkit.inspections.ServiceUtil;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/devkit/inspections/ExtensionRegisteredAsServiceOrComponentInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitJvmInspection$ForClass;", "<init>", "()V", "serviceAttributeNames", "", "", "checkClass", "", "project", "Lcom/intellij/openapi/project/Project;", "psiClass", "Lcom/intellij/psi/PsiClass;", "sink", "Lcom/intellij/lang/jvm/inspection/JvmLocalInspection$HighlightSink;", "isValueOfServiceAttribute", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "value", "isRegisteredComponentImplementation", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nExtensionRegisteredAsServiceOrComponentInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionRegisteredAsServiceOrComponentInspection.kt\norg/jetbrains/idea/devkit/inspections/ExtensionRegisteredAsServiceOrComponentInspection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n3829#2:77\n4344#2,2:78\n1557#3:80\n1628#3,3:81\n*S KotlinDebug\n*F\n+ 1 ExtensionRegisteredAsServiceOrComponentInspection.kt\norg/jetbrains/idea/devkit/inspections/ExtensionRegisteredAsServiceOrComponentInspection\n*L\n61#1:77\n61#1:78,2\n61#1:80\n61#1:81,3\n*E\n"})
public final class ExtensionRegisteredAsServiceOrComponentInspection
extends DevKitJvmInspection.ForClass {
    @NotNull
    private final Set<String> serviceAttributeNames = SetsKt.setOf((Object)"service");

    @Override
    protected void checkClass(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull JvmLocalInspection.HighlightSink sink) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!ExtensionUtil.isExtensionPointImplementationCandidate(psiClass)) {
            return;
        }
        boolean isExtension = false;
        boolean isService = false;
        List<ExtensionCandidate> extensionsCandidates = ExtensionLocatorKt.locateExtensionsByPsiClass(psiClass);
        DomManager domManager = DomManager.getDomManager((Project)project);
        for (ExtensionCandidate candidate : extensionsCandidates) {
            DomElement element;
            XmlTag tag;
            if (isExtension && isService) break;
            if ((XmlTag)candidate.pointer.getElement() == null || domManager.getDomElement(tag) == null || !(element instanceof Extension)) continue;
            if (ExtensionUtil.INSTANCE.hasServiceBeanFqn((Extension)element)) {
                isService = true;
                continue;
            }
            if (this.isValueOfServiceAttribute(tag, psiClass.getQualifiedName())) continue;
            isExtension = true;
        }
        if (!isExtension) {
            return;
        }
        if (isService || ServiceUtil.isLightService(psiClass)) {
            sink.highlight(DevKitBundle.message("inspection.extension.registered.as.service.message", new Object[0]), new LocalQuickFix[0]);
            return;
        }
        if (this.isRegisteredComponentImplementation(psiClass)) {
            sink.highlight(DevKitBundle.message("inspection.extension.registered.as.component.message", new Object[0]), new LocalQuickFix[0]);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValueOfServiceAttribute(XmlTag tag, String value) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        XmlAttribute[] xmlAttributeArray = tag.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray, (String)"getAttributes(...)");
        Object $this$filter$iv = xmlAttributeArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (XmlAttribute element$iv$iv : $this$filterTo$iv$iv) {
            XmlAttribute it = element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getValue(), (Object)value)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            XmlAttribute element$iv$iv;
            element$iv$iv = (XmlAttribute)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Set attributeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return this.serviceAttributeNames.containsAll(attributeNames);
    }

    private final boolean isRegisteredComponentImplementation(PsiClass psiClass) {
        String baseComponentFqn = BaseComponent.class.getCanonicalName();
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)false, (String)baseComponentFqn)) {
            return false;
        }
        Set<PsiClass> types = RegistrationCheckerUtil.getRegistrationTypes(psiClass, RegistrationCheckerUtil.RegistrationType.ALL_COMPONENTS);
        Collection collection = types;
        return !(collection == null || collection.isEmpty());
    }
}

