/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.util.DevKitDomUtil;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\"\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bJ\u0014\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e*\u00020\fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\fJ\u0012\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f*\u00020\fH\u0002J\u0016\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e*\u00020\fH\u0002J(\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u001a\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001e*\u00020\fH\u0002R \u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u000e0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010!\u001a \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u000e0\u001e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/idea/devkit/inspections/ExtensionUtil;", "", "<init>", "()V", "isExtensionPointImplementationCandidate", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "isInstantiatedExtension", "extensionClass", "shouldSkip", "Lkotlin/Function1;", "Lorg/jetbrains/idea/devkit/dom/Extension;", "getClassNameDomValues", "", "Lcom/intellij/util/xml/GenericDomValue;", "getNormalizedClassName", "", "className", "hasServiceBeanFqn", "extension", "getExplicitInstantiatedClassElement", "implicitClassNameDomValues", "mapAttributeNamesToExistingDomValues", "attributeNames", "getExistingDomValue", "parent", "Lcom/intellij/util/xml/DomElement;", "attributeName", "getInstantiatedClassElementInfo", "Lkotlin/Pair;", "beanClassNameToInstantiatedClassAttributeNames", "", "implicitInstantiatedClassAttributes", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nExtensionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionUtil.kt\norg/jetbrains/idea/devkit/inspections/ExtensionUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1755#2,3:174\n1611#2,9:178\n1863#2:187\n1864#2:189\n1620#2:190\n1#3:177\n1#3:188\n*S KotlinDebug\n*F\n+ 1 ExtensionUtil.kt\norg/jetbrains/idea/devkit/inspections/ExtensionUtil\n*L\n36#1:174,3\n91#1:178,9\n91#1:187\n91#1:189\n91#1:190\n91#1:188\n*E\n"})
public final class ExtensionUtil {
    @NotNull
    public static final ExtensionUtil INSTANCE = new ExtensionUtil();
    @NotNull
    private static final Map<String, List<String>> beanClassNameToInstantiatedClassAttributeNames;
    @NotNull
    private static final List<Pair<List<String>, List<String>>> implicitInstantiatedClassAttributes;

    private ExtensionUtil() {
    }

    @JvmStatic
    public static final boolean isExtensionPointImplementationCandidate(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return psiClass.getClassKind() == JvmClassKind.CLASS && !PsiUtil.isAbstractClass((PsiClass)psiClass) && !PsiUtil.isInnerClass((PsiClass)psiClass) && !PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass);
    }

    public final boolean isInstantiatedExtension(@NotNull PsiClass extensionClass, @NotNull Function1<? super Extension, Boolean> shouldSkip) {
        Intrinsics.checkNotNullParameter((Object)extensionClass, (String)"extensionClass");
        Intrinsics.checkNotNullParameter(shouldSkip, (String)"shouldSkip");
        for (ExtensionCandidate candidate : ExtensionLocatorKt.locateExtensionsByPsiClass(extensionClass)) {
            boolean bl;
            block4: {
                Extension extension;
                if ((Extension)DomUtil.findDomElement((PsiElement)candidate.pointer.getElement(), Extension.class, (boolean)false) == null || ((Boolean)shouldSkip.invoke((Object)extension)).booleanValue()) continue;
                List<GenericDomValue<?>> classNameDomValues = this.getClassNameDomValues(extension);
                Iterable $this$any$iv = classNameDomValues;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GenericDomValue it = (GenericDomValue)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)INSTANCE.getNormalizedClassName(it.getStringValue()), (Object)extensionClass.getQualifiedName())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final List<GenericDomValue<?>> getClassNameDomValues(@NotNull Extension $this$getClassNameDomValues) {
        Intrinsics.checkNotNullParameter((Object)$this$getClassNameDomValues, (String)"<this>");
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(this.getExplicitInstantiatedClassElement($this$getClassNameDomValues)), (Iterable)this.implicitClassNameDomValues($this$getClassNameDomValues));
    }

    @Nullable
    public final String getNormalizedClassName(@Nullable String className) {
        String string = className;
        return string != null ? StringsKt.replace$default((String)string, (char)'$', (char)'.', (boolean)false, (int)4, null) : null;
    }

    public final boolean hasServiceBeanFqn(@NotNull Extension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        GenericAttributeValue<PsiClass> genericAttributeValue = extension.getExtensionPoint();
        return Intrinsics.areEqual((Object)(genericAttributeValue != null && (genericAttributeValue = genericAttributeValue.getBeanClass()) != null ? genericAttributeValue.getStringValue() : null), (Object)ServiceDescriptor.class.getCanonicalName());
    }

    private final GenericDomValue<?> getExplicitInstantiatedClassElement(Extension $this$getExplicitInstantiatedClassElement) {
        Object object;
        GenericDomValue domValue;
        Pair<String, Boolean> pair = this.getInstantiatedClassElementInfo($this$getExplicitInstantiatedClassElement);
        if (pair == null) {
            return null;
        }
        Pair<String, Boolean> pair2 = pair;
        String elementName = (String)pair2.component1();
        boolean isClassDefinedInTag = (Boolean)pair2.component2();
        GenericDomValue genericDomValue = domValue = isClassDefinedInTag ? DevKitDomUtil.getTag($this$getExplicitInstantiatedClassElement, elementName) : (GenericDomValue)DevKitDomUtil.getAttribute($this$getExplicitInstantiatedClassElement, elementName);
        if (genericDomValue != null) {
            GenericDomValue genericDomValue2;
            GenericDomValue it = genericDomValue2 = genericDomValue;
            boolean bl = false;
            object = DomUtil.hasXml((DomElement)((DomElement)it)) ? genericDomValue2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final List<GenericDomValue<?>> implicitClassNameDomValues(Extension $this$implicitClassNameDomValues) {
        ExtensionPoint extensionPoint = $this$implicitClassNameDomValues.getExtensionPoint();
        if (extensionPoint == null) {
            return CollectionsKt.emptyList();
        }
        ExtensionPoint extensionPoint2 = extensionPoint;
        List classNameDomValues = new ArrayList();
        for (Map.Entry<String, List<String>> object : beanClassNameToInstantiatedClassAttributeNames.entrySet()) {
            String string = object.getKey();
            List<String> attributeNames = object.getValue();
            if (!InheritanceUtil.isInheritor((PsiClass)((PsiClass)extensionPoint2.getBeanClass().getValue()), (String)string)) continue;
            classNameDomValues.addAll((Collection)this.mapAttributeNamesToExistingDomValues(attributeNames, $this$implicitClassNameDomValues));
        }
        String string = extensionPoint2.getEffectiveQualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEffectiveQualifiedName(...)");
        String epName = string;
        for (Pair<List<String>, List<String>> pair : implicitInstantiatedClassAttributes) {
            List epNames = (List)pair.component1();
            List classAttributeNames = (List)pair.component2();
            if (!epNames.contains(epName)) continue;
            classNameDomValues.addAll((Collection)this.mapAttributeNamesToExistingDomValues(classAttributeNames, $this$implicitClassNameDomValues));
            break;
        }
        return classNameDomValues;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GenericDomValue<?>> mapAttributeNamesToExistingDomValues(List<String> attributeNames, Extension extension) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = attributeNames;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GenericDomValue<?> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.getExistingDomValue(extension, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final GenericDomValue<?> getExistingDomValue(DomElement parent, String attributeName) {
        Object object;
        GenericAttributeValue<?> genericAttributeValue = DevKitDomUtil.getAttribute(parent, attributeName);
        if (genericAttributeValue != null) {
            GenericAttributeValue<?> genericAttributeValue2;
            GenericAttributeValue<?> it = genericAttributeValue2 = genericAttributeValue;
            boolean bl = false;
            object = DomUtil.hasXml((DomElement)((DomElement)it)) ? genericAttributeValue2 : null;
        } else {
            object = null;
        }
        return (GenericDomValue)object;
    }

    private final Pair<String, Boolean> getInstantiatedClassElementInfo(Extension $this$getInstantiatedClassElementInfo) {
        ExtensionPoint extensionPoint = $this$getInstantiatedClassElementInfo.getExtensionPoint();
        if (extensionPoint == null || (extensionPoint = extensionPoint.getExtensionPointClassNameElement()) == null) {
            return null;
        }
        ExtensionPoint classNameElement = extensionPoint;
        if (classNameElement instanceof With) {
            boolean isTagDefined = DomUtil.hasXml((DomElement)((DomElement)((With)((Object)classNameElement)).getTag()));
            boolean isAttributeDefined = DomUtil.hasXml((DomElement)((DomElement)((With)((Object)classNameElement)).getAttribute()));
            if (!isTagDefined && !isAttributeDefined) {
                return null;
            }
            String string = isTagDefined ? ((With)((Object)classNameElement)).getTag().getStringValue() : ((With)((Object)classNameElement)).getAttribute().getStringValue();
            if (string == null) {
                string = "";
            }
            String elementName = string;
            return new Pair((Object)elementName, (Object)isTagDefined);
        }
        return new Pair((Object)"implementation", (Object)false);
    }

    static {
        Object[] objectArray = new Pair[2];
        Object[] objectArray2 = new String[]{"implementation", "provider"};
        objectArray[0] = TuplesKt.to((Object)"com.intellij.openapi.options.ConfigurableEP", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray[1] = TuplesKt.to((Object)"com.intellij.openapi.wm.ToolWindowEP", (Object)CollectionsKt.listOf((Object)"conditionClass"));
        beanClassNameToInstantiatedClassAttributeNames = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new Pair[11];
        objectArray2 = new String[]{"com.intellij.applicationService", "com.intellij.projectService", "com.intellij.moduleService"};
        List list = CollectionsKt.listOf((Object[])objectArray2);
        objectArray2 = new String[]{"serviceImplementation", "testServiceImplementation", "headlessImplementation"};
        objectArray[0] = new Pair((Object)list, (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray[1] = new Pair((Object)CollectionsKt.listOf((Object)"com.intellij.cacheBuilder"), (Object)CollectionsKt.listOf((Object)"wordsScannerClass"));
        objectArray[2] = new Pair((Object)CollectionsKt.listOf((Object)"com.intellij.moduleBuilder"), (Object)CollectionsKt.listOf((Object)"builderClass"));
        objectArray[3] = new Pair((Object)CollectionsKt.listOf((Object)"com.intellij.psi.referenceProvider"), (Object)CollectionsKt.listOf((Object)"providerClass"));
        objectArray[4] = new Pair((Object)CollectionsKt.listOf((Object)"com.intellij.codeInsight.linkHandler"), (Object)CollectionsKt.listOf((Object)"handlerClass"));
        objectArray[5] = new Pair((Object)CollectionsKt.listOf((Object)"com.intellij.vcs"), (Object)CollectionsKt.listOf((Object)"vcsClass"));
        objectArray[6] = new Pair((Object)CollectionsKt.listOf((Object)"com.intellij.library.toolWindow"), (Object)CollectionsKt.listOf((Object)"librarySearchClass"));
        objectArray2 = new String[]{"className", "predicateClassName", "preloaderClassName", "displayNameSupplierClassName"};
        objectArray[7] = new Pair((Object)CollectionsKt.listOf((Object)"com.intellij.changesViewContent"), (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray[8] = new Pair((Object)CollectionsKt.listOf((Object)"com.intellij.rd.extListener"), (Object)CollectionsKt.listOf((Object)"listener"));
        objectArray[9] = new Pair((Object)CollectionsKt.listOf((Object)"com.intellij.rd.solutionExtListener"), (Object)CollectionsKt.listOf((Object)"listener"));
        objectArray[10] = new Pair((Object)CollectionsKt.listOf((Object)"com.intellij.rd.rootExtListener"), (Object)CollectionsKt.listOf((Object)"listener"));
        implicitInstantiatedClassAttributes = CollectionsKt.listOf((Object[])objectArray);
    }
}

