/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.CancellationExceptionHandlingChecker;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.IncorrectCancellationExceptionHandlingInspection;
import org.jetbrains.idea.devkit.inspections.IncorrectCancellationExceptionHandlingInspectionKt;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/devkit/inspections/IncorrectCancellationExceptionHandlingInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "<init>", "()V", "buildInternalVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "CaughtCeInfo", "intellij.devkit.core"})
public final class IncorrectCancellationExceptionHandlingInspection
extends DevKitUastInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UCatchClause.class};
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public boolean visitCatchClause(UCatchClause node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                List catchParameters = node.getParameters();
                CaughtCeInfo caughtCeInfo = this.findSuspiciousCeCaughtParam(catchParameters);
                if (caughtCeInfo != null) {
                    this.inspectIncorrectCeHandling(node, caughtCeInfo);
                } else {
                    this.inspectGenericThrowableIfAnyOfTryStatementsThrowsCe(node, catchParameters);
                }
                return super.visitCatchClause(node);
            }

            /*
             * WARNING - void declaration
             */
            private final CaughtCeInfo findSuspiciousCeCaughtParam(List<? extends UParameter> catchParameters) {
                GlobalSearchScope globalSearchScope = this.$holder.getFile().getResolveScope();
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getResolveScope(...)");
                List<PsiClass> list = this.findCeClasses(globalSearchScope);
                if (list == null) {
                    return null;
                }
                List<PsiClass> ceClasses = list;
                for (UParameter uParameter : catchParameters) {
                    void $this$filterIsInstanceTo$iv$iv;
                    List list2;
                    PsiType type;
                    CancellationExceptionHandlingChecker checker = IncorrectCancellationExceptionHandlingInspectionKt.access$cancellationExceptionHandlingChecker(uParameter.getLang());
                    PsiElement sourcePsi = uParameter.getSourcePsi();
                    if (sourcePsi != null) {
                        CancellationExceptionHandlingChecker cancellationExceptionHandlingChecker = checker;
                        boolean bl = cancellationExceptionHandlingChecker != null ? cancellationExceptionHandlingChecker.isSuspicious(sourcePsi) : false;
                        if (bl) {
                            return new CaughtCeInfo(checker.getCeName(), false, uParameter, null, 8, null);
                        }
                    }
                    if ((type = uParameter.getType()) instanceof PsiDisjunctionType) {
                        List list3 = ((PsiDisjunctionType)type).getDisjunctions();
                        list2 = list3;
                        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getDisjunctions(...)");
                    } else {
                        list2 = CollectionsKt.listOf((Object)type);
                    }
                    Iterable $this$filterIsInstance$iv = list2;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof PsiClassType)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List caughtExceptionTypes = (List)destination$iv$iv;
                    for (PsiClassType caughtExceptionType : caughtExceptionTypes) {
                        PsiClass baseCeClass;
                        Object v6;
                        block9: {
                            Iterable $this$firstOrNull$iv = ceClasses;
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                PsiClass it = (PsiClass)element$iv;
                                boolean bl = false;
                                if (!this.isInheritorOrSelf((PsiType)caughtExceptionType, it)) continue;
                                v6 = element$iv;
                                break block9;
                            }
                            v6 = null;
                        }
                        if ((baseCeClass = (PsiClass)v6) == null) continue;
                        String string = baseCeClass.getQualifiedName();
                        Intrinsics.checkNotNull((Object)string);
                        return new CaughtCeInfo(string, !this.isCancellationExceptionClass((PsiType)caughtExceptionType), uParameter, null, 8, null);
                    }
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            private final List<PsiClass> findCeClasses(GlobalSearchScope resolveScope) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable<T> iterable = IncorrectCancellationExceptionHandlingInspectionKt.access$getCeClassNames$p();
                ProblemsHolder problemsHolder = this.$holder;
                boolean $i$f$mapNotNull = false;
                void var5_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    PsiClass it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (JavaPsiFacade.getInstance((Project)problemsHolder.getProject()).findClass(it, resolveScope) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable<T> it = iterable = (List)destination$iv$iv;
                boolean bl = false;
                return !((Collection)it).isEmpty() ? iterable : null;
            }

            private final boolean isCancellationExceptionClass(PsiType $this$isCancellationExceptionClass) {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = IncorrectCancellationExceptionHandlingInspectionKt.access$getCeClassNames$p();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            PsiClassType psiClassType = $this$isCancellationExceptionClass instanceof PsiClassType ? (PsiClassType)$this$isCancellationExceptionClass : null;
                            if (!Intrinsics.areEqual((Object)it, psiClassType != null && (psiClassType = psiClassType.resolve()) != null ? psiClassType.getQualifiedName() : null)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private final boolean isInheritorOrSelf(PsiType $this$isInheritorOrSelf, PsiClass ceClass) {
                PsiClassType psiClassType = $this$isInheritorOrSelf instanceof PsiClassType ? (PsiClassType)$this$isInheritorOrSelf : null;
                if (psiClassType == null) {
                    return false;
                }
                PsiClassType psiClassType2 = psiClassType;
                PsiClass psiClass = psiClassType2.resolve();
                if (psiClass == null) {
                    return false;
                }
                PsiClass psiClass2 = psiClass;
                return InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass2, (PsiClass)ceClass, (boolean)true);
            }

            private final void inspectIncorrectCeHandling(UCatchClause node, CaughtCeInfo caughtCeInfo) {
                UExpression loggingExpression;
                UExpression catchBody = node.getBody();
                if (!this.ceIsRethrown(catchBody, caughtCeInfo.getParameter())) {
                    String string;
                    if (caughtCeInfo.isInheritor()) {
                        var5_4 = new Object[]{caughtCeInfo.getBaseCeClassName()};
                        string = DevKitBundle.message("inspections.incorrect.cancellation.exception.inheritor.handling.name.not.rethrown", var5_4);
                    } else {
                        var5_4 = new Object[]{caughtCeInfo.getBaseCeClassName()};
                        string = DevKitBundle.message("inspections.incorrect.cancellation.exception.handling.name.not.rethrown", var5_4);
                    }
                    String message = string;
                    UDeclaration uDeclaration = (UDeclaration)caughtCeInfo.getParameter();
                    Intrinsics.checkNotNull((Object)message);
                    ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.$holder, (UDeclaration)uDeclaration, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
                }
                if ((loggingExpression = this.findCeLoggingExpression(catchBody, caughtCeInfo.getParameter())) != null) {
                    String string;
                    if (caughtCeInfo.isInheritor()) {
                        var6_6 = new Object[]{caughtCeInfo.getBaseCeClassName()};
                        string = DevKitBundle.message("inspections.incorrect.cancellation.exception.inheritor.handling.name.logged", var6_6);
                    } else {
                        var6_6 = new Object[]{caughtCeInfo.getBaseCeClassName()};
                        string = DevKitBundle.message("inspections.incorrect.cancellation.exception.handling.name.logged", var6_6);
                    }
                    String message = string;
                    Intrinsics.checkNotNull((Object)message);
                    ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.$holder, (UExpression)loggingExpression, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
                }
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            private final boolean inspectGenericThrowableIfAnyOfTryStatementsThrowsCe(UCatchClause catchClause, List<? extends UParameter> catchParameters) {
                block41: {
                    block37: {
                        $this$getParentOfType_u24default$iv = (UElement)catchClause;
                        strict$iv = true;
                        $i$f$getParentOfType = false;
                        v0 = (UTryExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UTryExpression.class, (boolean)strict$iv);
                        if (v0 == null) {
                            return super.visitCatchClause(catchClause);
                        }
                        tryExpression = v0;
                        var4_9 = this;
                        $this$containsCatchClauseForType$iv = tryExpression;
                        $i$f$containsCatchClauseForType = false;
                        $this$any$iv$iv = $this$containsCatchClauseForType$iv.getCatchClauses();
                        $i$f$any = false;
                        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                            v1 = false;
                        } else {
                            for (T element$iv$iv : $this$any$iv$iv) {
                                block36: {
                                    clause$iv /* !! */  = (UCatchClause)element$iv$iv;
                                    $i$a$-any-IncorrectCancellationExceptionHandlingInspection$buildInternalVisitor$1$containsCatchClauseForType$1$iv = false;
                                    $this$any$iv$iv = clause$iv /* !! */ .getParameters();
                                    $i$f$any = false;
                                    if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                                        v2 = false;
                                    } else {
                                        for (T element$iv$iv : $this$any$iv$iv) {
                                            block35: {
                                                it$iv = (UParameter)element$iv$iv;
                                                $i$a$-any-IncorrectCancellationExceptionHandlingInspection$buildInternalVisitor$1$containsCatchClauseForType$1$1$iv = false;
                                                var19_34 = this_$iv;
                                                $this$isClassType$iv$iv = it$iv.getType();
                                                $i$f$isClassType = false;
                                                if ($this$isClassType$iv$iv instanceof PsiDisjunctionType) {
                                                    v3 = ((PsiDisjunctionType)$this$isClassType$iv$iv).getDisjunctions();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getDisjunctions(...)");
                                                    $this$any$iv$iv$iv = v3;
                                                    $i$f$any = false;
                                                    if ($this$any$iv$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv$iv).isEmpty()) {
                                                        v4 = false;
                                                    } else {
                                                        for (T element$iv$iv$iv : $this$any$iv$iv$iv) {
                                                            it$iv$iv = (PsiType)element$iv$iv$iv;
                                                            $i$a$-any-IncorrectCancellationExceptionHandlingInspection$buildInternalVisitor$1$isClassType$1$iv$iv = false;
                                                            if (!PsiTypesUtil.classNameEquals((PsiType)it$iv$iv, (String)ProcessCanceledException.class.getName())) continue;
                                                            v4 = true;
                                                            break block35;
                                                        }
                                                        v4 = false;
                                                    }
                                                } else {
                                                    v4 = PsiTypesUtil.classNameEquals((PsiType)$this$isClassType$iv$iv, (String)ProcessCanceledException.class.getName());
                                                }
                                            }
                                            if (!v4) continue;
                                            v2 = true;
                                            break block36;
                                        }
                                        v2 = false;
                                    }
                                }
                                if (!v2) continue;
                                v1 = true;
                                break block37;
                            }
                            v1 = false;
                        }
                    }
                    if (v1 || this.checkContainsSuspiciousCeCatchClause(tryExpression)) {
                        return super.visitCatchClause(catchClause);
                    }
                    $this$firstOrNull$iv = catchParameters;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        block40: {
                            block39: {
                                block38: {
                                    it = (UParameter)element$iv;
                                    $i$a$-firstOrNull-IncorrectCancellationExceptionHandlingInspection$buildInternalVisitor$1$inspectGenericThrowableIfAnyOfTryStatementsThrowsCe$caughtGenericThrowableParam$1 = false;
                                    clause$iv /* !! */  = this;
                                    $this$isClassType$iv = it.getType();
                                    $i$f$isClassType = false;
                                    if ($this$isClassType$iv instanceof PsiDisjunctionType) {
                                        v5 = ((PsiDisjunctionType)$this$isClassType$iv).getDisjunctions();
                                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getDisjunctions(...)");
                                        $this$any$iv$iv = v5;
                                        $i$f$any = false;
                                        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                                            v6 = false;
                                        } else {
                                            for (T element$iv$iv : $this$any$iv$iv) {
                                                it$iv = (PsiType)element$iv$iv;
                                                $i$a$-any-IncorrectCancellationExceptionHandlingInspection$buildInternalVisitor$1$isClassType$1$iv = false;
                                                if (!PsiTypesUtil.classNameEquals((PsiType)it$iv, (String)RuntimeException.class.getName())) continue;
                                                v6 = true;
                                                break block38;
                                            }
                                            v6 = false;
                                        }
                                    } else {
                                        v6 = PsiTypesUtil.classNameEquals((PsiType)$this$isClassType$iv, (String)RuntimeException.class.getName());
                                    }
                                }
                                if (v6) ** GOTO lbl-1000
                                this_$iv = this;
                                $this$isClassType$iv = it.getType();
                                $i$f$isClassType = false;
                                if ($this$isClassType$iv instanceof PsiDisjunctionType) {
                                    v7 = ((PsiDisjunctionType)$this$isClassType$iv).getDisjunctions();
                                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getDisjunctions(...)");
                                    $this$any$iv$iv = v7;
                                    $i$f$any = false;
                                    if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                                        v8 = false;
                                    } else {
                                        for (T element$iv$iv : $this$any$iv$iv) {
                                            it$iv = (PsiType)element$iv$iv;
                                            $i$a$-any-IncorrectCancellationExceptionHandlingInspection$buildInternalVisitor$1$isClassType$1$iv = false;
                                            if (!PsiTypesUtil.classNameEquals((PsiType)it$iv, (String)Exception.class.getName())) continue;
                                            v8 = true;
                                            break block39;
                                        }
                                        v8 = false;
                                    }
                                } else {
                                    v8 = PsiTypesUtil.classNameEquals((PsiType)$this$isClassType$iv, (String)Exception.class.getName());
                                }
                            }
                            if (v8) ** GOTO lbl-1000
                            this_$iv = this;
                            $this$isClassType$iv = it.getType();
                            $i$f$isClassType = false;
                            if ($this$isClassType$iv instanceof PsiDisjunctionType) {
                                v9 = ((PsiDisjunctionType)$this$isClassType$iv).getDisjunctions();
                                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getDisjunctions(...)");
                                $this$any$iv$iv = v9;
                                $i$f$any = false;
                                if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                                    v10 = false;
                                } else {
                                    for (T element$iv$iv : $this$any$iv$iv) {
                                        it$iv = (PsiType)element$iv$iv;
                                        $i$a$-any-IncorrectCancellationExceptionHandlingInspection$buildInternalVisitor$1$isClassType$1$iv = false;
                                        if (!PsiTypesUtil.classNameEquals((PsiType)it$iv, (String)Throwable.class.getName())) continue;
                                        v10 = true;
                                        break block40;
                                    }
                                    v10 = false;
                                }
                            } else {
                                v10 = PsiTypesUtil.classNameEquals((PsiType)$this$isClassType$iv, (String)Throwable.class.getName());
                            }
                        }
                        if (v10) lbl-1000:
                        // 3 sources

                        {
                            v11 = true;
                        } else {
                            v11 = false;
                        }
                        if (!v11) continue;
                        v12 = element$iv;
                        break block41;
                    }
                    v12 = null;
                }
                caughtGenericThrowableParam = v12;
                if (caughtGenericThrowableParam != null) {
                    if (this.containsMoreSpecificCatchClause(tryExpression, caughtGenericThrowableParam)) {
                        return super.visitCatchClause(catchClause);
                    }
                    langSpecificCaughtCeInfo = this.findLangSpecificCeThrowingExpressionInfo(tryExpression, caughtGenericThrowableParam);
                    if (langSpecificCaughtCeInfo != null) {
                        this.inspectIncorrectImplicitCeHandling(catchClause, langSpecificCaughtCeInfo);
                    }
                    if ((caughtCeInfo = this.findCeThrowingExpressionInfo(tryExpression, caughtGenericThrowableParam)) != null) {
                        this.inspectIncorrectImplicitCeHandling(catchClause, caughtCeInfo);
                    }
                }
                return super.visitCatchClause(catchClause);
            }

            private final boolean checkContainsSuspiciousCeCatchClause(UTryExpression $this$checkContainsSuspiciousCeCatchClause) {
                PsiElement psiElement = $this$checkContainsSuspiciousCeCatchClause.getSourcePsi();
                if (psiElement == null) {
                    return false;
                }
                PsiElement sourcePsi = psiElement;
                CancellationExceptionHandlingChecker cancellationExceptionHandlingChecker = IncorrectCancellationExceptionHandlingInspectionKt.access$cancellationExceptionHandlingChecker($this$checkContainsSuspiciousCeCatchClause.getLang());
                return cancellationExceptionHandlingChecker != null ? cancellationExceptionHandlingChecker.containsSuspiciousCeCatchClause(sourcePsi) : false;
            }

            private final CaughtCeInfo findLangSpecificCeThrowingExpressionInfo(UTryExpression tryExpression, UParameter caughtGenericThrowableParam) {
                Object object;
                CancellationExceptionHandlingChecker ceHandlingChecker;
                block3: {
                    block2: {
                        ceHandlingChecker = IncorrectCancellationExceptionHandlingInspectionKt.access$cancellationExceptionHandlingChecker(tryExpression.getLang());
                        object = ceHandlingChecker;
                        if (object == null) break block2;
                        PsiElement psiElement = tryExpression.getSourcePsi();
                        Intrinsics.checkNotNull((Object)psiElement);
                        if ((object = object.findCeThrowingExpressionName(psiElement)) != null) break block3;
                    }
                    return null;
                }
                Object ceThrowingExpressionName = object;
                return new CaughtCeInfo(ceHandlingChecker.getCeName(), false, caughtGenericThrowableParam, (String)ceThrowingExpressionName);
            }

            private final CaughtCeInfo findCeThrowingExpressionInfo(UTryExpression tryExpression, UParameter caughtGenericThrowableParam) {
                Ref.ObjectRef caughtCeInfo = new Ref.ObjectRef();
                UExpression tryClause = tryExpression.getTryClause();
                PsiElement psiElement = tryClause.getSourcePsi();
                if (psiElement == null || (psiElement = psiElement.getResolveScope()) == null) {
                    return null;
                }
                PsiElement resolveScope = psiElement;
                List<PsiClass> list = this.findCeClasses((GlobalSearchScope)resolveScope);
                if (list == null) {
                    return null;
                }
                List<PsiClass> ceClasses = list;
                tryClause.accept((UastVisitor)new AbstractUastVisitor((Ref.ObjectRef<CaughtCeInfo>)caughtCeInfo, ceClasses, this, tryExpression, caughtGenericThrowableParam){
                    final /* synthetic */ Ref.ObjectRef<CaughtCeInfo> $caughtCeInfo;
                    final /* synthetic */ List<PsiClass> $ceClasses;
                    final /* synthetic */ buildInternalVisitor.1 this$0;
                    final /* synthetic */ UTryExpression $tryExpression;
                    final /* synthetic */ UParameter $caughtGenericThrowableParam;
                    {
                        this.$caughtCeInfo = $caughtCeInfo;
                        this.$ceClasses = $ceClasses;
                        this.this$0 = $receiver;
                        this.$tryExpression = $tryExpression;
                        this.$caughtGenericThrowableParam = $caughtGenericThrowableParam;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public boolean visitCallExpression(UCallExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (this.$caughtCeInfo.element == null) {
                            UResolvable $this$resolveToUElementOfType$iv = (UResolvable)node;
                            boolean $i$f$resolveToUElementOfType = false;
                            UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
                            if (!(uElement instanceof UMethod)) {
                                uElement = null;
                            }
                            UMethod uMethod = (UMethod)((UElement)((UMethod)uElement));
                            if (uMethod == null) {
                                return super.visitCallExpression(node);
                            }
                            UMethod calledMethod = uMethod;
                            for (JvmReferenceType throwsType : calledMethod.getJavaPsi().getThrowsTypes()) {
                                Object v2;
                                PsiClassType throwsClassType;
                                block5: {
                                    void $this$firstOrNull$iv;
                                    if ((throwsType instanceof PsiClassType ? (PsiClassType)throwsType : null) == null) continue;
                                    throwsClassType = throwsClassType;
                                    Iterable iterable = this.$ceClasses;
                                    buildInternalVisitor.1 var10_11 = this.this$0;
                                    boolean $i$f$firstOrNull = false;
                                    for (T element$iv : $this$firstOrNull$iv) {
                                        PsiClass it = (PsiClass)element$iv;
                                        boolean bl = false;
                                        if (!buildInternalVisitor.1.access$isInheritorOrSelf(var10_11, (PsiType)throwsClassType, it)) continue;
                                        v2 = element$iv;
                                        break block5;
                                    }
                                    v2 = null;
                                }
                                PsiClass baseThrowsCeClass = v2;
                                if (baseThrowsCeClass == null || buildInternalVisitor.1.access$isInNestedTryCatchBlock(this.this$0, node, this.$tryExpression, throwsClassType)) continue;
                                String string = baseThrowsCeClass.getQualifiedName();
                                Intrinsics.checkNotNull((Object)string);
                                this.$caughtCeInfo.element = new CaughtCeInfo(string, !buildInternalVisitor.1.access$isCancellationExceptionClass(this.this$0, (PsiType)throwsClassType), this.$caughtGenericThrowableParam, node.getMethodName());
                                return super.visitCallExpression(node);
                            }
                        }
                        return super.visitCallExpression(node);
                    }
                });
                return (CaughtCeInfo)caughtCeInfo.element;
            }

            /*
             * WARNING - void declaration
             */
            private final boolean isInNestedTryCatchBlock(UCallExpression expression, UTryExpression checkedTryExpression, PsiClassType thrownExceptionType) {
                boolean bl;
                block16: {
                    PsiClass psiClass = thrownExceptionType.resolve();
                    if (psiClass == null) {
                        return false;
                    }
                    PsiClass thrownExceptionClass = psiClass;
                    UElement $this$getParentOfType_u24default$iv = (UElement)expression;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType = false;
                    UTryExpression uTryExpression = (UTryExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UTryExpression.class, (boolean)strict$iv);
                    if (uTryExpression == null) {
                        return false;
                    }
                    UTryExpression parentTryExpression = uTryExpression;
                    if (Intrinsics.areEqual((Object)parentTryExpression, (Object)checkedTryExpression)) {
                        return false;
                    }
                    Iterable $this$any$iv = parentTryExpression.getCatchClauses();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            boolean bl2;
                            block15: {
                                UCatchClause catchClause = (UCatchClause)element$iv;
                                boolean bl3 = false;
                                Iterable $this$any$iv2 = catchClause.getTypes();
                                boolean $i$f$any2 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (T element$iv2 : $this$any$iv2) {
                                        boolean bl4;
                                        block14: {
                                            void $this$any$iv3;
                                            List list;
                                            PsiType type = (PsiType)element$iv2;
                                            boolean bl5 = false;
                                            if (type instanceof PsiDisjunctionType) {
                                                List list2 = ((PsiDisjunctionType)type).getDisjunctions();
                                                list = list2;
                                                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDisjunctions(...)");
                                            } else {
                                                list = CollectionsKt.listOf((Object)type);
                                            }
                                            Iterable iterable = list;
                                            boolean $i$f$any3 = false;
                                            if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                                                bl4 = false;
                                            } else {
                                                for (T element$iv3 : $this$any$iv3) {
                                                    PsiType it = (PsiType)element$iv3;
                                                    boolean bl6 = false;
                                                    Intrinsics.checkNotNull((Object)it);
                                                    if (!this.isInheritorOrSelf(it, thrownExceptionClass)) continue;
                                                    bl4 = true;
                                                    break block14;
                                                }
                                                bl4 = false;
                                            }
                                        }
                                        if (!bl4) continue;
                                        bl2 = true;
                                        break block15;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!bl2) continue;
                            bl = true;
                            break block16;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private final void inspectIncorrectImplicitCeHandling(UCatchClause catchClause, CaughtCeInfo caughtCeInfo) {
                UExpression loggingExpression;
                UExpression catchBody = catchClause.getBody();
                if (!this.ceIsRethrown(catchBody, caughtCeInfo.getParameter())) {
                    String string;
                    String string2 = caughtCeInfo.getCeThrowingMethodName();
                    if (string2 == null) {
                        return;
                    }
                    String methodName = string2;
                    if (caughtCeInfo.isInheritor()) {
                        var6_5 = new Object[]{caughtCeInfo.getBaseCeClassName(), methodName};
                        string = DevKitBundle.message("inspections.incorrect.implicit.cancellation.exception.inheritor.handling.name.not.rethrown", var6_5);
                    } else {
                        var6_5 = new Object[]{caughtCeInfo.getBaseCeClassName(), methodName};
                        string = DevKitBundle.message("inspections.incorrect.implicit.cancellation.exception.handling.name.not.rethrown", var6_5);
                    }
                    String message = string;
                    UDeclaration uDeclaration = (UDeclaration)caughtCeInfo.getParameter();
                    Intrinsics.checkNotNull((Object)message);
                    ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.$holder, (UDeclaration)uDeclaration, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
                }
                if ((loggingExpression = this.findCeLoggingExpression(catchBody, caughtCeInfo.getParameter())) != null) {
                    String string;
                    String string3 = caughtCeInfo.getCeThrowingMethodName();
                    if (string3 == null) {
                        return;
                    }
                    String methodName = string3;
                    if (caughtCeInfo.isInheritor()) {
                        var7_7 = new Object[]{caughtCeInfo.getBaseCeClassName(), methodName};
                        string = DevKitBundle.message("inspections.incorrect.implicit.cancellation.exception.inheritor.handling.name.logged", var7_7);
                    } else {
                        var7_7 = new Object[]{caughtCeInfo.getBaseCeClassName(), methodName};
                        string = DevKitBundle.message("inspections.incorrect.implicit.cancellation.exception.handling.name.logged", var7_7);
                    }
                    String message = string;
                    Intrinsics.checkNotNull((Object)message);
                    ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.$holder, (UExpression)loggingExpression, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
                }
            }

            private final boolean ceIsRethrown(UExpression catchBody, UParameter caughtParam) {
                Ref.BooleanRef found = new Ref.BooleanRef();
                catchBody.accept((UastVisitor)new AbstractUastVisitor(caughtParam, found){
                    final /* synthetic */ UParameter $caughtParam;
                    final /* synthetic */ Ref.BooleanRef $found;
                    {
                        this.$caughtParam = $caughtParam;
                        this.$found = $found;
                    }

                    public boolean visitThrowExpression(UThrowExpression node) {
                        UElement resolvedParam;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        UExpression uExpression = node.getThrownExpression();
                        USimpleNameReferenceExpression uSimpleNameReferenceExpression = uExpression instanceof USimpleNameReferenceExpression ? (USimpleNameReferenceExpression)uExpression : null;
                        Object object = resolvedParam = uSimpleNameReferenceExpression != null ? UResolvableKt.resolveToUElement((UResolvable)((UResolvable)uSimpleNameReferenceExpression)) : null;
                        if (Intrinsics.areEqual((Object)this.$caughtParam, (Object)resolvedParam)) {
                            this.$found.element = true;
                        }
                        return super.visitThrowExpression(node);
                    }
                });
                return found.element;
            }

            private final UExpression findCeLoggingExpression(UExpression catchBody, UParameter caughtParam) {
                Ref.ObjectRef loggingExpression = new Ref.ObjectRef();
                catchBody.accept((UastVisitor)new AbstractUastVisitor(caughtParam, this, (Ref.ObjectRef<UExpression>)loggingExpression){
                    final /* synthetic */ UParameter $caughtParam;
                    final /* synthetic */ buildInternalVisitor.1 this$0;
                    final /* synthetic */ Ref.ObjectRef<UExpression> $loggingExpression;
                    {
                        this.$caughtParam = $caughtParam;
                        this.this$0 = $receiver;
                        this.$loggingExpression = $loggingExpression;
                    }

                    public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (Intrinsics.areEqual((Object)this.$caughtParam, (Object)UResolvableKt.resolveToUElement((UResolvable)((UResolvable)node)))) {
                            boolean bl;
                            Object $this$getParentOfType_u24default$iv = (UElement)node;
                            boolean strict$iv = true;
                            boolean $i$f$getParentOfType = false;
                            UCallExpression uCallExpression = (UCallExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UCallExpression.class, (boolean)strict$iv);
                            if (uCallExpression == null) {
                                return super.visitSimpleNameReferenceExpression(node);
                            }
                            UCallExpression callExpression = uCallExpression;
                            PsiType psiType = callExpression.getReceiverType();
                            if (psiType != null) {
                                boolean bl2;
                                block10: {
                                    $this$getParentOfType_u24default$iv = this.this$0;
                                    PsiType $this$isClassType$iv = psiType;
                                    boolean $i$f$isClassType = false;
                                    if ($this$isClassType$iv instanceof PsiDisjunctionType) {
                                        List list = ((PsiDisjunctionType)$this$isClassType$iv).getDisjunctions();
                                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDisjunctions(...)");
                                        Iterable $this$any$iv$iv = list;
                                        boolean $i$f$any = false;
                                        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                                            bl2 = false;
                                        } else {
                                            for (T element$iv$iv : $this$any$iv$iv) {
                                                PsiType it$iv = (PsiType)element$iv$iv;
                                                boolean bl3 = false;
                                                if (!PsiTypesUtil.classNameEquals((PsiType)it$iv, (String)Logger.class.getName())) continue;
                                                bl2 = true;
                                                break block10;
                                            }
                                            bl2 = false;
                                        }
                                    } else {
                                        bl2 = PsiTypesUtil.classNameEquals((PsiType)$this$isClassType$iv, (String)Logger.class.getName());
                                    }
                                }
                                bl = bl2;
                            } else {
                                bl = false;
                            }
                            if (bl) {
                                this.$loggingExpression.element = callExpression;
                            }
                        }
                        return super.visitSimpleNameReferenceExpression(node);
                    }
                });
                return (UExpression)loggingExpression.element;
            }

            private final /* synthetic */ <T> boolean isClassType(PsiType $this$isClassType) {
                boolean $i$f$isClassType = false;
                if ($this$isClassType instanceof PsiDisjunctionType) {
                    boolean bl;
                    block4: {
                        List list = ((PsiDisjunctionType)$this$isClassType).getDisjunctions();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDisjunctions(...)");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                PsiType it = (PsiType)element$iv;
                                boolean bl2 = false;
                                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                                if (!PsiTypesUtil.classNameEquals((PsiType)it, (String)Object.class.getName())) continue;
                                bl = true;
                                break block4;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return PsiTypesUtil.classNameEquals((PsiType)$this$isClassType, (String)Object.class.getName());
            }

            private final /* synthetic */ <T> boolean containsCatchClauseForType(UTryExpression $this$containsCatchClauseForType) {
                boolean bl;
                block13: {
                    boolean $i$f$containsCatchClauseForType = false;
                    Iterable $this$any$iv = $this$containsCatchClauseForType.getCatchClauses();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            boolean bl2;
                            block12: {
                                UCatchClause clause = (UCatchClause)element$iv;
                                boolean bl3 = false;
                                Iterable $this$any$iv2 = clause.getParameters();
                                boolean $i$f$any2 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (T element$iv2 : $this$any$iv2) {
                                        boolean bl4;
                                        block11: {
                                            UParameter it = (UParameter)element$iv2;
                                            boolean bl5 = false;
                                            buildInternalVisitor.1 var15_15 = this;
                                            PsiType $this$isClassType$iv = it.getType();
                                            boolean $i$f$isClassType = false;
                                            if ($this$isClassType$iv instanceof PsiDisjunctionType) {
                                                List list = ((PsiDisjunctionType)$this$isClassType$iv).getDisjunctions();
                                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDisjunctions(...)");
                                                Iterable $this$any$iv$iv = list;
                                                boolean $i$f$any3 = false;
                                                if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                                                    bl4 = false;
                                                } else {
                                                    for (T element$iv$iv : $this$any$iv$iv) {
                                                        PsiType it$iv = (PsiType)element$iv$iv;
                                                        boolean bl6 = false;
                                                        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                                                        if (!PsiTypesUtil.classNameEquals((PsiType)it$iv, (String)Object.class.getName())) continue;
                                                        bl4 = true;
                                                        break block11;
                                                    }
                                                    bl4 = false;
                                                }
                                            } else {
                                                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                                                bl4 = PsiTypesUtil.classNameEquals((PsiType)$this$isClassType$iv, (String)Object.class.getName());
                                            }
                                        }
                                        if (!bl4) continue;
                                        bl2 = true;
                                        break block12;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!bl2) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean containsMoreSpecificCatchClause(UTryExpression $this$containsMoreSpecificCatchClause, UParameter param) {
                boolean bl;
                UTryExpression $this$containsCatchClauseForType$iv;
                String string;
                PsiType psiType = param.getType();
                PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                String string2 = psiClassType != null && (psiClassType = psiClassType.resolve()) != null ? psiClassType.getQualifiedName() : (string = null);
                if (Intrinsics.areEqual((Object)string, (Object)Throwable.class.getName())) {
                    boolean bl2;
                    boolean bl3;
                    PsiType it$iv$iv;
                    boolean $i$f$any;
                    Iterable $this$any$iv$iv$iv;
                    boolean $i$f$isClassType;
                    PsiType $this$isClassType$iv$iv;
                    buildInternalVisitor.1 this_$iv;
                    boolean bl4;
                    UParameter it$iv;
                    boolean $i$f$any2;
                    Iterable $this$any$iv$iv;
                    boolean bl5;
                    UCatchClause clause$iv;
                    boolean bl6;
                    buildInternalVisitor.1 var4_5 = this;
                    $this$containsCatchClauseForType$iv = $this$containsMoreSpecificCatchClause;
                    boolean $i$f$containsCatchClauseForType = false;
                    Iterable $this$any$iv$iv2 = $this$containsCatchClauseForType$iv.getCatchClauses();
                    boolean $i$f$any3 = false;
                    if ($this$any$iv$iv2 instanceof Collection && ((Collection)$this$any$iv$iv2).isEmpty()) {
                        bl6 = false;
                    } else {
                        for (T element$iv$iv : $this$any$iv$iv2) {
                            boolean bl7;
                            clause$iv = (UCatchClause)element$iv$iv;
                            bl5 = false;
                            $this$any$iv$iv = clause$iv.getParameters();
                            $i$f$any2 = false;
                            if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                                bl7 = false;
                            } else {
                                for (T element$iv$iv2 : $this$any$iv$iv) {
                                    boolean bl8;
                                    it$iv = (UParameter)element$iv$iv2;
                                    bl4 = false;
                                    buildInternalVisitor.1 var19_33 = this_$iv;
                                    $this$isClassType$iv$iv = it$iv.getType();
                                    $i$f$isClassType = false;
                                    if ($this$isClassType$iv$iv instanceof PsiDisjunctionType) {
                                        List list = ((PsiDisjunctionType)$this$isClassType$iv$iv).getDisjunctions();
                                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDisjunctions(...)");
                                        $this$any$iv$iv$iv = list;
                                        $i$f$any = false;
                                        if ($this$any$iv$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv$iv).isEmpty()) {
                                            bl8 = false;
                                        } else {
                                            for (T element$iv$iv$iv : $this$any$iv$iv$iv) {
                                                it$iv$iv = (PsiType)element$iv$iv$iv;
                                                bl3 = false;
                                                if (!PsiTypesUtil.classNameEquals((PsiType)it$iv$iv, (String)Exception.class.getName())) continue;
                                                return true;
                                            }
                                            bl8 = false;
                                        }
                                    } else {
                                        bl8 = PsiTypesUtil.classNameEquals((PsiType)$this$isClassType$iv$iv, (String)Exception.class.getName());
                                    }
                                    if (!bl8) continue;
                                    return true;
                                }
                                bl7 = false;
                            }
                            if (!bl7) continue;
                            return true;
                        }
                        bl6 = false;
                    }
                    if (bl6) return true;
                    this_$iv = this;
                    $this$containsCatchClauseForType$iv = $this$containsMoreSpecificCatchClause;
                    $i$f$containsCatchClauseForType = false;
                    $this$any$iv$iv2 = $this$containsCatchClauseForType$iv.getCatchClauses();
                    $i$f$any3 = false;
                    if ($this$any$iv$iv2 instanceof Collection && ((Collection)$this$any$iv$iv2).isEmpty()) {
                        return false;
                    }
                    Iterator<T> iterator = $this$any$iv$iv2.iterator();
                    do {
                        T element$iv$iv;
                        if (!iterator.hasNext()) return false;
                        element$iv$iv = iterator.next();
                        clause$iv = (UCatchClause)element$iv$iv;
                        bl5 = false;
                        $this$any$iv$iv = clause$iv.getParameters();
                        $i$f$any2 = false;
                        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                            bl2 = false;
                            continue;
                        }
                        for (T element$iv$iv2 : $this$any$iv$iv) {
                            boolean bl9;
                            it$iv = (UParameter)element$iv$iv2;
                            bl4 = false;
                            buildInternalVisitor.1 this_$iv$iv = this_$iv;
                            $this$isClassType$iv$iv = it$iv.getType();
                            $i$f$isClassType = false;
                            if ($this$isClassType$iv$iv instanceof PsiDisjunctionType) {
                                List list = ((PsiDisjunctionType)$this$isClassType$iv$iv).getDisjunctions();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDisjunctions(...)");
                                $this$any$iv$iv$iv = list;
                                $i$f$any = false;
                                if ($this$any$iv$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv$iv).isEmpty()) {
                                    bl9 = false;
                                } else {
                                    for (T element$iv$iv$iv : $this$any$iv$iv$iv) {
                                        it$iv$iv = (PsiType)element$iv$iv$iv;
                                        bl3 = false;
                                        if (!PsiTypesUtil.classNameEquals((PsiType)it$iv$iv, (String)RuntimeException.class.getName())) continue;
                                        return true;
                                    }
                                    bl9 = false;
                                }
                            } else {
                                bl9 = PsiTypesUtil.classNameEquals((PsiType)$this$isClassType$iv$iv, (String)RuntimeException.class.getName());
                            }
                            if (!bl9) continue;
                            return true;
                        }
                        bl2 = false;
                    } while (!bl2);
                    return true;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)Exception.class.getName())) return false;
                buildInternalVisitor.1 this_$iv = this;
                $this$containsCatchClauseForType$iv = $this$containsMoreSpecificCatchClause;
                boolean $i$f$containsCatchClauseForType = false;
                Iterable $this$any$iv$iv = $this$containsCatchClauseForType$iv.getCatchClauses();
                boolean $i$f$any = false;
                if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator = $this$any$iv$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    T element$iv$iv = iterator.next();
                    UCatchClause clause$iv = (UCatchClause)element$iv$iv;
                    boolean bl10 = false;
                    Iterable $this$any$iv$iv3 = clause$iv.getParameters();
                    boolean $i$f$any4 = false;
                    if ($this$any$iv$iv3 instanceof Collection && ((Collection)$this$any$iv$iv3).isEmpty()) {
                        bl = false;
                        continue;
                    }
                    for (T element$iv$iv3 : $this$any$iv$iv3) {
                        boolean bl11;
                        UParameter it$iv = (UParameter)element$iv$iv3;
                        boolean bl12 = false;
                        buildInternalVisitor.1 this_$iv$iv = this_$iv;
                        PsiType $this$isClassType$iv$iv = it$iv.getType();
                        boolean $i$f$isClassType = false;
                        if ($this$isClassType$iv$iv instanceof PsiDisjunctionType) {
                            List list = ((PsiDisjunctionType)$this$isClassType$iv$iv).getDisjunctions();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDisjunctions(...)");
                            Iterable $this$any$iv$iv$iv = list;
                            boolean $i$f$any5 = false;
                            if ($this$any$iv$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv$iv).isEmpty()) {
                                bl11 = false;
                            } else {
                                for (T element$iv$iv$iv : $this$any$iv$iv$iv) {
                                    PsiType it$iv$iv = (PsiType)element$iv$iv$iv;
                                    boolean bl13 = false;
                                    if (!PsiTypesUtil.classNameEquals((PsiType)it$iv$iv, (String)RuntimeException.class.getName())) continue;
                                    return true;
                                }
                                bl11 = false;
                            }
                        } else {
                            bl11 = PsiTypesUtil.classNameEquals((PsiType)$this$isClassType$iv$iv, (String)RuntimeException.class.getName());
                        }
                        if (!bl11) continue;
                        return true;
                    }
                    bl = false;
                } while (!bl);
                return true;
            }

            public static final /* synthetic */ boolean access$isInNestedTryCatchBlock(buildInternalVisitor.1 $this, UCallExpression expression, UTryExpression checkedTryExpression, PsiClassType thrownExceptionType) {
                return $this.isInNestedTryCatchBlock(expression, checkedTryExpression, thrownExceptionType);
            }

            public static final /* synthetic */ boolean access$isCancellationExceptionClass(buildInternalVisitor.1 $this, PsiType $receiver) {
                return $this.isCancellationExceptionClass($receiver);
            }

            public static final /* synthetic */ boolean access$isInheritorOrSelf(buildInternalVisitor.1 $this, PsiType $receiver, PsiClass ceClass) {
                return $this.isInheritorOrSelf($receiver, ceClass);
            }
        }, (Class[])classArray, (boolean)false, (int)8, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/devkit/inspections/IncorrectCancellationExceptionHandlingInspection$CaughtCeInfo;", "", "baseCeClassName", "", "isInheritor", "", "parameter", "Lorg/jetbrains/uast/UParameter;", "ceThrowingMethodName", "<init>", "(Ljava/lang/String;ZLorg/jetbrains/uast/UParameter;Ljava/lang/String;)V", "getBaseCeClassName", "()Ljava/lang/String;", "()Z", "getParameter", "()Lorg/jetbrains/uast/UParameter;", "getCeThrowingMethodName", "intellij.devkit.core"})
    private static final class CaughtCeInfo {
        @NotNull
        private final String baseCeClassName;
        private final boolean isInheritor;
        @NotNull
        private final UParameter parameter;
        @Nullable
        private final String ceThrowingMethodName;

        public CaughtCeInfo(@NotNull String baseCeClassName, boolean isInheritor, @NotNull UParameter parameter, @Nullable String ceThrowingMethodName) {
            Intrinsics.checkNotNullParameter((Object)baseCeClassName, (String)"baseCeClassName");
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            this.baseCeClassName = baseCeClassName;
            this.isInheritor = isInheritor;
            this.parameter = parameter;
            this.ceThrowingMethodName = ceThrowingMethodName;
        }

        public /* synthetic */ CaughtCeInfo(String string, boolean bl, UParameter uParameter, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string2 = null;
            }
            this(string, bl, uParameter, string2);
        }

        @NotNull
        public final String getBaseCeClassName() {
            return this.baseCeClassName;
        }

        public final boolean isInheritor() {
            return this.isInheritor;
        }

        @NotNull
        public final UParameter getParameter() {
            return this.parameter;
        }

        @Nullable
        public final String getCeThrowingMethodName() {
            return this.ceThrowingMethodName;
        }
    }
}

