/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/devkit/inspections/IncorrectParentDisposableInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "<init>", "()V", "isAllowed", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "buildInternalVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "isOnTheFly", "sdkLink", "", "checkCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nIncorrectParentDisposableInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncorrectParentDisposableInspection.kt\norg/jetbrains/idea/devkit/inspections/IncorrectParentDisposableInspection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,73:1\n13474#2,3:74\n*S KotlinDebug\n*F\n+ 1 IncorrectParentDisposableInspection.kt\norg/jetbrains/idea/devkit/inspections/IncorrectParentDisposableInspection\n*L\n38#1:74,3\n*E\n"})
public final class IncorrectParentDisposableInspection
extends DevKitUastInspectionBase {
    @NotNull
    private final String sdkLink;

    public IncorrectParentDisposableInspection() {
        this.sdkLink = "https://plugins.jetbrains.com/docs/intellij/disposers.html?from=IncorrectParentDisposable#choosing-a-disposable-parent";
    }

    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return DevKitInspectionUtil.isAllowedInPluginsOnly(holder.getFile());
    }

    @Override
    @NotNull
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UCallExpression.class};
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this, holder){
            final /* synthetic */ IncorrectParentDisposableInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public boolean visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                IncorrectParentDisposableInspection.access$checkCallExpression(this.this$0, node, this.$holder);
                return true;
            }
        }, (Class[])classArray, (boolean)false, (int)8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCallExpression(UCallExpression node, ProblemsHolder holder) {
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiMethod psiMethod2 = psiMethod;
        if (Intrinsics.areEqual((Object)psiMethod2.getName(), (Object)"isDisposed")) {
            return;
        }
        JvmParameter[] jvmParameterArray = psiMethod2.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"getParameters(...)");
        Object[] $this$forEachIndexed$iv = jvmParameterArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            PsiElement argumentSourcePsi;
            String typeName;
            GlobalSearchScope callSiteResolveScope;
            Project project;
            PsiType psiType;
            PsiClassType psiClassType;
            UExpression argument;
            PsiClassType parameterType;
            void parameter;
            int n = index$iv++;
            JvmParameter jvmParameter = (JvmParameter)item$iv;
            int index = n;
            boolean bl = false;
            JvmType jvmType = parameter.getType();
            PsiClassType psiClassType2 = jvmType instanceof PsiClassType ? (PsiClassType)jvmType : null;
            if (psiClassType2 == null) continue;
            if ((psiClassType2 = psiClassType2.resolve()) == null || !Intrinsics.areEqual((Object)(parameterType = psiClassType2).getQualifiedName(), (Object)Disposable.class.getName()) || node.getArgumentForParameter(index) == null || argument.getSourcePsi() == null || (psiClassType = (psiType = argument.getExpressionType()) instanceof PsiClassType ? (PsiClassType)psiType : null) == null || (psiClassType = psiClassType.resolve()) == null) continue;
            PsiClassType argumentType = psiClassType;
            Intrinsics.checkNotNullExpressionValue((Object)argumentType.getProject(), (String)"getProject(...)");
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)holder.getFile().getResolveScope(), (String)"getResolveScope(...)");
            String string = InheritanceUtil.isInheritorOrSelf((PsiClass)argumentType, (PsiClass)facade.findClass(Project.class.getName(), callSiteResolveScope), (boolean)true) ? "Project" : (InheritanceUtil.isInheritorOrSelf((PsiClass)argumentType, (PsiClass)facade.findClass(Application.class.getName(), callSiteResolveScope), (boolean)true) ? "Application" : (typeName = InheritanceUtil.isInheritorOrSelf((PsiClass)argumentType, (PsiClass)facade.findClass(Module.class.getName(), callSiteResolveScope), (boolean)true) ? "Module" : null));
            if (typeName == null) continue;
            Object[] objectArray = new Object[]{typeName};
            holder.registerProblem(argumentSourcePsi, new HtmlBuilder().append(DevKitBundle.message("inspections.IncorrectParentDisposableInspection.do.not.use.as.disposable", objectArray)).nbsp().append("(").appendLink(this.sdkLink, DevKitBundle.message("inspections.IncorrectParentDisposableInspection.documentation.link.title", new Object[0])).append(")").wrapWith(HtmlChunk.html()).toString(), new LocalQuickFix[0]);
        }
    }

    public static final /* synthetic */ void access$checkCallExpression(IncorrectParentDisposableInspection $this, UCallExpression node, ProblemsHolder holder) {
        $this.checkCallExpression(node, holder);
    }
}

