/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.uast.UastHintedVisitorAdapter;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.IncorrectServiceRetrievingInspection;
import org.jetbrains.idea.devkit.inspections.LevelType;
import org.jetbrains.idea.devkit.inspections.ServiceRetrievingInspectionBase;
import org.jetbrains.idea.devkit.inspections.ServiceUtil;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/IncorrectServiceRetrievingInspection;", "Lorg/jetbrains/idea/devkit/inspections/ServiceRetrievingInspectionBase;", "<init>", "()V", "buildInternalVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isServiceRetrievedCorrectly", "serviceLevel", "Lorg/jetbrains/idea/devkit/inspections/LevelType;", "howServiceRetrieved", "Lcom/intellij/openapi/components/Service$Level;", "intellij.devkit.core"})
public final class IncorrectServiceRetrievingInspection
extends ServiceRetrievingInspectionBase {
    public IncorrectServiceRetrievingInspection() {
        String[] stringArray = new String[]{"getServiceIfCreated"};
        String[] stringArray2 = stringArray;
        stringArray = new String[]{"serviceOrNull", "serviceIfCreated"};
        super(stringArray2, stringArray);
    }

    @Override
    @NotNull
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UCallExpression.class};
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this, holder){
            final /* synthetic */ IncorrectServiceRetrievingInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public boolean visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                ServiceRetrievingInspectionBase.ServiceRetrievingInfo serviceRetrievingInfo = this.this$0.getServiceRetrievingInfo(node);
                if (serviceRetrievingInfo == null) {
                    return true;
                }
                ServiceRetrievingInspectionBase.ServiceRetrievingInfo serviceRetrievingInfo2 = serviceRetrievingInfo;
                Service.Level howServiceRetrieved = serviceRetrievingInfo2.component1();
                UClass serviceClass = serviceRetrievingInfo2.component2();
                Project project = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                LevelType serviceLevel = ServiceUtil.getLevelType(project, serviceClass);
                if (serviceLevel == LevelType.MODULE) {
                    return true;
                }
                if (serviceLevel == LevelType.NOT_REGISTERED) {
                    String string = serviceClass.getQualifiedName();
                    if (string != null) {
                        String string2 = string;
                        ProblemsHolder problemsHolder = this.$holder;
                        String className = string2;
                        boolean bl = false;
                        Object[] objectArray = new Object[]{className};
                        String message = DevKitBundle.message("inspection.incorrect.service.retrieving.not.registered", objectArray);
                        Intrinsics.checkNotNull((Object)message);
                        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)problemsHolder, (UCallExpression)node, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
                    }
                } else if (!IncorrectServiceRetrievingInspection.access$isServiceRetrievedCorrectly(this.this$0, serviceLevel, howServiceRetrieved)) {
                    String message = switch (buildInternalVisitor.WhenMappings.$EnumSwitchMapping$0[howServiceRetrieved.ordinal()]) {
                        case 1 -> DevKitBundle.message("inspection.incorrect.service.retrieving.mismatch.for.project.level", new Object[0]);
                        case 2 -> DevKitBundle.message("inspection.incorrect.service.retrieving.mismatch.for.app.level", new Object[0]);
                        default -> throw new NoWhenBranchMatchedException();
                    };
                    Intrinsics.checkNotNull((Object)message);
                    ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.$holder, (UCallExpression)node, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
                }
                return true;
            }
        }, (Class[])classArray, (boolean)false, (int)8, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isServiceRetrievedCorrectly(LevelType serviceLevel, Service.Level howServiceRetrieved) {
        if (serviceLevel == LevelType.NOT_SPECIFIED) return true;
        if (!(switch (WhenMappings.$EnumSwitchMapping$0[howServiceRetrieved.ordinal()]) {
            case 1 -> serviceLevel.isApp();
            case 2 -> serviceLevel.isProject();
            default -> throw new NoWhenBranchMatchedException();
        })) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$isServiceRetrievedCorrectly(IncorrectServiceRetrievingInspection $this, LevelType serviceLevel, Service.Level howServiceRetrieved) {
        return $this.isServiceRetrievedCorrectly(serviceLevel, howServiceRetrieved);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Service.Level.values().length];
            try {
                nArray[Service.Level.APP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Service.Level.PROJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

