/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.Query;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.quickfix.PluginDescriptorChooser;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;

public final class InspectionDescriptionInfo {
    private final String myFilename;
    private final PsiMethod myMethod;
    private final PsiFile myDescriptionFile;
    private final boolean myShortNameInXml;

    private InspectionDescriptionInfo(String filename, @Nullable PsiMethod method, @Nullable PsiFile descriptionFile, boolean shortNameInXml) {
        this.myFilename = filename;
        this.myMethod = method;
        this.myDescriptionFile = descriptionFile;
        this.myShortNameInXml = shortNameInXml;
    }

    public static InspectionDescriptionInfo create(Module module, PsiClass psiClass) {
        String className;
        boolean shortNameInXml;
        PsiMethod getShortNameMethod = PsiUtil.findNearestMethod("getShortName", psiClass);
        if (getShortNameMethod != null && Objects.requireNonNull(getShortNameMethod.getContainingClass()).hasModifierProperty("abstract")) {
            getShortNameMethod = null;
        }
        String filename = null;
        if (getShortNameMethod == null) {
            Extension extension;
            shortNameInXml = true;
            className = psiClass.getQualifiedName();
            if (className != null && (extension = InspectionDescriptionInfo.findExtension(psiClass)) != null) {
                filename = extension.getXmlTag().getAttributeValue("shortName");
            }
        } else {
            shortNameInXml = false;
            filename = InspectionDescriptionInfo.getReturnedLiteral(getShortNameMethod, psiClass);
        }
        if (filename == null && (className = psiClass.getName()) != null) {
            filename = InspectionProfileEntry.getShortName((String)className);
        }
        PsiFile descriptionFile = InspectionDescriptionInfo.resolveInspectionDescriptionFile(module, filename);
        return new InspectionDescriptionInfo(filename, getShortNameMethod, descriptionFile, shortNameInXml);
    }

    @Nullable
    public static Extension findExtension(PsiClass psiClass) {
        return (Extension)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
            Extension extension = module == null ? null : InspectionDescriptionInfo.doFindExtension(module, psiClass);
            return CachedValueProvider.Result.create((Object)extension, (Object[])new Object[]{UastModificationTracker.getInstance((Project)psiClass.getProject()), psiClass.getManager().getModificationTracker().forLanguage((Language)XMLLanguage.INSTANCE)});
        });
    }

    @Nullable
    private static Extension doFindExtension(Module module, PsiClass psiClass) {
        Project project = module.getProject();
        HashSet processed = new HashSet();
        for (GlobalSearchScope scope : DescriptionCheckerUtil.searchScopes(module)) {
            List origElements = DomService.getInstance().getFileElements(IdeaPlugin.class, project, scope);
            origElements.removeAll(processed);
            List<DomFileElement<IdeaPlugin>> elements = PluginDescriptorChooser.findAppropriateIntelliJModule(module.getName(), origElements);
            Query query = ReferencesSearch.search((PsiElement)psiClass, (SearchScope)new LocalSearchScope((PsiElement[])elements.stream().map(DomFileElement::getFile).toArray(PsiElement[]::new)));
            Ref result = Ref.create(null);
            query.forEach(ref -> {
                Extension extension;
                ExtensionPoint extensionPoint;
                DomElement domElement;
                PsiElement parent;
                PsiElement element = ref.getElement();
                if (element instanceof XmlAttributeValue && (parent = element.getParent()) instanceof XmlAttribute && "implementationClass".equals(((XmlAttribute)parent).getName()) && (domElement = DomUtil.getDomElement((PsiElement)parent.getParent())) instanceof Extension && (extensionPoint = (extension = (Extension)domElement).getExtensionPoint()) != null && InheritanceUtil.isInheritor((PsiClass)((PsiClass)extensionPoint.getBeanClass().getValue()), (String)InspectionEP.class.getName())) {
                    result.set((Object)extension);
                    return false;
                }
                return true;
            });
            Extension extension = (Extension)result.get();
            if (extension != null) {
                return extension;
            }
            processed.addAll(origElements);
        }
        return null;
    }

    @Nullable
    private static PsiFile resolveInspectionDescriptionFile(Module module, @Nullable String filename) {
        if (filename == null) {
            return null;
        }
        String nameWithSuffix = filename + ".html";
        return DescriptionCheckerUtil.allDescriptionDirs(module, DescriptionType.INSPECTION).map(directory -> directory.findFile(nameWithSuffix)).nonNull().findFirst().orElse(null);
    }

    public boolean isValid() {
        return this.myFilename != null;
    }

    public String getFilename() {
        assert (this.isValid());
        return this.myFilename;
    }

    @Nullable
    public PsiMethod getShortNameMethod() {
        return this.myMethod;
    }

    @Nullable
    public PsiFile getDescriptionFile() {
        return this.myDescriptionFile;
    }

    public boolean hasDescriptionFile() {
        return this.getDescriptionFile() != null;
    }

    public boolean isShortNameInXml() {
        return this.myShortNameInXml;
    }

    @Nullable
    private static String getReturnedLiteral(PsiMethod method, PsiClass cls) {
        String methodName;
        UExpression expression = PsiUtil.getReturnedExpression(method);
        if (expression == null) {
            return null;
        }
        if (expression instanceof UReferenceExpression && "getSimpleName".equals(methodName = ((UReferenceExpression)expression).getResolvedName())) {
            return cls.getName();
        }
        return UastUtils.evaluateString((UExpression)expression);
    }
}

