/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/devkit/inspections/JComponentDataProviderInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitJvmInspection$ForClass;", "<init>", "()V", "isAllowed", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "checkClass", "", "project", "Lcom/intellij/openapi/project/Project;", "psiClass", "Lcom/intellij/psi/PsiClass;", "sink", "Lcom/intellij/lang/jvm/inspection/JvmLocalInspection$HighlightSink;", "intellij.devkit.core"})
public final class JComponentDataProviderInspection
extends DevKitJvmInspection.ForClass {
    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return super.isAllowed(holder) && DevKitInspectionUtil.isClassAvailable(holder, UiDataProvider.class.getName());
    }

    @Override
    protected void checkClass(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull JvmLocalInspection.HighlightSink sink) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (psiClass.getClassKind() != JvmClassKind.CLASS) {
            return;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)DataProvider.class.getCanonicalName())) {
            return;
        }
        if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)UiCompatibleDataProvider.class.getCanonicalName())) {
            return;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)JComponent.class.getCanonicalName())) {
            return;
        }
        sink.highlight(DevKitBundle.message("inspections.jcomponent.data.provider.use.uidataprovider.instead.of.dataprovider", new Object[0]), new LocalQuickFix[0]);
    }
}

