/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.util.JvmInheritanceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.ExtensionUtil;
import org.jetbrains.idea.devkit.inspections.LightServiceMigrationUtil;
import org.jetbrains.idea.devkit.inspections.ServiceInfo;
import org.jetbrains.idea.devkit.inspections.ServiceUtil;
import org.jetbrains.idea.devkit.inspections.quickfix.ConvertToLightServiceFix;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ9\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/devkit/inspections/LightServiceMigrationCodeInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "<init>", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "aClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "registerProblem", "fixes", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z[Lcom/intellij/codeInspection/LocalQuickFix;)[Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.devkit.core"})
public final class LightServiceMigrationCodeInspection
extends DevKitUastInspectionBase {
    public LightServiceMigrationCodeInspection() {
        Class[] classArray = new Class[]{UClass.class};
        super(classArray);
    }

    @NotNull
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PsiClass psiClass = aClass.getJavaPsi();
        if (!aClass.isFinal() || !ExtensionUtil.isExtensionPointImplementationCandidate(psiClass)) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (LightServiceMigrationUtil.isVersion193OrHigher(psiClass) || ApplicationManager.getApplication().isUnitTestMode()) {
            if (ServiceUtil.isLightService(psiClass)) {
                Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            ExtensionCandidate extensionCandidate = (ExtensionCandidate)CollectionsKt.singleOrNull(ExtensionLocatorKt.locateExtensionsByPsiClass(psiClass));
            if (extensionCandidate == null) {
                Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            ExtensionCandidate candidate = extensionCandidate;
            Extension extension = (Extension)DomUtil.findDomElement((PsiElement)candidate.pointer.getElement(), Extension.class, (boolean)false);
            if (extension == null) {
                Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            Extension extension2 = extension;
            ServiceInfo serviceInfo = LightServiceMigrationUtil.getServiceImplementation(extension2);
            if (serviceInfo == null) {
                Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            ServiceInfo serviceInfo2 = serviceInfo;
            PsiClass serviceImplementation = serviceInfo2.component1();
            Service.Level level = serviceInfo2.component2();
            if (level == Service.Level.APP && JvmInheritanceUtil.isInheritor((JvmClass)((JvmClass)aClass), (String)PersistentStateComponent.class.getCanonicalName())) {
                Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            if (Intrinsics.areEqual((Object)serviceImplementation, (Object)psiClass) && !LightServiceMigrationUtil.containsUnitTestOrHeadlessModeCheck(aClass)) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                PsiElement psiElement = (PsiElement)psiClass;
                XmlTag xmlTag = extension2.getXmlTag();
                Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"getXmlTag(...)");
                localQuickFixArray[0] = new ConvertToLightServiceFix(psiElement, xmlTag, level);
                LocalQuickFix[] fixes = localQuickFixArray;
                return this.registerProblem(aClass, manager, isOnTheFly, fixes);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private final ProblemDescriptor[] registerProblem(UClass aClass, InspectionManager manager, boolean isOnTheFly, LocalQuickFix[] fixes) {
        ProblemsHolder problemsHolder = DevKitUastInspectionBase.createProblemsHolder((UElement)aClass, manager, isOnTheFly);
        Intrinsics.checkNotNullExpressionValue((Object)problemsHolder, (String)"createProblemsHolder(...)");
        ProblemsHolder holder = problemsHolder;
        UDeclaration uDeclaration = (UDeclaration)aClass;
        String string = DevKitBundle.message("inspection.light.service.migration.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)holder, (UDeclaration)uDeclaration, (String)string, (LocalQuickFix[])Arrays.copyOf(fixes, fixes.length), null, (int)8, null);
        ProblemDescriptor[] problemDescriptorArray = holder.getResultsArray();
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"getResultsArray(...)");
        return problemDescriptorArray;
    }
}

