/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.util.JvmInheritanceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.highlighting.RemoveDomElementQuickFix;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;
import org.jetbrains.idea.devkit.inspections.LightServiceMigrationUtil;
import org.jetbrains.idea.devkit.inspections.ServiceInfo;
import org.jetbrains.idea.devkit.inspections.quickfix.ConvertToLightServiceFix;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/devkit/inspections/LightServiceMigrationXMLInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitPluginXmlInspectionBase;", "<init>", "()V", "checkDomElement", "", "element", "Lcom/intellij/util/xml/DomElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "helper", "Lcom/intellij/util/xml/highlighting/DomHighlightingHelper;", "isLibraryClass", "", "aClass", "Lcom/intellij/psi/PsiClass;", "intellij.devkit.core"})
public final class LightServiceMigrationXMLInspection
extends DevKitPluginXmlInspectionBase {
    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        if (!(element instanceof Extension)) {
            return;
        }
        if (!this.isAllowed(holder)) {
            return;
        }
        if (LightServiceMigrationUtil.isVersion193OrHigher(element) || ApplicationManager.getApplication().isUnitTestMode()) {
            ServiceInfo serviceInfo = LightServiceMigrationUtil.getServiceImplementation((Extension)element);
            if (serviceInfo == null) {
                return;
            }
            ServiceInfo serviceInfo2 = serviceInfo;
            PsiClass aClass = serviceInfo2.component1();
            Service.Level level = serviceInfo2.component2();
            if (!aClass.hasModifier(JvmModifier.FINAL) || this.isLibraryClass(aClass)) {
                return;
            }
            if (level == Service.Level.APP && JvmInheritanceUtil.isInheritor((JvmClass)((JvmClass)aClass), (String)PersistentStateComponent.class.getCanonicalName())) {
                return;
            }
            if (ExtensionLocatorKt.locateExtensionsByPsiClass(aClass).size() != 1) {
                return;
            }
            UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)((PsiElement)aClass), UClass.class);
            if (uClass == null || LightServiceMigrationUtil.containsUnitTestOrHeadlessModeCheck(uClass)) {
                return;
            }
            if (aClass.hasAnnotation(Service.class.getCanonicalName())) {
                String message = DevKitBundle.message("inspection.light.service.migration.already.annotated.message", new Object[0]);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveDomElementQuickFix(element)};
                v1 = holder.createProblem(element, ProblemHighlightType.ERROR, message, null, localQuickFixArray);
            } else {
                String message = DevKitBundle.message("inspection.light.service.migration.message", new Object[0]);
                PsiElement psiElement = (PsiElement)aClass;
                XmlTag xmlTag = ((Extension)element).getXmlTag();
                Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"getXmlTag(...)");
                ConvertToLightServiceFix fix = new ConvertToLightServiceFix(psiElement, xmlTag, level);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                v1 = holder.createProblem(element, message, localQuickFixArray);
            }
        }
    }

    private final boolean isLibraryClass(PsiClass aClass) {
        VirtualFile containingVirtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)aClass));
        return containingVirtualFile != null && ProjectFileIndex.getInstance((Project)aClass.getProject()).isInLibraryClasses(containingVirtualFile);
    }
}

