/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;
import org.jetbrains.idea.devkit.inspections.ErrorMessageProvider;
import org.jetbrains.idea.devkit.inspections.JvmProviderKt;
import org.jetbrains.idea.devkit.inspections.LightServiceMustBeFinalErrorMessageProviders;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/LightServiceMustBeFinalInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitJvmInspection$ForClass;", "<init>", "()V", "checkClass", "", "project", "Lcom/intellij/openapi/project/Project;", "psiClass", "Lcom/intellij/psi/PsiClass;", "sink", "Lcom/intellij/lang/jvm/inspection/JvmLocalInspection$HighlightSink;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nLightServiceMustBeFinalInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LightServiceMustBeFinalInspection.kt\norg/jetbrains/idea/devkit/inspections/LightServiceMustBeFinalInspection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,39:1\n37#2,2:40\n37#2,2:42\n*S KotlinDebug\n*F\n+ 1 LightServiceMustBeFinalInspection.kt\norg/jetbrains/idea/devkit/inspections/LightServiceMustBeFinalInspection\n*L\n25#1:40,2\n35#1:42,2\n*E\n"})
public final class LightServiceMustBeFinalInspection
extends DevKitJvmInspection.ForClass {
    @Override
    protected void checkClass(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull JvmLocalInspection.HighlightSink sink) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (psiClass.isAnnotationType() || psiClass.isEnum() || psiClass.hasModifier(JvmModifier.FINAL)) {
            return;
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        PsiAnnotation psiAnnotation = psiClass.getAnnotation(Service.class.getCanonicalName());
        if (psiAnnotation == null) {
            return;
        }
        PsiAnnotation serviceAnnotation = psiAnnotation;
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = serviceAnnotation.getNameReferenceElement();
        if (psiJavaCodeReferenceElement == null) {
            return;
        }
        PsiJavaCodeReferenceElement elementToReport = psiJavaCodeReferenceElement;
        if (psiClass.isInterface() || psiClass.hasModifier(JvmModifier.ABSTRACT)) {
            JvmModifiersOwner jvmModifiersOwner = (JvmModifiersOwner)psiClass;
            String string = Service.class.getCanonicalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
            List actions = JvmElementActionFactories.createRemoveAnnotationActions((JvmModifiersOwner)jvmModifiersOwner, (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)string, (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0]));
            Collection $this$toTypedArray$iv = actions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LocalQuickFix[] localQuickFixArray = IntentionWrapper.wrapToQuickFixes((IntentionAction[])thisCollection$iv.toArray(new IntentionAction[0]), (PsiFile)file);
            Intrinsics.checkNotNullExpressionValue((Object)localQuickFixArray, (String)"wrapToQuickFixes(...)");
            LocalQuickFix[] fixes = localQuickFixArray;
            String message = DevKitBundle.message("inspection.light.service.must.be.concrete.class.message", new Object[0]);
            ProblemsHolder problemsHolder = ((JvmLocalInspection.HighlightSinkImpl)sink).getHolder();
            Intrinsics.checkNotNullExpressionValue((Object)problemsHolder, (String)"getHolder(...)");
            ProblemsHolder holder = problemsHolder;
            holder.registerProblem((PsiElement)elementToReport, message, ProblemHighlightType.GENERIC_ERROR, Arrays.copyOf(fixes, fixes.length));
            return;
        }
        LanguageExtension languageExtension = LightServiceMustBeFinalErrorMessageProviders.INSTANCE;
        Language language = psiClass.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        ErrorMessageProvider errorMessageProvider = (ErrorMessageProvider)JvmProviderKt.getProvider(languageExtension, language);
        if (errorMessageProvider == null) {
            return;
        }
        ErrorMessageProvider errorMessageProvider2 = errorMessageProvider;
        String message = errorMessageProvider2.provideErrorMessage();
        List actions = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((JvmModifiersOwner)psiClass), (ChangeModifierRequest)MemberRequestsKt.modifierRequest$default((JvmModifier)JvmModifier.FINAL, (boolean)true, (boolean)false, (int)4, null));
        Collection $this$toTypedArray$iv = actions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LocalQuickFix[] localQuickFixArray = IntentionWrapper.wrapToQuickFixes((IntentionAction[])thisCollection$iv.toArray(new IntentionAction[0]), (PsiFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)localQuickFixArray, (String)"wrapToQuickFixes(...)");
        LocalQuickFix[] fixes = localQuickFixArray;
        sink.highlight(message, ProblemHighlightType.GENERIC_ERROR, Arrays.copyOf(fixes, fixes.length));
    }
}

