/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Listeners;
import org.jetbrains.idea.devkit.dom.index.IdeaPluginRegistrationIndex;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;
import org.jetbrains.idea.devkit.inspections.ExtensionUtil;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/devkit/inspections/ListenerImplementationMustNotBeDisposableInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitJvmInspection$ForClass;", "<init>", "()V", "checkClass", "", "project", "Lcom/intellij/openapi/project/Project;", "psiClass", "Lcom/intellij/psi/PsiClass;", "sink", "Lcom/intellij/lang/jvm/inspection/JvmLocalInspection$HighlightSink;", "isRegisteredListener", "", "intellij.devkit.core"})
public final class ListenerImplementationMustNotBeDisposableInspection
extends DevKitJvmInspection.ForClass {
    @Override
    protected void checkClass(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull JvmLocalInspection.HighlightSink sink) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!ExtensionUtil.isExtensionPointImplementationCandidate(psiClass)) {
            return;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)Disposable.class.getCanonicalName())) {
            return;
        }
        if (!this.isRegisteredListener(project, psiClass)) {
            return;
        }
        sink.highlight(DevKitBundle.message("inspections.listener.implementation.must.not.implement.disposable", new Object[0]), new LocalQuickFix[0]);
    }

    private final boolean isRegisteredListener(Project project, PsiClass psiClass) {
        return !IdeaPluginRegistrationIndex.processListener(project, psiClass, PluginRelatedLocatorsUtils.getCandidatesScope(project), (Processor<? extends Listeners.Listener>)((Processor)ListenerImplementationMustNotBeDisposableInspection::isRegisteredListener$lambda$0));
    }

    private static final boolean isRegisteredListener$lambda$0(Listeners.Listener it) {
        return false;
    }
}

