/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptComponent;
import com.intellij.codeInspection.options.OptNumber;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;

final class MigrateToOptControlInspection
extends DevKitUastInspectionBase {
    private static final String OPT_PANE = "com.intellij.codeInspection.options.OptPane";

    MigrateToOptControlInspection() {
        super(UMethod.class);
    }

    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            MigrateToOptControlInspection.$$$reportNull$$$0(0);
        }
        return super.isAllowed(holder) && DevKitInspectionUtil.isClassAvailable(holder, OPT_PANE);
    }

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            MigrateToOptControlInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            MigrateToOptControlInspection.$$$reportNull$$$0(2);
        }
        if (!method.getName().equals("createOptionsPanel")) {
            return null;
        }
        if (!method.getUastParameters().isEmpty()) {
            return null;
        }
        PsiClass psiClass = method.getJavaPsi().getContainingClass();
        if (psiClass == null || !InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"com.intellij.codeInspection.InspectionProfileEntry")) {
            return null;
        }
        Language language = psiClass.getLanguage();
        if (!language.equals(JavaLanguage.INSTANCE) && !language.getID().equals("kotlin")) {
            return null;
        }
        UExpression body = method.getUastBody();
        if (body == null) {
            return null;
        }
        OptPane pane = MigrateToOptControlInspection.createOptPane(body);
        if (pane == null) {
            return null;
        }
        UElement anchor = method.getUastAnchor();
        if (anchor == null) {
            return null;
        }
        PsiElement sourcePsi = anchor.getSourcePsi();
        if (sourcePsi == null) {
            return null;
        }
        ProblemDescriptor descriptor = manager.createProblemDescriptor(sourcePsi, DevKitBundle.message("inspection.migrate.to.opt.control.message", new Object[0]), (LocalQuickFix)new ConvertToOptPaneFix(pane), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true);
        return new ProblemDescriptor[]{descriptor};
    }

    @Nullable
    private static OptPane createOptPane(UExpression body) {
        UReturnExpression returnExpression;
        UExpression expression;
        if (body instanceof UBlockExpression) {
            USimpleNameReferenceExpression ref;
            UReturnExpression returnExpression2;
            UCallExpression ctor;
            UVariable var;
            UDeclarationsExpression decl;
            Object object;
            UBlockExpression blockExpression = (UBlockExpression)body;
            List expressions = blockExpression.getExpressions();
            if (expressions.isEmpty()) {
                return null;
            }
            UExpression first = (UExpression)expressions.get(0);
            if (expressions.size() == 1) {
                body = first;
            } else if (first instanceof UDeclarationsExpression && (object = ContainerUtil.getOnlyItem((Collection)(decl = (UDeclarationsExpression)first).getDeclarations())) instanceof UVariable && (object = (var = (UVariable)object).getUastInitializer()) instanceof UCallExpression && (MigrateToOptControlInspection.isConstructor(ctor = (UCallExpression)object, "MultipleCheckboxOptionsPanel") || MigrateToOptControlInspection.isConstructor(ctor, "InspectionOptionsPanel")) && (object = ContainerUtil.getLastItem((List)expressions)) instanceof UReturnExpression && (object = (returnExpression2 = (UReturnExpression)object).getReturnExpression()) instanceof USimpleNameReferenceExpression && var.equals(UastContextKt.toUElement((PsiElement)(ref = (USimpleNameReferenceExpression)object).resolve()))) {
                ArrayList<OptCheckbox> components = new ArrayList<OptCheckbox>();
                for (int i = 1; i < expressions.size() - 1; ++i) {
                    List arguments;
                    UCallExpression call;
                    USimpleNameReferenceExpression callRef;
                    UQualifiedReferenceExpression qualRef;
                    OptCheckbox component = null;
                    Object object2 = expressions.get(i);
                    if (object2 instanceof UQualifiedReferenceExpression && (object2 = (qualRef = (UQualifiedReferenceExpression)object2).getReceiver()) instanceof USimpleNameReferenceExpression && var.equals(UastContextKt.toUElement((PsiElement)(callRef = (USimpleNameReferenceExpression)object2).resolve())) && (object2 = qualRef.getSelector()) instanceof UCallExpression && (call = (UCallExpression)object2).isMethodNameOneOf(List.of("addCheckbox", "addCheckboxEx")) && (arguments = call.getValueArguments()).size() == 2) {
                        String bindId = MigrateToOptControlInspection.getExpressionText((UExpression)arguments.get(1));
                        String messagePsi = MigrateToOptControlInspection.getExpressionText((UExpression)arguments.get(0));
                        if (bindId != null && messagePsi != null) {
                            component = OptPane.checkbox((String)bindId, (String)messagePsi, (OptRegularComponent[])new OptRegularComponent[0]);
                        }
                    }
                    if (component == null) {
                        return null;
                    }
                    components.add(component);
                }
                return new OptPane(components);
            }
        }
        if (body instanceof UReturnExpression && (expression = (returnExpression = (UReturnExpression)body).getReturnExpression()) instanceof UCallExpression) {
            List arguments;
            UCallExpression ctor = (UCallExpression)expression;
            boolean checkbox = MigrateToOptControlInspection.isConstructor(ctor, "SingleCheckboxOptionsPanel");
            boolean intField = MigrateToOptControlInspection.isConstructor(ctor, "SingleIntegerFieldOptionsPanel");
            if ((checkbox || intField) && ((arguments = ctor.getValueArguments()).size() == 3 || intField && arguments.size() == 4)) {
                String bindId = MigrateToOptControlInspection.getExpressionText((UExpression)arguments.get(2));
                String messagePsi = MigrateToOptControlInspection.getExpressionText((UExpression)arguments.get(0));
                if (bindId != null && messagePsi != null) {
                    return OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{intField ? OptPane.number((String)bindId, (String)messagePsi, (int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE) : OptPane.checkbox((String)bindId, (String)messagePsi, (OptRegularComponent[])new OptRegularComponent[0])});
                }
            }
        }
        return null;
    }

    @Nullable
    @NlsSafe
    private static String getExpressionText(UExpression expression) {
        PsiElement psi = expression.getSourcePsi();
        if (psi == null) {
            return null;
        }
        if (psi.getClass().getSimpleName().equals("KtLiteralStringTemplateEntry")) {
            psi = psi.getParent();
        }
        return psi.getText();
    }

    private static boolean isConstructor(UCallExpression callExpression, String className) {
        if (callExpression.getKind() != UastCallKind.CONSTRUCTOR_CALL) {
            return false;
        }
        PsiMethod target = callExpression.resolve();
        return target != null && target.getName().equals(className);
    }

    static void serialize(@NotNull OptPane pane, @NotNull StringBuilder builder) {
        if (pane == null) {
            MigrateToOptControlInspection.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            MigrateToOptControlInspection.$$$reportNull$$$0(4);
        }
        builder.append("com.intellij.codeInspection.options.OptPane.pane(\n");
        List components = pane.components();
        for (OptComponent component : components) {
            MigrateToOptControlInspection.serialize(component, builder);
            builder.append(",\n");
        }
        builder.setLength(builder.length() - (components.isEmpty() ? 1 : 2));
        builder.append(")");
    }

    static void serialize(OptComponent component, StringBuilder builder) {
        if (component instanceof OptCheckbox) {
            OptCheckbox checkbox = (OptCheckbox)component;
            builder.append("com.intellij.codeInspection.options.OptPane.checkbox(");
            builder.append(checkbox.bindId()).append(", ");
            builder.append(checkbox.label().label());
            for (OptComponent child : checkbox.children()) {
                builder.append(",\n");
                MigrateToOptControlInspection.serialize(child, builder);
            }
            builder.append(")");
        }
        if (component instanceof OptNumber) {
            OptNumber number = (OptNumber)component;
            builder.append("com.intellij.codeInspection.options.OptPane.number(");
            builder.append(number.bindId()).append(", ");
            builder.append(number.splitLabel().label()).append(", ");
            builder.append(LongRangeSet.point((long)number.minValue()).getPresentationText(LongRangeSet.all())).append(", ");
            builder.append(LongRangeSet.point((long)number.maxValue()).getPresentationText(LongRangeSet.all()));
            builder.append(")");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/MigrateToOptControlInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConvertToOptPaneFix
    implements LocalQuickFix {
        @FileModifier.SafeFieldForPreview
        private final OptPane myPane;

        private ConvertToOptPaneFix(@NotNull OptPane pane) {
            if (pane == null) {
                ConvertToOptPaneFix.$$$reportNull$$$0(0);
            }
            this.myPane = pane;
        }

        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspection.migrate.to.opt.control.fix", new Object[0]);
            if (string == null) {
                ConvertToOptPaneFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            UMethod uMethod;
            PsiElement element;
            UMethod method;
            if (project == null) {
                ConvertToOptPaneFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ConvertToOptPaneFix.$$$reportNull$$$0(3);
            }
            if ((method = (UMethod)UastContextKt.findUElementAt((PsiFile)(element = descriptor.getPsiElement()).getContainingFile(), (int)element.getTextOffset(), UMethod.class)) == null) {
                return;
            }
            PsiElement psi = method.getSourcePsi();
            if (psi == null) {
                return;
            }
            Language language = psi.getLanguage();
            UastCodeGenerationPlugin plugin = UastCodeGenerationPlugin.byLanguage((Language)language);
            if (plugin == null) {
                return;
            }
            boolean kotlin = language != JavaLanguage.INSTANCE;
            StringBuilder builder = new StringBuilder();
            if (kotlin) {
                builder.append("override fun getOptionsPane() = ");
            } else {
                builder.append("@Override public @org.jetbrains.annotations.NotNull com.intellij.codeInspection.options.OptPane getOptionsPane() {\nreturn ");
            }
            MigrateToOptControlInspection.serialize(this.myPane, builder);
            if (!kotlin) {
                builder.append(";\n}");
            }
            if ((uMethod = plugin.getElementFactory(project).createMethodFromText(builder.toString(), psi)) == null) {
                return;
            }
            PsiElement newMethod = uMethod.getSourcePsi();
            if (newMethod == null) {
                return;
            }
            this.shortenReferences(plugin, psi.replace(newMethod));
        }

        private void shortenReferences(@NotNull UastCodeGenerationPlugin plugin, @NotNull PsiElement element) {
            if (plugin == null) {
                ConvertToOptPaneFix.$$$reportNull$$$0(4);
            }
            if (element == null) {
                ConvertToOptPaneFix.$$$reportNull$$$0(5);
            }
            var refProcessor = new PsiRecursiveElementWalkingVisitor(){
                final List<UReferenceExpression> list = new ArrayList<UReferenceExpression>();

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitElement(element);
                    ContainerUtil.addIfNotNull(this.list, (Object)((UReferenceExpression)UastContextKt.toUElement((PsiElement)element, UReferenceExpression.class)));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/inspections/MigrateToOptControlInspection$ConvertToOptPaneFix$1", "visitElement"));
                }
            };
            element.accept((PsiElementVisitor)refProcessor);
            for (UReferenceExpression expression : refProcessor.list) {
                if (!expression.isPsiValid()) continue;
                plugin.shortenReference(expression);
            }
            var staticImportProcessor = new PsiRecursiveElementWalkingVisitor(){
                final List<UQualifiedReferenceExpression> list = new ArrayList<UQualifiedReferenceExpression>();

                public void visitElement(@NotNull PsiElement element) {
                    PsiClass cls;
                    UReferenceExpression qualifier;
                    PsiElement target;
                    UExpression uExpression;
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    super.visitElement(element);
                    UQualifiedReferenceExpression expression = (UQualifiedReferenceExpression)UastContextKt.toUElement((PsiElement)element, UQualifiedReferenceExpression.class);
                    if (expression != null && (uExpression = expression.getReceiver()) instanceof UReferenceExpression && (target = (qualifier = (UReferenceExpression)uExpression).resolve()) instanceof PsiClass && MigrateToOptControlInspection.OPT_PANE.equals((cls = (PsiClass)target).getQualifiedName())) {
                        this.list.add(expression);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/inspections/MigrateToOptControlInspection$ConvertToOptPaneFix$2", "visitElement"));
                }
            };
            element.accept((PsiElementVisitor)staticImportProcessor);
            for (UQualifiedReferenceExpression expression : staticImportProcessor.list) {
                if (!expression.isPsiValid()) continue;
                plugin.importMemberOnDemand(expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pane";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/MigrateToOptControlInspection$ConvertToOptPaneFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "plugin";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/MigrateToOptControlInspection$ConvertToOptPaneFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "shortenReferences";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

