/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.DefaultJvmElementVisitor;
import com.intellij.lang.jvm.JvmAnnotation;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmElementVisitor;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequestKt;
import com.intellij.lang.jvm.actions.ChangeParametersRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MethodRequestsKt;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;
import org.jetbrains.idea.devkit.inspections.LevelType;
import org.jetbrains.idea.devkit.inspections.ServiceUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/MismatchedLightServiceLevelAndCtorInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitJvmInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/lang/jvm/JvmElementVisitor;", "", "project", "Lcom/intellij/openapi/project/Project;", "sink", "Lcom/intellij/lang/jvm/inspection/JvmLocalInspection$HighlightSink;", "isOnTheFly", "intellij.devkit.core"})
public final class MismatchedLightServiceLevelAndCtorInspection
extends DevKitJvmInspection {
    @NotNull
    protected JvmElementVisitor<Boolean> buildVisitor(@NotNull Project project, @NotNull JvmLocalInspection.HighlightSink sink, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        return (JvmElementVisitor)new DefaultJvmElementVisitor<Boolean>(sink){
            final /* synthetic */ JvmLocalInspection.HighlightSink $sink;
            {
                this.$sink = $sink;
            }

            public Boolean visitMethod(JvmMethod method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                if (!method.isConstructor()) {
                    return true;
                }
                JvmClass jvmClass = method.getContainingClass();
                if (jvmClass == null) {
                    return true;
                }
                JvmClass clazz = jvmClass;
                if (clazz.getClassKind() != JvmClassKind.CLASS || clazz.hasModifier(JvmModifier.ABSTRACT) || this.isLocalOrAnonymous(clazz)) {
                    return true;
                }
                JvmAnnotation jvmAnnotation = clazz.getAnnotation(Service.class.getCanonicalName());
                if (jvmAnnotation == null) {
                    return true;
                }
                JvmAnnotation annotation = jvmAnnotation;
                PsiElement psiElement = method.getSourceElement();
                if (psiElement == null) {
                    return true;
                }
                PsiElement sourceElement = psiElement;
                PsiFile psiFile = sourceElement.getContainingFile();
                if (psiFile == null) {
                    return true;
                }
                PsiFile file = psiFile;
                Language language = sourceElement.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                LevelType levelType = ServiceUtil.getLevelType(annotation, language);
                if (!levelType.isProject() && this.isProjectLevelExclusiveCtor(method)) {
                    PsiAnnotation psiAnnotation = annotation instanceof PsiAnnotation ? (PsiAnnotation)annotation : null;
                    if (psiAnnotation == null || (psiAnnotation = psiAnnotation.getNameReferenceElement()) == null) {
                        return true;
                    }
                    PsiAnnotation elementToReport = psiAnnotation;
                    this.registerProblemProjectLevelRequired(annotation, (PsiJavaCodeReferenceElement)elementToReport, file);
                }
                if (levelType.isApp() && !this.isAppLevelServiceCtor(method) && !this.hasAppLevelServiceCtor(clazz)) {
                    this.registerProblemApplicationLevelRequired(method, file);
                }
                return true;
            }

            private final boolean isLocalOrAnonymous(JvmClass $this$isLocalOrAnonymous) {
                return $this$isLocalOrAnonymous.getQualifiedName() == null;
            }

            /*
             * WARNING - void declaration
             */
            private final boolean hasAppLevelServiceCtor(JvmClass clazz) {
                boolean bl;
                block4: {
                    void $this$filterTo$iv$iv;
                    JvmMethod[] jvmMethodArray = clazz.getMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)jvmMethodArray, (String)"getMethods(...)");
                    Object[] $this$filter$iv = jvmMethodArray;
                    boolean $i$f$filter = false;
                    Object[] objectArray = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (void element$iv$iv : $this$filterTo$iv$iv) {
                        JvmMethod it = (JvmMethod)element$iv$iv;
                        boolean bl2 = false;
                        if (!it.isConstructor()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$any$iv = (List)destination$iv$iv;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (E element$iv : $this$any$iv) {
                            JvmMethod it = (JvmMethod)element$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!this.isAppLevelServiceCtor(it)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean isAppLevelServiceCtor(JvmMethod constructor) {
                boolean bl = constructor.isConstructor();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                if (!constructor.hasParameters()) return true;
                JvmParameter[] jvmParameterArray = constructor.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"getParameters(...)");
                JvmParameter jvmParameter = (JvmParameter)ArraysKt.singleOrNull((Object[])jvmParameterArray);
                if (jvmParameter == null) return false;
                boolean bl2 = this.hasType(jvmParameter, CoroutineScope.class);
                if (!bl2) return false;
                return true;
            }

            private final boolean isProjectLevelExclusiveCtor(JvmMethod constructor) {
                boolean bl = constructor.isConstructor();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                JvmParameter[] jvmParameterArray = constructor.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"getParameters(...)");
                JvmParameter[] parameters = jvmParameterArray;
                return switch (parameters.length) {
                    case 1 -> {
                        JvmParameter v1 = parameters[0];
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"get(...)");
                        yield this.hasType(v1, Project.class);
                    }
                    case 2 -> {
                        JvmParameter v3 = parameters[0];
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"get(...)");
                        if (this.hasType(v3, Project.class)) {
                            JvmParameter v4 = parameters[1];
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"get(...)");
                            if (this.hasType(v4, CoroutineScope.class)) {
                                yield true;
                            }
                        }
                        yield false;
                    }
                    default -> false;
                };
            }

            private final boolean hasType(JvmParameter $this$hasType, Class<?> clazz) {
                JvmType jvmType = $this$hasType.getType();
                PsiType psiType = jvmType instanceof PsiType ? (PsiType)jvmType : null;
                return Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)clazz.getCanonicalName());
            }

            private final void registerProblemProjectLevelRequired(JvmAnnotation annotation, PsiJavaCodeReferenceElement elementToReport, PsiFile file) {
                String projectLevelFqn = ServiceUtil.getProjectLevelFQN();
                AnnotationAttributeRequest request = AnnotationAttributeValueRequestKt.constantAttribute((String)"value", (String)projectLevelFqn);
                String text = DevKitBundle.message("inspection.mismatched.light.service.level.and.ctor.specify.project.level.fix", new Object[0]);
                Intrinsics.checkNotNull((Object)text);
                List actions = JvmElementActionFactories.createChangeAnnotationAttributeActions((JvmAnnotation)annotation, (int)0, (AnnotationAttributeRequest)request, (String)text, (String)text);
                Collection $this$toTypedArray$iv = actions;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] localQuickFixArray = IntentionWrapper.wrapToQuickFixes((IntentionAction[])thisCollection$iv.toArray(new IntentionAction[0]), (PsiFile)file);
                Intrinsics.checkNotNullExpressionValue((Object)localQuickFixArray, (String)"wrapToQuickFixes(...)");
                LocalQuickFix[] fixes = localQuickFixArray;
                JvmLocalInspection.HighlightSink highlightSink = this.$sink;
                Intrinsics.checkNotNull((Object)highlightSink, (String)"null cannot be cast to non-null type com.intellij.lang.jvm.inspection.JvmLocalInspection.HighlightSinkImpl");
                ProblemsHolder problemsHolder = ((JvmLocalInspection.HighlightSinkImpl)highlightSink).getHolder();
                Intrinsics.checkNotNullExpressionValue((Object)problemsHolder, (String)"getHolder(...)");
                ProblemsHolder holder = problemsHolder;
                String message = DevKitBundle.message("inspection.mismatched.light.service.level.and.ctor.project.level.required", new Object[0]);
                holder.registerProblem((PsiElement)elementToReport, message, Arrays.copyOf(fixes, fixes.length));
            }

            private final void registerProblemApplicationLevelRequired(JvmMethod method, PsiFile file) {
                List actions = JvmElementActionFactories.createChangeParametersActions((JvmMethod)method, (ChangeParametersRequest)MethodRequestsKt.setMethodParametersRequest((Iterable)CollectionsKt.emptyList()));
                Collection $this$toTypedArray$iv = actions;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] localQuickFixArray = IntentionWrapper.wrapToQuickFixes((IntentionAction[])thisCollection$iv.toArray(new IntentionAction[0]), (PsiFile)file);
                Intrinsics.checkNotNullExpressionValue((Object)localQuickFixArray, (String)"wrapToQuickFixes(...)");
                LocalQuickFix[] fixes = localQuickFixArray;
                String message = DevKitBundle.message("inspection.mismatched.light.service.level.and.ctor.app.level.ctor.required", new Object[0]);
                this.$sink.highlight(message, Arrays.copyOf(fixes, fixes.length));
            }
        };
    }
}

