/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.lang.jvm.util.JvmInheritanceUtil;
import com.intellij.lang.jvm.util.JvmUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThreadAware;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;

@VisibleForTesting
@ApiStatus.Internal
public final class MissingActionUpdateThread
extends DevKitJvmInspection.ForClass {
    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            MissingActionUpdateThread.$$$reportNull$$$0(0);
        }
        return super.isAllowed(holder) && DevKitInspectionUtil.isClassAvailable(holder, ActionUpdateThreadAware.class.getName());
    }

    @Override
    protected void checkClass(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull JvmLocalInspection.HighlightSink sink) {
        String className;
        if (project == null) {
            MissingActionUpdateThread.$$$reportNull$$$0(1);
        }
        if (psiClass == null) {
            MissingActionUpdateThread.$$$reportNull$$$0(2);
        }
        if (sink == null) {
            MissingActionUpdateThread.$$$reportNull$$$0(3);
        }
        if (psiClass.getClassKind() != JvmClassKind.CLASS || psiClass.hasModifier(JvmModifier.ABSTRACT) || !JvmInheritanceUtil.isInheritor((JvmClass)psiClass, (String)ActionUpdateThreadAware.class.getName())) {
            return;
        }
        boolean isAnAction = false;
        boolean hasUpdateMethod = false;
        JBIterable superInterfaces = JBIterable.empty();
        PsiClass c = psiClass;
        while (c != null && !"java.lang.Object".equals(className = c.getQualifiedName()) && !(isAnAction = AnAction.class.getName().equals(className))) {
            for (JvmMethod method : c.getMethods()) {
                JvmClass pc;
                String name = method.getName();
                if ("getActionUpdateThread".equals(name) && method.getParameters().length == 0) {
                    return;
                }
                if (!"update".equals(name) || hasUpdateMethod) continue;
                JvmParameter[] parameters = method.getParameters();
                JvmType pt = parameters.length == 1 ? parameters[0].getType() : null;
                JvmClass jvmClass = pc = pt instanceof JvmReferenceType ? JvmUtil.resolveClass((JvmReferenceType)((JvmReferenceType)pt)) : null;
                if (pc == null || !AnActionEvent.class.getName().equals(pc.getQualifiedName())) continue;
                hasUpdateMethod = true;
            }
            superInterfaces = superInterfaces.append((Iterable)JBIterable.of((Object[])c.getInterfaceTypes()));
            c = JvmUtil.resolveClass((JvmReferenceType)c.getSuperClassType());
        }
        if (!isAnAction) {
            JBTreeTraverser traverser = JBTreeTraverser.from(o -> JBIterable.of((Object)o.getSuperClassType()).filterMap(JvmUtil::resolveClass));
            for (JvmClass c2 : (JBTreeTraverser)((JBTreeTraverser)traverser.unique()).withRoots((Iterable)superInterfaces.filterMap(JvmUtil::resolveClass))) {
                if (ActionUpdateThreadAware.class.getName().equals(c2.getQualifiedName())) continue;
                for (JvmMethod method : c2.getMethods()) {
                    if (!"getActionUpdateThread".equals(method.getName()) || method.getParameters().length != 0) continue;
                    return;
                }
            }
        }
        if (!isAnAction || hasUpdateMethod) {
            sink.highlight(DevKitBundle.message("inspections.action.update.thread.message", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/MissingActionUpdateThread";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

