/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.client.ClientKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.ExtensionUtil;
import org.jetbrains.idea.devkit.inspections.NonDefaultConstructorInspectionKt;
import org.jetbrains.idea.devkit.inspections.ServiceUtil;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastFacade;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/devkit/inspections/NonDefaultConstructorInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "<init>", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "aClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getArea", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint$Area;", "extensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nNonDefaultConstructorInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonDefaultConstructorInspection.kt\norg/jetbrains/idea/devkit/inspections/NonDefaultConstructorInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 UastLanguagePlugin.kt\norg/jetbrains/uast/UastLanguagePluginKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,349:1\n1#2:350\n171#3,2:351\n37#4,2:353\n*S KotlinDebug\n*F\n+ 1 NonDefaultConstructorInspection.kt\norg/jetbrains/idea/devkit/inspections/NonDefaultConstructorInspection\n*L\n112#1:351,2\n131#1:353,2\n*E\n"})
public final class NonDefaultConstructorInspection
extends DevKitUastInspectionBase {
    public NonDefaultConstructorInspection() {
        Class[] classArray = new Class[]{UClass.class};
        super(classArray);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        block45: {
            block44: {
                Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                javaPsi = aClass.getJavaPsi();
                if (Intrinsics.areEqual((Object)javaPsi.getLanguage().getID(), (Object)"Groovy") || !ExtensionUtil.isExtensionPointImplementationCandidate(javaPsi) || javaPsi.hasModifierProperty("private")) {
                    return null;
                }
                v0 = javaPsi.getConstructors();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getConstructors(...)");
                constructors = v0;
                if (constructors.length == 0) {
                    return null;
                }
                area = null;
                isService = false;
                serviceClientKind = null;
                isServiceAnnotation = false;
                extensionPoint = null;
                if (!ServiceUtil.isLightService(javaPsi)) break block44;
                area = null;
                isService = true;
                isServiceAnnotation = true;
                break block45;
            }
            if (!NonDefaultConstructorInspectionKt.access$isExtensionBean(aClass)) {
                v1 = manager.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
                v2 = NonDefaultConstructorInspectionKt.access$findExtensionPoint(aClass, v1);
                if (v2 == null) {
                    return null;
                }
                extensionPoint = v2;
            } else if (Intrinsics.areEqual((Object)javaPsi.getName(), (Object)"VcsConfigurableEP")) {
                return null;
            }
            area = this.getArea((ExtensionPoint)extensionPoint);
            v3 = extensionPoint;
            isService = Intrinsics.areEqual((Object)(v3 != null && (v3 = v3.getBeanClass()) != null ? v3.getStringValue() : null), (Object)"com.intellij.openapi.components.ServiceDescriptor");
            if (!isService) break block45;
            for (ExtensionCandidate candidate : ExtensionLocatorKt.locateExtensionsByPsiClass(javaPsi)) {
                if ((XmlTag)candidate.pointer.getElement() == null || (v4 = extensionTag.getAttribute("client")) == null || (v4 = v4.getValue()) == null) continue;
                var17_22 = clientName = v4;
                v5 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"US");
                Intrinsics.checkNotNullExpressionValue((Object)var17_22.toLowerCase(v5), (String)"toLowerCase(...)");
                tmp = -1;
                switch (var16_21.hashCode()) {
                    case 106164915: {
                        if (var16_21.equals("owner")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 96673: {
                        if (var16_21.equals("all")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 637428636: {
                        if (var16_21.equals("controller")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case 98708952: {
                        if (var16_21.equals("guest")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case -934610874: {
                        if (var16_21.equals("remote")) {
                            tmp = 5;
                        }
                        break;
                    }
                    case 103145323: {
                        if (var16_21.equals("local")) {
                            tmp = 6;
                        }
                        break;
                    }
                    case -1242788334: {
                        if (var16_21.equals("frontend")) {
                            tmp = 7;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 6: {
                        v6 = ClientKind.LOCAL;
                        break;
                    }
                    case 3: {
                        v6 = ClientKind.CONTROLLER;
                        break;
                    }
                    case 4: {
                        v6 = ClientKind.GUEST;
                        break;
                    }
                    case 1: {
                        v6 = ClientKind.OWNER;
                        break;
                    }
                    case 5: {
                        v6 = ClientKind.REMOTE;
                        break;
                    }
                    case 7: {
                        v6 = ClientKind.FRONTEND;
                        break;
                    }
                    case 2: {
                        v6 = ClientKind.ALL;
                        break;
                    }
                    default: {
                        v6 = kind = null;
                    }
                }
                if (serviceClientKind == null) {
                    serviceClientKind = kind;
                    continue;
                }
                if (serviceClientKind == kind) continue;
                serviceClientKind = ClientKind.ALL;
            }
        }
        isAppLevelExtensionPoint = area == null || area == ExtensionPoint.Area.IDEA_APPLICATION;
        errors = null;
        for (PsiMethod method : constructors) {
            block48: {
                block47: {
                    v7 = method.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getParameterList(...)");
                    if (NonDefaultConstructorInspectionKt.access$isAllowedParameters(v7, extensionPoint, isAppLevelExtensionPoint, serviceClientKind, isServiceAnnotation)) {
                        return null;
                    }
                    if (errors == null) {
                        errors = (List)new SmartList();
                    }
                    if (!method.isPhysical()) break block47;
                    v8 = method.getIdentifyingElement();
                    v9 = v8;
                    Intrinsics.checkNotNull((Object)v8);
                    break block48;
                }
                v9 = aClass.getSourcePsi();
                if (v9 == null) continue;
                it = v9;
                $i$a$-let-NonDefaultConstructorInspection$checkClass$anchorElement$1 = false;
                v10 = UastFacade.INSTANCE.findPlugin(it);
                if (v10 == null) ** GOTO lbl-1000
                $this$convertOpt$iv = v10;
                $i$f$convertOpt = false;
                if ((PsiElement)method == null) {
                    v11 = null;
                } else {
                    v12 = $this$convertOpt$iv.convertElement((PsiElement)method, (UElement)aClass, UMethod.class);
                    if (!(v12 instanceof UMethod)) {
                        v12 = null;
                    }
                    v11 = (UElement)((UMethod)v12);
                }
                if ((v10 = (UMethod)v11) != null) {
                    v13 = v10.getSourcePsi();
                } else lbl-1000:
                // 2 sources

                {
                    v13 = null;
                }
                v9 = v13;
                if (v13 == null) {
                    continue;
                }
            }
            anchorElement = v9;
            v14 = kind = isService != false ? DevKitBundle.message("inspections.non.default.warning.type.service", new Object[0]) : DevKitBundle.message("inspections.non.default.warning.type.extension", new Object[0]);
            suffix = area == null ? DevKitBundle.message("inspections.non.default.warning.suffix.project.or.module", new Object[0]) : (isAppLevelExtensionPoint != false ? "" : (area == ExtensionPoint.Area.IDEA_PROJECT ? DevKitBundle.message("inspections.non.default.warning.suffix.project", new Object[0]) : DevKitBundle.message("inspections.non.default.warning.suffix.module", new Object[0])));
            var19_24 = new Object[]{kind, suffix};
            v15 = manager.createProblemDescriptor(anchorElement, DevKitBundle.message("inspections.non.default.warning.and.suffix.message", var19_24), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]);
            Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"createProblemDescriptor(...)");
            errors.add(v15);
        }
        v16 = errors;
        if (v16 != null) {
            $this$toTypedArray$iv = v16;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            v17 = thisCollection$iv.toArray(new ProblemDescriptor[0]);
        } else {
            v17 = null;
        }
        return v17;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ExtensionPoint.Area getArea(ExtensionPoint extensionPoint) {
        ExtensionPoint extensionPoint2 = extensionPoint;
        if (extensionPoint2 == null) {
            return ExtensionPoint.Area.IDEA_APPLICATION;
        }
        String areaName = extensionPoint2.getArea().getStringValue();
        String string = areaName;
        if (Intrinsics.areEqual((Object)string, (Object)"IDEA_PROJECT")) {
            return ExtensionPoint.Area.IDEA_PROJECT;
        }
        if (Intrinsics.areEqual((Object)string, (Object)"IDEA_MODULE")) {
            return ExtensionPoint.Area.IDEA_MODULE;
        }
        String string2 = (String)extensionPoint.getName().getValue();
        if (string2 == null) return ExtensionPoint.Area.IDEA_APPLICATION;
        switch (string2.hashCode()) {
            case 350807721: {
                if (string2.equals("moduleService")) return ExtensionPoint.Area.IDEA_MODULE;
                return ExtensionPoint.Area.IDEA_APPLICATION;
            }
            case -1492183716: {
                if (!string2.equals("projectService")) return ExtensionPoint.Area.IDEA_APPLICATION;
                return ExtensionPoint.Area.IDEA_PROJECT;
            }
        }
        return ExtensionPoint.Area.IDEA_APPLICATION;
    }
}

