/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.AddDomElementQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ApplicationComponents;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.Group;
import org.jetbrains.idea.devkit.dom.ModuleComponents;
import org.jetbrains.idea.devkit.dom.ProjectComponents;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;

@VisibleForTesting
@ApiStatus.Internal
public final class PluginXmlDynamicPluginInspection
extends DevKitPluginXmlInspectionBase {
    public boolean highlightNonDynamicEPUsages = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"highlightNonDynamicEPUsages", (String)DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.option.highlight.usages.ep", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PluginXmlDynamicPluginInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        if (element == null) {
            PluginXmlDynamicPluginInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PluginXmlDynamicPluginInspection.$$$reportNull$$$0(2);
        }
        if (helper == null) {
            PluginXmlDynamicPluginInspection.$$$reportNull$$$0(3);
        }
        if (!this.isAllowed(holder)) {
            return;
        }
        if (element instanceof ApplicationComponents || element instanceof ProjectComponents || element instanceof ModuleComponents) {
            PluginXmlDynamicPluginInspection.highlightComponents(holder, element);
        } else if (element instanceof ExtensionPoint) {
            PluginXmlDynamicPluginInspection.highlightExtensionPoint(holder, (ExtensionPoint)element);
        } else if (element instanceof Group) {
            PluginXmlDynamicPluginInspection.highlightGroup(holder, (Group)element);
        } else if (this.highlightNonDynamicEPUsages && element instanceof Extension) {
            PluginXmlDynamicPluginInspection.highlightExtension(holder, (Extension)element);
        }
    }

    private static void highlightComponents(DomElementAnnotationHolder holder, DomElement component) {
        holder.createProblem(component, new HtmlBuilder().append(DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.component.usage", new Object[0])).nbsp().append((HtmlChunk)HtmlChunk.link((String)"https://plugins.jetbrains.com/docs/intellij/plugin-components.html?from=DevkitPluginXmlDynamicInspection", (String)DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.component.usage.docs.link.title", new Object[0]))).wrapWithHtmlBody().toString(), new LocalQuickFix[0]);
    }

    private static void highlightExtensionPoint(DomElementAnnotationHolder holder, ExtensionPoint extensionPoint) {
        if (!DomUtil.hasXml(extensionPoint.getDynamic())) {
            holder.createProblem((DomElement)extensionPoint, DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.extension.point", extensionPoint.getEffectiveQualifiedName()), new LocalQuickFix[0]);
        } else if (Boolean.FALSE == extensionPoint.getDynamic().getValue()) {
            holder.createProblem((DomElement)extensionPoint, DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.explicit.non.dynamic.extension.point", extensionPoint.getEffectiveQualifiedName()), new LocalQuickFix[0]);
        }
    }

    private static void highlightGroup(DomElementAnnotationHolder holder, Group group) {
        if (!DomUtil.hasXml((DomElement)group.getId())) {
            holder.createProblem((DomElement)group, DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.id.required.for.group", new Object[0]), new LocalQuickFix[]{new AddDomElementQuickFix((DomElement)group.getId())});
        }
    }

    private static void highlightExtension(DomElementAnnotationHolder holder, Extension extension) {
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint != null && Boolean.TRUE != extensionPoint.getDynamic().getValue()) {
            holder.createProblem((DomElement)extension, DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.usage.of.non.dynamic.extension.point", extensionPoint.getEffectiveQualifiedName()), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/PluginXmlDynamicPluginInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlDynamicPluginInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkDomElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

