/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/devkit/inspections/PluginXmlPluginLogoInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitPluginXmlInspectionBase;", "<init>", "()V", "pluginIconFileName", "", "checkDomElement", "", "element", "Lcom/intellij/util/xml/DomElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "helper", "Lcom/intellij/util/xml/highlighting/DomHighlightingHelper;", "intellij.devkit.core"})
public final class PluginXmlPluginLogoInspection
extends DevKitPluginXmlInspectionBase {
    @NonNls
    @NotNull
    private final String pluginIconFileName;

    public PluginXmlPluginLogoInspection() {
        this.pluginIconFileName = "pluginIcon.svg";
    }

    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        if (!(element instanceof IdeaPlugin)) {
            return;
        }
        if (!this.isAllowed(holder)) {
            return;
        }
        if (!((IdeaPlugin)element).hasRealPluginId()) {
            return;
        }
        Module module = ((IdeaPlugin)element).getModule();
        if (module == null) {
            return;
        }
        Module module2 = module;
        if (!DevKitPluginXmlInspectionBase.isUnderProductionSources(element, module2)) {
            return;
        }
        if (Intrinsics.areEqual((Object)true, (Object)((IdeaPlugin)element).getImplementationDetail().getValue())) {
            return;
        }
        Collection collection = FilenameIndex.getVirtualFilesByName((String)this.pluginIconFileName, (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)module2));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
        Collection pluginIconFiles = collection;
        if (pluginIconFiles.isEmpty()) {
            Object[] objectArray = new Object[]{this.pluginIconFileName};
            holder.createProblem(element, DevKitBundle.message("inspections.plugin.xml.no.plugin.icon.svg.file", objectArray), new LocalQuickFix[0]);
        }
    }
}

