/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.options.JavaClassValidator;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.psi.PsiClass;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.inspections.ComponentModuleRegistrationChecker;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014R&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/idea/devkit/inspections/PluginXmlRegistrationCheckInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitPluginXmlInspectionBase;", "<init>", "()V", "ignoreClasses", "", "", "getIgnoreClasses$annotations", "getIgnoreClasses", "()Ljava/util/List;", "setIgnoreClasses", "(Ljava/util/List;)V", "pluginsModules", "Lorg/jetbrains/idea/devkit/inspections/PluginXmlRegistrationCheckInspection$PluginModuleSet;", "getPluginsModules", "setPluginsModules", "myPluginModuleSetByModuleName", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "", "getOptionController", "Lcom/intellij/codeInspection/options/OptionController;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "readSettings", "", "node", "Lorg/jdom/Element;", "checkDomElement", "element", "Lcom/intellij/util/xml/DomElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "helper", "Lcom/intellij/util/xml/highlighting/DomHighlightingHelper;", "PluginModuleSet", "intellij.devkit.core"})
public final class PluginXmlRegistrationCheckInspection
extends DevKitPluginXmlInspectionBase {
    @NotNull
    private List<String> ignoreClasses = (List)new ExternalizableStringSet(new String[0]);
    @XCollection
    @NotNull
    private List<PluginModuleSet> pluginsModules = new ArrayList();
    @NotNull
    private final SynchronizedClearableLazy<Map<String, PluginModuleSet>> myPluginModuleSetByModuleName = new SynchronizedClearableLazy(() -> PluginXmlRegistrationCheckInspection.myPluginModuleSetByModuleName$lambda$0(this));

    @NotNull
    public final List<String> getIgnoreClasses() {
        return this.ignoreClasses;
    }

    public final void setIgnoreClasses(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.ignoreClasses = list;
    }

    public static /* synthetic */ void getIgnoreClasses$annotations() {
    }

    @NotNull
    public final List<PluginModuleSet> getPluginsModules() {
        return this.pluginsModules;
    }

    public final void setPluginsModules(@NotNull List<PluginModuleSet> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.pluginsModules = list;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValue("pluginsModules", () -> PluginXmlRegistrationCheckInspection.getOptionController$lambda$3(this), arg_0 -> PluginXmlRegistrationCheckInspection.getOptionController$lambda$7(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)optionController, (String)"onValue(...)");
        return optionController;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.stringList((String)"ignoreClasses", (String)DevKitBundle.message("inspections.plugin.xml.ignore.classes.title", new Object[0]), (StringValidator)((StringValidator)new JavaClassValidator().withTitle(DevKitBundle.message("inspections.plugin.xml.add.ignored.class.title", new Object[0])))), OptPane.stringList((String)"pluginsModules", (String)DevKitBundle.message("inspections.plugin.xml.plugin.modules.label", new Object[0])).description(DevKitBundle.message("inspections.plugin.xml.plugin.modules.description", new Object[0]))};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    public void readSettings(@NotNull Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super.readSettings(node);
        this.myPluginModuleSetByModuleName.drop();
    }

    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        if (!(element instanceof Extension || element instanceof ExtensionPoint || element instanceof Action || element instanceof Component)) {
            return;
        }
        if (!this.isAllowed(holder)) {
            return;
        }
        ComponentModuleRegistrationChecker registrationChecker = new ComponentModuleRegistrationChecker(this.myPluginModuleSetByModuleName, this.ignoreClasses, holder);
        if (!registrationChecker.isIdeaPlatformModule(element.getModule())) {
            return;
        }
        DomElement domElement = element;
        if (domElement instanceof Extension) {
            registrationChecker.checkProperXmlFileForExtension((Extension)element);
        } else if (domElement instanceof ExtensionPoint) {
            registrationChecker.checkProperModule((ExtensionPoint)element);
        } else if (domElement instanceof Action) {
            registrationChecker.checkProperXmlFileForClass(element, (PsiClass)((Action)element).getClazz().getValue());
        } else if (domElement instanceof Component) {
            registrationChecker.checkProperXmlFileForClass(element, (PsiClass)((Component)element).getImplementationClass().getValue());
        }
    }

    private static final Map myPluginModuleSetByModuleName$lambda$0(PluginXmlRegistrationCheckInspection this$0) {
        Map result = new HashMap();
        for (PluginModuleSet modulesSet : this$0.pluginsModules) {
            Iterator iterator;
            Intrinsics.checkNotNullExpressionValue(modulesSet.getModules().iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String module = (String)e;
                result.put(module, modulesSet);
            }
        }
        return result;
    }

    private static final String getOptionController$lambda$3$lambda$1(PluginModuleSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        return String.join((CharSequence)",", (Iterable<? extends CharSequence>)set.getModules());
    }

    private static final String getOptionController$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final List getOptionController$lambda$3(PluginXmlRegistrationCheckInspection this$0) {
        return StreamEx.of((Collection)this$0.pluginsModules).map(arg_0 -> PluginXmlRegistrationCheckInspection.getOptionController$lambda$3$lambda$2(PluginXmlRegistrationCheckInspection::getOptionController$lambda$3$lambda$1, arg_0)).toMutableList();
    }

    private static final LinkedHashSet getOptionController$lambda$7$lambda$5$lambda$4() {
        return new LinkedHashSet();
    }

    private static final PluginModuleSet getOptionController$lambda$7$lambda$5(String line) {
        PluginModuleSet set = new PluginModuleSet();
        set.setModules((LinkedHashSet)StreamEx.split((CharSequence)line, (String)",").toCollection(PluginXmlRegistrationCheckInspection::getOptionController$lambda$7$lambda$5$lambda$4));
        return set;
    }

    private static final PluginModuleSet getOptionController$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        return (PluginModuleSet)$tmp0.invoke(p0);
    }

    private static final void getOptionController$lambda$7(PluginXmlRegistrationCheckInspection this$0, List newList) {
        this$0.pluginsModules.clear();
        StreamEx.of((Collection)newList).map(arg_0 -> PluginXmlRegistrationCheckInspection.getOptionController$lambda$7$lambda$6(PluginXmlRegistrationCheckInspection::getOptionController$lambda$7$lambda$5, arg_0)).into((Collection)this$0.pluginsModules);
        this$0.myPluginModuleSetByModuleName.drop();
    }

    @Tag(value="modules-set")
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R.\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/PluginXmlRegistrationCheckInspection$PluginModuleSet;", "", "<init>", "()V", "modules", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "getModules", "()Ljava/util/LinkedHashSet;", "setModules", "(Ljava/util/LinkedHashSet;)V", "intellij.devkit.core"})
    public static final class PluginModuleSet {
        @XCollection(elementName="module", valueAttributeName="name")
        @Property(surroundWithTag=false)
        @NotNull
        private LinkedHashSet<String> modules = new LinkedHashSet();

        @NotNull
        public final LinkedHashSet<String> getModules() {
            return this.modules;
        }

        public final void setModules(@NotNull LinkedHashSet<String> linkedHashSet) {
            Intrinsics.checkNotNullParameter(linkedHashSet, (String)"<set-?>");
            this.modules = linkedHashSet;
        }
    }
}

