/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.util.JvmInheritanceUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.PotentialDeadlockInServiceInitializationInspectionKt;
import org.jetbrains.idea.devkit.inspections.ServiceUtil;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002./B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u000e\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0002J \u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d*\u00020\u0012H\u0002J\"\u0010\u001e\u001a\u00020\t*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001f\u0010!\u001a\t\u0018\u00010\"\u00a2\u0006\u0002\b#2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u0013H\u0002J \u0010&\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010'\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0010\u0010(\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0002J \u0010)\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u00060"}, d2={"Lorg/jetbrains/idea/devkit/inspections/PotentialDeadlockInServiceInitializationInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "<init>", "()V", "buildInternalVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getForbiddenMethodCallType", "Lorg/jetbrains/idea/devkit/inspections/PotentialDeadlockInServiceInitializationInspection$CallType;", "Lorg/jetbrains/uast/UCallExpression;", "isCalledDuringServiceInitialization", "forbiddenCall", "callContextHolder", "Lorg/jetbrains/idea/devkit/inspections/PotentialDeadlockInServiceInitializationInspection$CallContextHolder;", "getContainingNonCompanionObjectClass", "Lorg/jetbrains/uast/UClass;", "Lorg/jetbrains/uast/UElement;", "isCalledDuringInit", "isCalledInAnonymousClassOrLambda", "forbiddenActionCall", "isCalledInConstructor", "isCalledInInitBlock", "isCalledInFieldAssignment", "isInMethodCalledDuringInit", "serviceClass", "getInitializationElements", "", "isCalledInAnyOf", "Lorg/jetbrains/uast/UMethod;", "potentialCallers", "getContextText", "", "Lorg/jetbrains/annotations/Nls;", "calledMethod", "caller", "isCalledDuringPersistentStateComponentInit", "isPersistentStateComponent", "isCalledDuringPersistentStateComponentInitMethods", "isInMethodCalledDuringPersistentStateComponentInit", "registerProblem", "", "uCallExpression", "actionType", "CallType", "CallContextHolder", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nPotentialDeadlockInServiceInitializationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PotentialDeadlockInServiceInitializationInspection.kt\norg/jetbrains/idea/devkit/inspections/PotentialDeadlockInServiceInitializationInspection\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,223:1\n18#2:224\n18#2:225\n18#2:226\n18#2:227\n18#2:228\n1310#3,2:229\n3829#3:231\n4344#3,2:232\n3829#3:234\n4344#3,2:235\n*S KotlinDebug\n*F\n+ 1 PotentialDeadlockInServiceInitializationInspection.kt\norg/jetbrains/idea/devkit/inspections/PotentialDeadlockInServiceInitializationInspection\n*L\n84#1:224\n96#1:225\n97#1:226\n105#1:227\n109#1:228\n114#1:229,2\n122#1:231\n122#1:232,2\n195#1:234\n195#1:235,2\n*E\n"})
public final class PotentialDeadlockInServiceInitializationInspection
extends DevKitUastInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UCallExpression.class};
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this, holder){
            final /* synthetic */ PotentialDeadlockInServiceInitializationInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public boolean visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                CallType callType = PotentialDeadlockInServiceInitializationInspection.access$getForbiddenMethodCallType(this.this$0, node);
                if (callType == null) {
                    return true;
                }
                CallType forbiddenCallType = callType;
                CallContextHolder callContextHolder = new CallContextHolder(null, 1, null);
                if (PotentialDeadlockInServiceInitializationInspection.access$isCalledDuringServiceInitialization(this.this$0, node, callContextHolder)) {
                    PotentialDeadlockInServiceInitializationInspection.access$registerProblem(this.this$0, node, forbiddenCallType, this.$holder, callContextHolder);
                }
                return true;
            }
        }, (Class[])classArray, (boolean)false, (int)8, null);
    }

    private final CallType getForbiddenMethodCallType(UCallExpression $this$getForbiddenMethodCallType) {
        return PotentialDeadlockInServiceInitializationInspectionKt.access$getRunReadActionMethods$p().uCallMatches($this$getForbiddenMethodCallType) ? CallType.READ : (PotentialDeadlockInServiceInitializationInspectionKt.access$getRunWriteActionMethods$p().uCallMatches($this$getForbiddenMethodCallType) ? CallType.WRITE : (PotentialDeadlockInServiceInitializationInspectionKt.access$getInvokeAndWaitMethods$p().uCallMatches($this$getForbiddenMethodCallType) ? CallType.INVOKE_AND_WAIT : null));
    }

    private final boolean isCalledDuringServiceInitialization(UCallExpression forbiddenCall, CallContextHolder callContextHolder) {
        UClass uClass = this.getContainingNonCompanionObjectClass((UElement)forbiddenCall);
        if (uClass == null) {
            return false;
        }
        UClass uClass2 = uClass;
        return ServiceUtil.isService(uClass2) && (this.isCalledDuringInit(forbiddenCall) || this.isInMethodCalledDuringInit(uClass2, forbiddenCall, callContextHolder) || this.isCalledDuringPersistentStateComponentInit(uClass2, forbiddenCall, callContextHolder));
    }

    private final UClass getContainingNonCompanionObjectClass(UElement $this$getContainingNonCompanionObjectClass) {
        UClass uClass;
        UClass uClass2 = UastUtils.getContainingUClass((UElement)$this$getContainingNonCompanionObjectClass);
        if (uClass2 == null) {
            return null;
        }
        UClass uClass3 = uClass2;
        if (Intrinsics.areEqual((Object)uClass3.getJavaPsi().getName(), (Object)"Companion")) {
            UElement $this$getParentOfType_u24default$iv = (UElement)uClass3;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            uClass = (UClass)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
        } else {
            uClass = uClass3;
        }
        return uClass;
    }

    private final boolean isCalledDuringInit(UCallExpression forbiddenCall) {
        return !this.isCalledInAnonymousClassOrLambda(forbiddenCall) && (this.isCalledInConstructor(forbiddenCall) || this.isCalledInInitBlock(forbiddenCall) || this.isCalledInFieldAssignment(forbiddenCall));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCalledInAnonymousClassOrLambda(UCallExpression forbiddenActionCall) {
        UElement $this$getParentOfType_u24default$iv = (UElement)forbiddenActionCall;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        if (UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UObjectLiteralExpression.class, (boolean)strict$iv) != null) return true;
        $this$getParentOfType_u24default$iv = (UElement)forbiddenActionCall;
        strict$iv = true;
        $i$f$getParentOfType = false;
        if (UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, ULambdaExpression.class, (boolean)strict$iv) == null) return false;
        return true;
    }

    private final boolean isCalledInConstructor(UCallExpression forbiddenCall) {
        UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)forbiddenCall));
        return uMethod != null ? uMethod.isConstructor() : false;
    }

    private final boolean isCalledInInitBlock(UCallExpression forbiddenCall) {
        UElement $this$getParentOfType_u24default$iv = (UElement)forbiddenCall;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        return UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UClassInitializer.class, (boolean)strict$iv) != null;
    }

    private final boolean isCalledInFieldAssignment(UCallExpression forbiddenCall) {
        UElement $this$getParentOfType_u24default$iv = (UElement)forbiddenCall;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        return UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UField.class, (boolean)strict$iv) != null;
    }

    private final boolean isInMethodCalledDuringInit(UClass serviceClass, UCallExpression forbiddenCall, CallContextHolder callContextHolder) {
        UClass uClass;
        UClass uClass2;
        block3: {
            if (this.isCalledInAnonymousClassOrLambda(forbiddenCall)) {
                return false;
            }
            UClass[] $this$firstOrNull$iv = serviceClass.getInnerClasses();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                UClass element$iv;
                UClass it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getJavaPsi().getName(), (Object)"Companion")) continue;
                uClass2 = element$iv;
                break block3;
            }
            uClass2 = null;
        }
        UClass companionObject = uClass2;
        List initializationElements = CollectionsKt.plus((Collection)this.getInitializationElements(serviceClass), (Iterable)((uClass = companionObject) != null && (uClass = this.getInitializationElements(uClass)) != null ? (Iterable)uClass : (Iterable)CollectionsKt.emptyList()));
        UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)forbiddenCall));
        if (uMethod == null) {
            return false;
        }
        UMethod containingMethod = uMethod;
        return this.isCalledInAnyOf(containingMethod, initializationElements, callContextHolder);
    }

    /*
     * WARNING - void declaration
     */
    private final List<UElement> getInitializationElements(UClass $this$getInitializationElements) {
        void $this$filterTo$iv$iv;
        UMethod[] $this$filter$iv = $this$getInitializationElements.getMethods();
        boolean $i$f$filter = false;
        UMethod[] uMethodArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!it.isConstructor()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)((List)destination$iv$iv)), (Iterable)ArraysKt.asList((Object[])$this$getInitializationElements.getFields())), (Iterable)ArraysKt.asList((Object[])$this$getInitializationElements.getInitializers()));
    }

    private final boolean isCalledInAnyOf(UMethod $this$isCalledInAnyOf, List<? extends UElement> potentialCallers, CallContextHolder callContextHolder) {
        UMethod checkedMethod = $this$isCalledInAnyOf;
        Ref.BooleanRef isCalledDuringInitialization = new Ref.BooleanRef();
        for (UElement uElement : potentialCallers) {
            uElement.accept(new UastVisitor(checkedMethod, this, isCalledDuringInitialization, callContextHolder, uElement){
                final /* synthetic */ UMethod $checkedMethod;
                final /* synthetic */ PotentialDeadlockInServiceInitializationInspection this$0;
                final /* synthetic */ Ref.BooleanRef $isCalledDuringInitialization;
                final /* synthetic */ CallContextHolder $callContextHolder;
                final /* synthetic */ UElement $potentialCaller;
                {
                    this.$checkedMethod = $checkedMethod;
                    this.this$0 = $receiver;
                    this.$isCalledDuringInitialization = $isCalledDuringInitialization;
                    this.$callContextHolder = $callContextHolder;
                    this.$potentialCaller = $potentialCaller;
                }

                public boolean visitCallExpression(UCallExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (Intrinsics.areEqual((Object)this.$checkedMethod, (Object)UResolvableKt.resolveToUElement((UResolvable)((UResolvable)node))) && !PotentialDeadlockInServiceInitializationInspection.access$isCalledInAnonymousClassOrLambda(this.this$0, node)) {
                        this.$isCalledDuringInitialization.element = true;
                        this.$callContextHolder.setValue(PotentialDeadlockInServiceInitializationInspection.access$getContextText(this.this$0, this.$checkedMethod, this.$potentialCaller));
                        return true;
                    }
                    return false;
                }

                public boolean visitElement(UElement node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    return false;
                }
            });
            if (!isCalledDuringInitialization.element) continue;
            break;
        }
        return isCalledDuringInitialization.element;
    }

    private final String getContextText(UMethod calledMethod, UElement caller) {
        String string;
        Object[] objectArray = caller;
        if (objectArray instanceof UMethod) {
            if (((UMethod)caller).isConstructor()) {
                var5_4 = new Object[]{((UMethod)caller).getName()};
                string = DevKitBundle.message("inspection.potential.deadlock.during.service.init.message.context.constructor", var5_4);
            } else {
                var5_4 = new Object[]{((UMethod)caller).getName()};
                string = DevKitBundle.message("inspection.potential.deadlock.during.service.init.message.context.method", var5_4);
            }
        } else if (objectArray instanceof UField) {
            var5_4 = new Object[]{((UField)caller).getName()};
            string = DevKitBundle.message("inspection.potential.deadlock.during.service.init.message.context.field", var5_4);
        } else if (objectArray instanceof UClassInitializer) {
            string = ((UClassInitializer)caller).isStatic() ? DevKitBundle.message("inspection.potential.deadlock.during.service.init.message.context.static.initializer", new Object[0]) : DevKitBundle.message("inspection.potential.deadlock.during.service.init.message.context.instance.initializer", new Object[0]);
        } else {
            return null;
        }
        String callerName = string;
        objectArray = new Object[]{"'" + calledMethod.getName() + "'", callerName};
        return DevKitBundle.message("inspection.potential.deadlock.during.service.init.message.context", objectArray);
    }

    private final boolean isCalledDuringPersistentStateComponentInit(UClass serviceClass, UCallExpression forbiddenCall, CallContextHolder callContextHolder) {
        return this.isPersistentStateComponent(serviceClass) && (this.isCalledDuringPersistentStateComponentInitMethods(forbiddenCall) || this.isInMethodCalledDuringPersistentStateComponentInit(serviceClass, forbiddenCall, callContextHolder));
    }

    private final boolean isPersistentStateComponent(UClass serviceClass) {
        PsiClass servicePsiClass = serviceClass.getJavaPsi();
        return JvmInheritanceUtil.isInheritor((JvmClass)((JvmClass)servicePsiClass), (String)PersistentStateComponent.class.getCanonicalName());
    }

    private final boolean isCalledDuringPersistentStateComponentInitMethods(UCallExpression forbiddenCall) {
        if (this.isCalledInAnonymousClassOrLambda(forbiddenCall)) {
            return false;
        }
        UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)forbiddenCall));
        if (uMethod == null) {
            return false;
        }
        UMethod containingMethod = uMethod;
        return ArraysKt.contains((Object[])PotentialDeadlockInServiceInitializationInspectionKt.access$getPERSISTENT_STATE_COMPONENT_INIT_METHOD_NAMES$p(), (Object)containingMethod.getName());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInMethodCalledDuringPersistentStateComponentInit(UClass serviceClass, UCallExpression forbiddenCall, CallContextHolder callContextHolder) {
        void $this$filterTo$iv$iv;
        if (this.isCalledInAnonymousClassOrLambda(forbiddenCall)) {
            return false;
        }
        UMethod[] $this$filter$iv = serviceClass.getMethods();
        boolean $i$f$filter = false;
        UMethod[] uMethodArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!ArraysKt.contains((Object[])PotentialDeadlockInServiceInitializationInspectionKt.access$getPERSISTENT_STATE_COMPONENT_INIT_METHOD_NAMES$p(), (Object)it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lifecycleMethods = (List)destination$iv$iv;
        UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)forbiddenCall));
        if (uMethod == null) {
            return false;
        }
        UMethod containingMethod = uMethod;
        return this.isCalledInAnyOf(containingMethod, lifecycleMethods, callContextHolder);
    }

    private final void registerProblem(UCallExpression uCallExpression, CallType actionType, ProblemsHolder holder, CallContextHolder callContextHolder) {
        UIdentifier uIdentifier = uCallExpression.getMethodIdentifier();
        if (uIdentifier == null || (uIdentifier = uIdentifier.getSourcePsi()) == null) {
            return;
        }
        UIdentifier anchor = uIdentifier;
        String string = callContextHolder.getValue();
        if (string == null) {
            string = "";
        }
        String callContext = string;
        String message = switch (WhenMappings.$EnumSwitchMapping$0[actionType.ordinal()]) {
            case 1 -> {
                Object[] var8_7 = new Object[]{callContext};
                yield DevKitBundle.message("inspection.potential.deadlock.during.service.init.message.read", var8_7);
            }
            case 2 -> {
                Object[] var8_7 = new Object[]{callContext};
                yield DevKitBundle.message("inspection.potential.deadlock.during.service.init.message.write", var8_7);
            }
            case 3 -> {
                Object[] var8_7 = new Object[]{callContext};
                yield DevKitBundle.message("inspection.potential.deadlock.during.service.init.message.invoke.and.wait", var8_7);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        holder.registerProblem((PsiElement)anchor, message, new LocalQuickFix[0]);
    }

    public static final /* synthetic */ CallType access$getForbiddenMethodCallType(PotentialDeadlockInServiceInitializationInspection $this, UCallExpression $receiver) {
        return $this.getForbiddenMethodCallType($receiver);
    }

    public static final /* synthetic */ boolean access$isCalledDuringServiceInitialization(PotentialDeadlockInServiceInitializationInspection $this, UCallExpression forbiddenCall, CallContextHolder callContextHolder) {
        return $this.isCalledDuringServiceInitialization(forbiddenCall, callContextHolder);
    }

    public static final /* synthetic */ void access$registerProblem(PotentialDeadlockInServiceInitializationInspection $this, UCallExpression uCallExpression, CallType actionType, ProblemsHolder holder, CallContextHolder callContextHolder) {
        $this.registerProblem(uCallExpression, actionType, holder, callContextHolder);
    }

    public static final /* synthetic */ boolean access$isCalledInAnonymousClassOrLambda(PotentialDeadlockInServiceInitializationInspection $this, UCallExpression forbiddenActionCall) {
        return $this.isCalledInAnonymousClassOrLambda(forbiddenActionCall);
    }

    public static final /* synthetic */ String access$getContextText(PotentialDeadlockInServiceInitializationInspection $this, UMethod calledMethod, UElement caller) {
        return $this.getContextText(calledMethod, caller);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/devkit/inspections/PotentialDeadlockInServiceInitializationInspection$CallContextHolder;", "", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "setValue", "intellij.devkit.core"})
    private static final class CallContextHolder {
        @Nullable
        private String value;

        public CallContextHolder(@Nls @Nullable String value) {
            this.value = value;
        }

        public /* synthetic */ CallContextHolder(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        @Nullable
        public final String getValue() {
            return this.value;
        }

        public final void setValue(@Nullable String string) {
            this.value = string;
        }

        public CallContextHolder() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/devkit/inspections/PotentialDeadlockInServiceInitializationInspection$CallType;", "", "<init>", "(Ljava/lang/String;I)V", "READ", "WRITE", "INVOKE_AND_WAIT", "intellij.devkit.core"})
    private static final class CallType
    extends Enum<CallType> {
        public static final /* enum */ CallType READ = new CallType();
        public static final /* enum */ CallType WRITE = new CallType();
        public static final /* enum */ CallType INVOKE_AND_WAIT = new CallType();
        private static final /* synthetic */ CallType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CallType[] values() {
            return (CallType[])$VALUES.clone();
        }

        public static CallType valueOf(String value) {
            return Enum.valueOf(CallType.class, value);
        }

        @NotNull
        public static EnumEntries<CallType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = callTypeArray = new CallType[]{CallType.READ, CallType.WRITE, CallType.INVOKE_AND_WAIT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CallType.values().length];
            try {
                nArray[CallType.READ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallType.WRITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallType.INVOKE_AND_WAIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

