/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;

final class PsiElementConcatenationInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    PsiElementConcatenationInspection() {
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PsiElementConcatenationInspection.$$$reportNull$$$0(0);
        }
        if (!DevKitInspectionUtil.isAllowed(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PsiElementConcatenationInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        if (!DevKitInspectionUtil.isClassAvailable(holder, PsiElementFactory.class.getName())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PsiElementConcatenationInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                String methodName;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((methodName = call.getMethodExpression().getReferenceName()) == null || !methodName.startsWith("create")) {
                    return;
                }
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (args.length == 0) {
                    return;
                }
                PsiExpression arg = args[0];
                PsiType argType = arg.getType();
                if (argType == null || !argType.equalsToText("java.lang.String")) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null || !PsiElementFactory.class.getName().equals(aClass.getQualifiedName())) {
                    return;
                }
                this.checkOperand(arg, new HashSet<PsiExpression>());
            }

            private void checkOperand(@Nullable PsiExpression operand, Set<PsiExpression> visited) {
                PsiPolyadicExpression polyadic;
                PsiClass aClass;
                PsiMethodCallExpression call;
                PsiMethod method;
                PsiCodeBlock block;
                PsiElement element;
                if (operand == null || !visited.add(operand)) {
                    return;
                }
                if (operand instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)operand).resolve()) instanceof PsiLocalVariable && ((PsiLocalVariable)element).getType().equalsToText("java.lang.String") && (block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class)) != null) {
                    PsiElement[] defs;
                    PsiElement[] psiElementArray = defs = DefUseUtil.getDefs((PsiCodeBlock)block, (PsiVariable)((PsiVariable)element), (PsiElement)operand);
                    int n = psiElementArray.length;
                    for (int i = 0; i < n; ++i) {
                        PsiAssignmentExpression assignment;
                        PsiElement def = psiElementArray[i];
                        if (def instanceof PsiLocalVariable) {
                            this.checkOperand(((PsiLocalVariable)def).getInitializer(), visited);
                        }
                        if (def instanceof PsiReferenceExpression && (assignment = ExpressionUtils.getAssignment((PsiElement)def.getParent())) != null && assignment.getLExpression() == def) {
                            this.checkOperand(assignment.getRExpression(), visited);
                        }
                        if (!(def instanceof PsiExpression)) continue;
                        this.checkOperand((PsiExpression)def, visited);
                    }
                }
                if (operand instanceof PsiMethodCallExpression && MethodUtils.isToString((PsiMethod)(method = (call = (PsiMethodCallExpression)operand).resolveMethod()))) {
                    this.checkOperand(call.getMethodExpression().getQualifierExpression(), visited);
                }
                if (InheritanceUtil.isInheritor((PsiClass)(aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)operand.getType())), (boolean)false, (String)PsiElement.class.getName())) {
                    holder.registerProblem((PsiElement)operand, DevKitBundle.message("inspections.psi.element.concat.psi.element", new Object[0]), new LocalQuickFix[]{new AddGetTextFix("getText")});
                }
                if (InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)PsiType.class.getName())) {
                    holder.registerProblem((PsiElement)operand, DevKitBundle.message("inspections.psi.element.concat.psi.type", new Object[0]), new LocalQuickFix[]{new AddGetTextFix("getCanonicalText")});
                }
                if (operand instanceof PsiPolyadicExpression && JavaTokenType.PLUS.equals((polyadic = (PsiPolyadicExpression)operand).getOperationTokenType())) {
                    for (PsiExpression op : polyadic.getOperands()) {
                        this.checkOperand(op, visited);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/idea/devkit/inspections/PsiElementConcatenationInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/PsiElementConcatenationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PsiElementConcatenationInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static final class AddGetTextFix
    implements LocalQuickFix {
        private final String myMethodName;

        private AddGetTextFix(String name) {
            this.myMethodName = name;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = DevKitBundle.message("inspections.psi.element.concat.add.get.text.name", this.myMethodName);
            if (string == null) {
                AddGetTextFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.psi.element.concat.add.get.text.family.name", new Object[0]);
            if (string == null) {
                AddGetTextFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                AddGetTextFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddGetTextFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor.getStartElement()) instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression replacement = factory.createExpressionFromText(ParenthesesUtils.getText((PsiExpression)expression, (int)2) + "." + this.myMethodName + "()", (PsiElement)expression);
            PsiElement parent = expression.getParent().getParent();
            if (parent instanceof PsiMethodCallExpression && MethodUtils.isToString((PsiMethod)((PsiMethodCallExpression)parent).resolveMethod())) {
                element = parent;
            }
            PsiElement result = element.replace((PsiElement)replacement);
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/PsiElementConcatenationInspection$AddGetTextFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PsiElementConcatenationInspection$AddGetTextFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

