/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ImplementOrExtendFix;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.RegistrationCheckerUtil;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;

final class RegistrationProblemsInspection
extends DevKitUastInspectionBase {
    RegistrationProblemsInspection() {
        super(UClass.class);
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        RegistrationCheckerUtil.RegistrationType registrationType;
        Set<PsiClass> componentClasses;
        PsiClass checkedClass;
        PsiIdentifier nameIdentifier;
        if (uClass == null) {
            RegistrationProblemsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            RegistrationProblemsInspection.$$$reportNull$$$0(1);
        }
        if (!((nameIdentifier = (checkedClass = uClass.getJavaPsi()).getNameIdentifier()) == null || checkedClass.getQualifiedName() == null || checkedClass.getContainingFile().getVirtualFile() == null || checkedClass.isInterface() || checkedClass.isEnum() || checkedClass.hasModifierProperty("private") || checkedClass.hasModifierProperty("protected") || PsiUtil.isInnerClass((PsiClass)checkedClass) || (componentClasses = RegistrationCheckerUtil.getRegistrationTypes(checkedClass, registrationType = RegistrationCheckerUtil.RegistrationType.ALL)) == null || componentClasses.isEmpty())) {
            PsiElement sourcePsi = uClass.getSourcePsi();
            if (sourcePsi == null) {
                return null;
            }
            ProblemsHolder holder = RegistrationProblemsInspection.createProblemsHolder((UElement)uClass, manager, isOnTheFly);
            for (PsiClass componentClass : componentClasses) {
                if (!ActionType.ACTION.myClassName.equals(componentClass.getQualifiedName()) || checkedClass.isInheritor(componentClass, true)) continue;
                ModCommandAction fix = sourcePsi.getLanguage().is((Language)JavaLanguage.INSTANCE) ? ImplementOrExtendFix.createFix((PsiClass)checkedClass, (PsiClass)componentClass) : null;
                ProblemHolderUtilKt.registerUProblem((ProblemsHolder)holder, (UDeclaration)uClass, (String)DevKitBundle.message("inspections.registration.problems.incompatible.message", componentClass.getQualifiedName()), (LocalQuickFix[])LocalQuickFix.notNullElements((LocalQuickFix)LocalQuickFix.from((ModCommandAction)fix)));
            }
            if (ActionType.ACTION.isOfType(checkedClass) && !RegistrationProblemsInspection.hasNoArgConstructor(checkedClass)) {
                LocalQuickFix[] localQuickFixArray;
                if (sourcePsi.getLanguage().is((Language)JavaLanguage.INSTANCE)) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = new CreateConstructorFix(checkedClass, isOnTheFly);
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                ProblemHolderUtilKt.registerUProblem((ProblemsHolder)holder, (UDeclaration)uClass, (String)DevKitBundle.message("inspections.registration.problems.missing.noarg.ctor", new Object[0]), (LocalQuickFix[])fixes);
            }
            if (checkedClass.hasModifierProperty("abstract")) {
                ProblemHolderUtilKt.registerUProblem((ProblemsHolder)holder, (UDeclaration)uClass, (String)DevKitBundle.message("inspections.registration.problems.abstract", new Object[0]), (LocalQuickFix[])new LocalQuickFix[0]);
            }
            return holder.getResultsArray();
        }
        return null;
    }

    private static boolean hasNoArgConstructor(PsiClass checkedClass) {
        PsiMethod[] constructors = checkedClass.getConstructors();
        if (constructors.length == 0) {
            return true;
        }
        for (PsiMethod constructor : constructors) {
            if (!constructor.getParameterList().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "ComponentRegistrationProblems";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "uClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/inspections/RegistrationProblemsInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CreateConstructorFix
    implements LocalQuickFix {
        protected final SmartPsiElementPointer<? extends PsiElement> myPointer;
        protected final boolean myOnTheFly;

        CreateConstructorFix(@NotNull PsiClass aClass, boolean isOnTheFly) {
            if (aClass == null) {
                CreateConstructorFix.$$$reportNull$$$0(0);
            }
            this.myPointer = SmartPointerManager.createPointer((PsiElement)aClass);
            this.myOnTheFly = isOnTheFly;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                CreateConstructorFix.$$$reportNull$$$0(1);
            }
            if (previewDescriptor == null) {
                CreateConstructorFix.$$$reportNull$$$0(2);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                CreateConstructorFix.$$$reportNull$$$0(3);
            }
            return intentionPreviewInfo;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiClass clazz;
            boolean external;
            PsiElement element;
            if (project == null) {
                CreateConstructorFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                CreateConstructorFix.$$$reportNull$$$0(5);
            }
            if ((element = this.myPointer.getElement()) == null || !element.isValid()) {
                return;
            }
            boolean bl = external = descriptor.getPsiElement().getContainingFile() != element.getContainingFile();
            if (external) {
                clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
                if (!ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{element.getContainingFile().getVirtualFile()})) {
                    String className = clazz != null ? clazz.getQualifiedName() : element.getContainingFile().getName();
                    Messages.showErrorDialog((Project)project, (String)DevKitBundle.message("inspections.registration.problems.quickfix.read-only", className), (String)CommonBundle.getErrorTitle());
                    return;
                }
            }
            try {
                if (!(element instanceof PsiClass)) {
                    return;
                }
                clazz = (PsiClass)element;
                PsiMethod ctor = JavaPsiFacade.getInstance((Project)clazz.getProject()).getElementFactory().createConstructor();
                PsiUtil.setModifierProperty((PsiModifierListOwner)ctor, (String)"public", (boolean)true);
                PsiMethod[] constructors = clazz.getConstructors();
                ctor = constructors.length > 0 ? (PsiMethod)clazz.addBefore((PsiElement)ctor, (PsiElement)constructors[0]) : (PsiMethod)clazz.add((PsiElement)ctor);
                if (this.myOnTheFly) {
                    ctor.navigate(true);
                }
            }
            catch (IncorrectOperationException e) {
                Logger.getInstance(this.getClass()).error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.registration.problems.quickfix.create.constructor", new Object[0]);
            if (string == null) {
                CreateConstructorFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/RegistrationProblemsInspection$CreateConstructorFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/RegistrationProblemsInspection$CreateConstructorFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 3: 
                case 6: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 6 -> new IllegalStateException(string);
            };
        }
    }
}

